/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.MainDex;

@MainDex
public abstract class CommandLine {
    private static final List<ResetListener> sResetListeners = new ArrayList<ResetListener>();
    private static final AtomicReference<CommandLine> sCommandLine = new AtomicReference();
    private static final String TAG = "CommandLine";
    private static final String SWITCH_PREFIX = "--";
    private static final String SWITCH_TERMINATOR = "--";
    private static final String SWITCH_VALUE_SEPARATOR = "=";

    @VisibleForTesting
    public abstract boolean hasSwitch(String var1);

    public abstract String getSwitchValue(String var1);

    public String getSwitchValue(String switchString, String defaultValue) {
        String value = this.getSwitchValue(switchString);
        return TextUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    @VisibleForTesting
    public abstract void appendSwitch(String var1);

    public abstract void appendSwitchWithValue(String var1, String var2);

    public abstract void appendSwitchesAndArguments(String[] var1);

    public boolean isNativeImplementation() {
        return false;
    }

    public static boolean isInitialized() {
        return sCommandLine.get() != null;
    }

    @VisibleForTesting
    public static CommandLine getInstance() {
        CommandLine commandLine = sCommandLine.get();
        assert (commandLine != null);
        return commandLine;
    }

    public static void init(String[] args) {
        CommandLine.setInstance(new JavaCommandLine(args));
    }

    public static void initFromFile(String file) {
        char[] buffer = CommandLine.readUtf8FileFullyCrashIfTooBig(file, 65536);
        CommandLine.init(buffer == null ? null : CommandLine.tokenizeQuotedAruments(buffer));
    }

    @VisibleForTesting
    public static void reset() {
        CommandLine.setInstance(null);
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (ResetListener listener : sResetListeners) {
                    listener.onCommandLineReset();
                }
            }
        });
    }

    public static void addResetListener(ResetListener listener) {
        sResetListeners.add(listener);
    }

    public static void removeResetListener(ResetListener listener) {
        sResetListeners.remove(listener);
    }

    public static String[] tokenizeQuotedAruments(char[] buffer) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder arg = null;
        boolean noQuote = false;
        int singleQuote = 39;
        int doubleQuote = 34;
        char currentQuote = '\u0000';
        for (char c : buffer) {
            if (currentQuote == '\u0000' && (c == '\'' || c == '\"') || c == currentQuote) {
                if (arg != null && arg.length() > 0 && arg.charAt(arg.length() - 1) == '\\') {
                    arg.setCharAt(arg.length() - 1, c);
                    continue;
                }
                currentQuote = currentQuote == '\u0000' ? c : (char)'\u0000';
                continue;
            }
            if (currentQuote == '\u0000' && Character.isWhitespace(c)) {
                if (arg == null) continue;
                args.add(arg.toString());
                arg = null;
                continue;
            }
            if (arg == null) {
                arg = new StringBuilder();
            }
            arg.append(c);
        }
        if (arg != null) {
            if (currentQuote != '\u0000') {
                Log.w((String)TAG, (String)("Unterminated quoted string: " + arg));
            }
            args.add(arg.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    public static void enableNativeProxy() {
        sCommandLine.set(new NativeCommandLine());
    }

    public static String[] getJavaSwitchesOrNull() {
        CommandLine commandLine = sCommandLine.get();
        if (commandLine != null) {
            assert (!commandLine.isNativeImplementation());
            return ((JavaCommandLine)commandLine).getCommandLineArguments();
        }
        return null;
    }

    private static void setInstance(CommandLine commandLine) {
        CommandLine oldCommandLine = sCommandLine.getAndSet(commandLine);
        if (oldCommandLine != null && oldCommandLine.isNativeImplementation()) {
            CommandLine.nativeReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] readUtf8FileFullyCrashIfTooBig(String fileName, int sizeLimit) {
        Reader reader = null;
        File f = new File(fileName);
        long fileLength = f.length();
        if (fileLength == 0L) {
            return null;
        }
        if (fileLength > (long)sizeLimit) {
            throw new RuntimeException("File " + fileName + " length " + fileLength + " exceeds limit " + sizeLimit);
        }
        try {
            char[] buffer = new char[(int)fileLength];
            reader = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
            int charsRead = reader.read(buffer);
            assert (!reader.ready());
            char[] cArray = charsRead < buffer.length ? Arrays.copyOfRange(buffer, 0, charsRead) : buffer;
            return cArray;
        }
        catch (FileNotFoundException e) {
            char[] cArray = null;
            return cArray;
        }
        catch (IOException e) {
            char[] cArray = null;
            return cArray;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to close file reader.", (Throwable)e);
            }
        }
    }

    private CommandLine() {
    }

    private static native void nativeReset();

    private static native boolean nativeHasSwitch(String var0);

    private static native String nativeGetSwitchValue(String var0);

    private static native void nativeAppendSwitch(String var0);

    private static native void nativeAppendSwitchWithValue(String var0, String var1);

    private static native void nativeAppendSwitchesAndArguments(String[] var0);

    private static class NativeCommandLine
    extends CommandLine {
        private NativeCommandLine() {
        }

        @Override
        public boolean hasSwitch(String switchString) {
            return CommandLine.nativeHasSwitch(switchString);
        }

        @Override
        public String getSwitchValue(String switchString) {
            return CommandLine.nativeGetSwitchValue(switchString);
        }

        @Override
        public void appendSwitch(String switchString) {
            CommandLine.nativeAppendSwitch(switchString);
        }

        @Override
        public void appendSwitchWithValue(String switchString, String value) {
            CommandLine.nativeAppendSwitchWithValue(switchString, value);
        }

        @Override
        public void appendSwitchesAndArguments(String[] array) {
            CommandLine.nativeAppendSwitchesAndArguments(array);
        }

        @Override
        public boolean isNativeImplementation() {
            return true;
        }
    }

    private static class JavaCommandLine
    extends CommandLine {
        private HashMap<String, String> mSwitches = new HashMap();
        private ArrayList<String> mArgs = new ArrayList();
        private int mArgsBegin = 1;

        JavaCommandLine(String[] args) {
            if (args == null || args.length == 0 || args[0] == null) {
                this.mArgs.add("");
            } else {
                this.mArgs.add(args[0]);
                this.appendSwitchesInternal(args, 1);
            }
            assert (this.mArgs.size() > 0);
        }

        private String[] getCommandLineArguments() {
            return this.mArgs.toArray(new String[this.mArgs.size()]);
        }

        @Override
        public boolean hasSwitch(String switchString) {
            return this.mSwitches.containsKey(switchString);
        }

        @Override
        public String getSwitchValue(String switchString) {
            String value = this.mSwitches.get(switchString);
            return value == null || value.isEmpty() ? null : value;
        }

        @Override
        public void appendSwitch(String switchString) {
            this.appendSwitchWithValue(switchString, null);
        }

        @Override
        public void appendSwitchWithValue(String switchString, String value) {
            this.mSwitches.put(switchString, value == null ? "" : value);
            String combinedSwitchString = "--" + switchString;
            if (value != null && !value.isEmpty()) {
                combinedSwitchString = combinedSwitchString + CommandLine.SWITCH_VALUE_SEPARATOR + value;
            }
            this.mArgs.add(this.mArgsBegin++, combinedSwitchString);
        }

        @Override
        public void appendSwitchesAndArguments(String[] array) {
            this.appendSwitchesInternal(array, 0);
        }

        private void appendSwitchesInternal(String[] array, int skipCount) {
            boolean parseSwitches = true;
            for (String arg : array) {
                if (skipCount > 0) {
                    --skipCount;
                    continue;
                }
                if (arg.equals("--")) {
                    parseSwitches = false;
                }
                if (parseSwitches && arg.startsWith("--")) {
                    String[] parts = arg.split(CommandLine.SWITCH_VALUE_SEPARATOR, 2);
                    String value = parts.length > 1 ? parts[1] : null;
                    this.appendSwitchWithValue(parts[0].substring("--".length()), value);
                    continue;
                }
                this.mArgs.add(arg);
            }
        }
    }

    public static interface ResetListener {
        public void onCommandLineReset();
    }
}

