/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.chromium.base.ContextUtils;
import org.chromium.base.StreamUtil;
import org.chromium.base.annotations.CalledByNative;

public abstract class ContentUriUtils {
    private static final String TAG = "ContentUriUtils";
    private static FileProviderUtil sFileProviderUtil;
    private static final Object sLock;

    private ContentUriUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileProviderUtil(FileProviderUtil util) {
        Object object = sLock;
        synchronized (object) {
            sFileProviderUtil = util;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri getContentUriFromFile(File file) {
        Object object = sLock;
        synchronized (object) {
            if (sFileProviderUtil != null) {
                return sFileProviderUtil.getContentUriFromFile(file);
            }
        }
        return null;
    }

    @CalledByNative
    public static int openContentUriForRead(String uriString) {
        AssetFileDescriptor afd = ContentUriUtils.getAssetFileDescriptor(uriString);
        if (afd != null) {
            return afd.getParcelFileDescriptor().detachFd();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static boolean contentUriExists(String uriString) {
        AssetFileDescriptor asf = null;
        try {
            asf = ContentUriUtils.getAssetFileDescriptor(uriString);
            boolean bl = asf != null;
            return bl;
        }
        finally {
            if (asf != null) {
                try {
                    asf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @CalledByNative
    public static String getMimeType(String uriString) {
        ContentResolver resolver = ContextUtils.getApplicationContext().getContentResolver();
        Uri uri = Uri.parse((String)uriString);
        if (ContentUriUtils.isVirtualDocument(uri)) {
            String[] streamTypes = resolver.getStreamTypes(uri, "*/*");
            return streamTypes != null && streamTypes.length > 0 ? streamTypes[0] : null;
        }
        return resolver.getType(uri);
    }

    private static AssetFileDescriptor getAssetFileDescriptor(String uriString) {
        block9: {
            ContentResolver resolver = ContextUtils.getApplicationContext().getContentResolver();
            Uri uri = Uri.parse((String)uriString);
            try {
                if (ContentUriUtils.isVirtualDocument(uri)) {
                    String[] streamTypes = resolver.getStreamTypes(uri, "*/*");
                    if (streamTypes == null || streamTypes.length <= 0) break block9;
                    AssetFileDescriptor afd = resolver.openTypedAssetFileDescriptor(uri, streamTypes[0], null);
                    if (afd != null && afd.getStartOffset() != 0L) {
                        try {
                            afd.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SecurityException("Cannot open files with non-zero offset type.");
                    }
                    return afd;
                }
                ParcelFileDescriptor pfd = resolver.openFileDescriptor(uri, "r");
                if (pfd != null) {
                    return new AssetFileDescriptor(pfd, 0L, -1L);
                }
            }
            catch (FileNotFoundException e) {
                Log.w((String)TAG, (String)("Cannot find content uri: " + uriString), (Throwable)e);
            }
            catch (SecurityException e) {
                Log.w((String)TAG, (String)("Cannot open content uri: " + uriString), (Throwable)e);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Unknown content uri: " + uriString), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDisplayName(Uri uri, Context context, String columnField) {
        if (uri == null) {
            return "";
        }
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, null, null, null, null);
            if (cursor != null && cursor.getCount() >= 1) {
                String ext;
                String[] mimeTypes;
                cursor.moveToFirst();
                int displayNameIndex = cursor.getColumnIndex(columnField);
                if (displayNameIndex == -1) {
                    String string = "";
                    StreamUtil.closeQuietly((Closeable)cursor);
                    return string;
                }
                String displayName = cursor.getString(displayNameIndex);
                if (ContentUriUtils.hasVirtualFlag(cursor) && (mimeTypes = contentResolver.getStreamTypes(uri, "*/*")) != null && mimeTypes.length > 0 && (ext = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeTypes[0])) != null) {
                    displayName = displayName + "." + ext;
                }
                String string = displayName;
                StreamUtil.closeQuietly((Closeable)cursor);
                return string;
            }
            StreamUtil.closeQuietly((Closeable)cursor);
            return "";
        }
        catch (NullPointerException e) {
            String string = "";
            return string;
        }
        finally {
            StreamUtil.closeQuietly(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isVirtualDocument(Uri uri) {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        if (uri == null) {
            return false;
        }
        if (!DocumentsContract.isDocumentUri((Context)ContextUtils.getApplicationContext(), (Uri)uri)) {
            return false;
        }
        ContentResolver contentResolver = ContextUtils.getApplicationContext().getContentResolver();
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, null, null, null, null);
            if (cursor != null && cursor.getCount() >= 1) {
                cursor.moveToFirst();
                boolean bl = ContentUriUtils.hasVirtualFlag(cursor);
                StreamUtil.closeQuietly((Closeable)cursor);
                return bl;
            }
            StreamUtil.closeQuietly((Closeable)cursor);
        }
        catch (NullPointerException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtil.closeQuietly(cursor);
        }
        return false;
    }

    private static boolean hasVirtualFlag(Cursor cursor) {
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        int index = cursor.getColumnIndex("flags");
        return index > -1 && (cursor.getLong(index) & 0x200L) != 0L;
    }

    static {
        sLock = new Object();
    }

    public static interface FileProviderUtil {
        public Uri getContentUriFromFile(File var1);
    }
}

