/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chromium.base.CommandLine;
import org.chromium.base.TimeUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.annotations.SuppressFBWarnings;

@JNINamespace(value="base::android")
@MainDex
public class EarlyTraceEvent {
    private static final String TRACE_CONFIG_FILENAME = "/data/local/chrome-trace-config.json";
    @VisibleForTesting
    static final int STATE_DISABLED = 0;
    @VisibleForTesting
    static final int STATE_ENABLED = 1;
    @VisibleForTesting
    static final int STATE_FINISHING = 2;
    @VisibleForTesting
    static final int STATE_FINISHED = 3;
    private static final Object sLock = new Object();
    @VisibleForTesting
    static volatile int sState = 0;
    @VisibleForTesting
    static List<Event> sCompletedEvents;
    @VisibleForTesting
    static Map<String, Event> sPendingEvents;

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    static void maybeEnable() {
        boolean shouldEnable = false;
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (CommandLine.isInitialized() && CommandLine.getInstance().hasSwitch("trace-startup")) {
                shouldEnable = true;
            } else {
                try {
                    shouldEnable = new File(TRACE_CONFIG_FILENAME).exists();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        if (shouldEnable) {
            EarlyTraceEvent.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void enable() {
        Object object = sLock;
        synchronized (object) {
            if (sState != 0) {
                return;
            }
            sCompletedEvents = new ArrayList<Event>();
            sPendingEvents = new HashMap<String, Event>();
            sState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disable() {
        Object object = sLock;
        synchronized (object) {
            if (sState != 1) {
                return;
            }
            sState = 2;
            EarlyTraceEvent.maybeFinishLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void begin(String name) {
        Event conflictingEvent;
        if (sState != 1) {
            return;
        }
        Event event = new Event(name);
        Object object = sLock;
        synchronized (object) {
            if (sState != 1) {
                return;
            }
            conflictingEvent = sPendingEvents.put(name, event);
        }
        if (conflictingEvent != null) {
            throw new IllegalArgumentException("Multiple pending trace events can't have the same name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String name) {
        int state = sState;
        if (state != 1 && state != 2) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (sState != 1 && sState != 2) {
                return;
            }
            Event event = sPendingEvents.remove(name);
            if (event == null) {
                return;
            }
            event.end();
            sCompletedEvents.add(event);
            if (sState == 2) {
                EarlyTraceEvent.maybeFinishLocked();
            }
        }
    }

    private static void maybeFinishLocked() {
        if (!sPendingEvents.isEmpty()) {
            return;
        }
        sState = 3;
        EarlyTraceEvent.dumpEvents(sCompletedEvents);
        sCompletedEvents = null;
        sPendingEvents = null;
    }

    private static void dumpEvents(List<Event> events) {
        long nativeNowUs = TimeUtils.nativeGetTimeTicksNowUs();
        long javaNowUs = SystemClock.elapsedRealtime() * 1000L;
        long offsetMs = (nativeNowUs - javaNowUs) / 1000L;
        for (Event event : events) {
            EarlyTraceEvent.nativeRecordEarlyEvent(event.mName, event.mBeginTimeMs + offsetMs, event.mEndTimeMs + offsetMs, event.mThreadId);
        }
    }

    private static native void nativeRecordEarlyEvent(String var0, long var1, long var3, int var5);

    @VisibleForTesting
    static final class Event {
        final String mName;
        final int mThreadId;
        final long mBeginTimeMs;
        long mEndTimeMs;

        Event(String name) {
            this.mName = name;
            this.mThreadId = Process.myTid();
            this.mBeginTimeMs = SystemClock.elapsedRealtime();
        }

        void end() {
            assert (this.mEndTimeMs == 0L);
            this.mEndTimeMs = SystemClock.elapsedRealtime();
        }
    }
}

