/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.chromium.base.CommandLine;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;

public class LocaleUtils {
    private static final Map<String, String> LANGUAGE_MAP_FOR_CHROMIUM;
    private static final Map<String, String> LANGUAGE_MAP_FOR_ANDROID;

    private LocaleUtils() {
    }

    public static String getUpdatedLanguageForChromium(String language) {
        String updatedLanguageCode = LANGUAGE_MAP_FOR_CHROMIUM.get(language);
        return updatedLanguageCode == null ? language : updatedLanguageCode;
    }

    @TargetApi(value=21)
    @VisibleForTesting
    public static Locale getUpdatedLocaleForChromium(Locale locale) {
        String languageForChrome = LANGUAGE_MAP_FOR_CHROMIUM.get(locale.getLanguage());
        if (languageForChrome == null) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(languageForChrome).build();
    }

    public static String getUpdatedLanguageForAndroid(String language) {
        String updatedLanguageCode = LANGUAGE_MAP_FOR_ANDROID.get(language);
        return updatedLanguageCode == null ? language : updatedLanguageCode;
    }

    @TargetApi(value=21)
    @VisibleForTesting
    public static Locale getUpdatedLocaleForAndroid(Locale locale) {
        String languageForAndroid = LANGUAGE_MAP_FOR_ANDROID.get(locale.getLanguage());
        if (languageForAndroid == null) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(languageForAndroid).build();
    }

    public static Locale forLanguageTagCompat(String languageTag) {
        String[] tag = languageTag.split("-");
        if (tag.length == 0) {
            return new Locale("");
        }
        String language = LocaleUtils.getUpdatedLanguageForAndroid(tag[0]);
        if (language.length() != 2 && language.length() != 3 || language.equals("und")) {
            return new Locale("");
        }
        if (tag.length == 1) {
            return new Locale(language);
        }
        String country = tag[1];
        if (country.length() != 2 && country.length() != 3) {
            return new Locale(language);
        }
        return new Locale(language, country);
    }

    public static Locale forLanguageTag(String languageTag) {
        if (Build.VERSION.SDK_INT >= 21) {
            Locale locale = Locale.forLanguageTag(languageTag);
            return LocaleUtils.getUpdatedLocaleForAndroid(locale);
        }
        return LocaleUtils.forLanguageTagCompat(languageTag);
    }

    public static String toLanguageTag(Locale locale) {
        String language = LocaleUtils.getUpdatedLanguageForChromium(locale.getLanguage());
        String country = locale.getCountry();
        if (language.equals("no") && country.equals("NO") && locale.getVariant().equals("NY")) {
            return "nn-NO";
        }
        return country.isEmpty() ? language : language + "-" + country;
    }

    @TargetApi(value=24)
    public static String toLanguageTags(LocaleList localeList) {
        ArrayList<String> newLocaleList = new ArrayList<String>();
        for (int i = 0; i < localeList.size(); ++i) {
            Locale locale = LocaleUtils.getUpdatedLocaleForChromium(localeList.get(i));
            newLocaleList.add(LocaleUtils.toLanguageTag(locale));
        }
        return TextUtils.join((CharSequence)",", newLocaleList);
    }

    @CalledByNative
    public static String getDefaultLocaleString() {
        return LocaleUtils.toLanguageTag(Locale.getDefault());
    }

    public static String getDefaultLocaleListString() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleUtils.toLanguageTags(LocaleList.getDefault());
        }
        return LocaleUtils.getDefaultLocaleString();
    }

    @CalledByNative
    private static String getDefaultCountryCode() {
        CommandLine commandLine = CommandLine.getInstance();
        return commandLine.hasSwitch("default-country-code") ? commandLine.getSwitchValue("default-country-code") : Locale.getDefault().getCountry();
    }

    static {
        HashMap<String, String> mapForChromium = new HashMap<String, String>();
        mapForChromium.put("iw", "he");
        mapForChromium.put("ji", "yi");
        mapForChromium.put("in", "id");
        mapForChromium.put("tl", "fil");
        LANGUAGE_MAP_FOR_CHROMIUM = Collections.unmodifiableMap(mapForChromium);
        HashMap<String, String> mapForAndroid = new HashMap<String, String>();
        mapForAndroid.put("und", "");
        mapForAndroid.put("fil", "tl");
        LANGUAGE_MAP_FOR_ANDROID = Collections.unmodifiableMap(mapForAndroid);
    }
}

