/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.SuppressFBWarnings;

public class NonThreadSafe {
    private Long mThreadId;

    public NonThreadSafe() {
        this.ensureThreadIdAssigned();
    }

    @SuppressFBWarnings(value={"CHROMIUM_SYNCHRONIZED_METHOD"})
    @VisibleForTesting
    public synchronized void detachFromThread() {
        this.mThreadId = null;
    }

    @SuppressFBWarnings(value={"CHROMIUM_SYNCHRONIZED_METHOD"})
    public synchronized boolean calledOnValidThread() {
        this.ensureThreadIdAssigned();
        return this.mThreadId.equals(Thread.currentThread().getId());
    }

    private void ensureThreadIdAssigned() {
        if (this.mThreadId == null) {
            this.mThreadId = Thread.currentThread().getId();
        }
    }
}

