/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class PowerMonitor {
    private static PowerMonitor sInstance;
    private boolean mIsBatteryPower;

    public static void createForTests() {
        sInstance = new PowerMonitor();
    }

    public static void create() {
        ThreadUtils.assertOnUiThread();
        if (sInstance != null) {
            return;
        }
        Context context = ContextUtils.getApplicationContext();
        sInstance = new PowerMonitor();
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatusIntent = context.registerReceiver(null, ifilter);
        if (batteryStatusIntent != null) {
            PowerMonitor.onBatteryChargingChanged(batteryStatusIntent);
        }
        IntentFilter powerConnectedFilter = new IntentFilter();
        powerConnectedFilter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        powerConnectedFilter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                PowerMonitor.onBatteryChargingChanged(intent);
            }
        }, powerConnectedFilter);
    }

    private PowerMonitor() {
    }

    private static void onBatteryChargingChanged(Intent intent) {
        assert (sInstance != null);
        int chargePlug = intent.getIntExtra("plugged", -1);
        PowerMonitor.sInstance.mIsBatteryPower = chargePlug != 2 && chargePlug != 1;
        PowerMonitor.nativeOnBatteryChargingChanged();
    }

    @CalledByNative
    private static boolean isBatteryPower() {
        if (sInstance == null) {
            PowerMonitor.create();
        }
        return PowerMonitor.sInstance.mIsBatteryPower;
    }

    private static native void nativeOnBatteryChargingChanged();
}

