/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.chromium.base.BuildConfig;
import org.chromium.base.BuildInfo;
import org.chromium.base.ContextUtils;
import org.chromium.base.LocaleUtils;
import org.chromium.base.Log;
import org.chromium.base.PathUtils;
import org.chromium.base.StreamUtil;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TraceEvent;

public class ResourceExtractor {
    private static final String TAG = "base";
    private static final String ICU_DATA_FILENAME = "icudtl.dat";
    private static final String V8_NATIVES_DATA_FILENAME = "natives_blob.bin";
    private static final String V8_SNAPSHOT_DATA_FILENAME = "snapshot_blob.bin";
    private static final String FALLBACK_LOCALE = "en-US";
    private ExtractTask mExtractTask;
    private final String[] mAssetsToExtract = ResourceExtractor.detectFilesToExtract();
    private static ResourceExtractor sInstance;

    public static ResourceExtractor get() {
        if (sInstance == null) {
            sInstance = new ResourceExtractor();
        }
        return sInstance;
    }

    private static String[] detectFilesToExtract() {
        Locale defaultLocale = Locale.getDefault();
        String language = LocaleUtils.getUpdatedLanguageForChromium(defaultLocale.getLanguage());
        ArrayList<String> activeLocalePakFiles = new ArrayList<String>(6);
        for (String locale : BuildConfig.COMPRESSED_LOCALES) {
            if (!locale.startsWith(language)) continue;
            activeLocalePakFiles.add(locale + ".pak");
        }
        if (activeLocalePakFiles.isEmpty() && BuildConfig.COMPRESSED_LOCALES.length > 0) {
            assert (Arrays.asList(BuildConfig.COMPRESSED_LOCALES).contains(FALLBACK_LOCALE));
            activeLocalePakFiles.add("en-US.pak");
        }
        return activeLocalePakFiles.toArray(new String[activeLocalePakFiles.size()]);
    }

    public void waitForCompletion() {
        block4: {
            if (ResourceExtractor.shouldSkipPakExtraction()) {
                return;
            }
            assert (this.mExtractTask != null);
            try {
                this.mExtractTask.get();
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void addCompletionCallback(Runnable callback) {
        ThreadUtils.assertOnUiThread();
        Handler handler = new Handler(Looper.getMainLooper());
        if (ResourceExtractor.shouldSkipPakExtraction()) {
            handler.post(callback);
            return;
        }
        assert (this.mExtractTask != null);
        assert (!this.mExtractTask.isCancelled());
        if (this.mExtractTask.getStatus() == AsyncTask.Status.FINISHED) {
            handler.post(callback);
        } else {
            this.mExtractTask.mCompletionCallbacks.add(callback);
        }
    }

    public void startExtractingResources() {
        if (this.mExtractTask != null) {
            return;
        }
        if (ResourceExtractor.shouldSkipPakExtraction()) {
            return;
        }
        this.mExtractTask = new ExtractTask();
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private File getAppDataDir() {
        return new File(PathUtils.getDataDirectory());
    }

    private File getOutputDir() {
        return new File(this.getAppDataDir(), "paks");
    }

    private static void deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            Log.w(TAG, "Unable to remove %s", file.getName());
        }
    }

    private void deleteFiles(String[] existingFileNames) {
        ResourceExtractor.deleteFile(new File(this.getAppDataDir(), ICU_DATA_FILENAME));
        ResourceExtractor.deleteFile(new File(this.getAppDataDir(), V8_NATIVES_DATA_FILENAME));
        ResourceExtractor.deleteFile(new File(this.getAppDataDir(), V8_SNAPSHOT_DATA_FILENAME));
        if (existingFileNames != null) {
            for (String fileName : existingFileNames) {
                ResourceExtractor.deleteFile(new File(this.getOutputDir(), fileName));
            }
        }
    }

    private static boolean shouldSkipPakExtraction() {
        return ResourceExtractor.get().mAssetsToExtract.length == 0;
    }

    private class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        private static final int BUFFER_SIZE = 16384;
        private final List<Runnable> mCompletionCallbacks = new ArrayList<Runnable>();

        private ExtractTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void extractResourceHelper(InputStream is, File outFile, byte[] buffer) throws IOException {
            FileOutputStream os = null;
            File tmpOutputFile = new File(outFile.getPath() + ".tmp");
            try {
                os = new FileOutputStream(tmpOutputFile);
                Log.i(ResourceExtractor.TAG, "Extracting resource %s", outFile);
                int count = 0;
                while ((count = is.read(buffer, 0, 16384)) != -1) {
                    ((OutputStream)os).write(buffer, 0, count);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeQuietly(os);
                StreamUtil.closeQuietly(is);
                throw throwable;
            }
            StreamUtil.closeQuietly(os);
            StreamUtil.closeQuietly(is);
            if (!tmpOutputFile.renameTo(outFile)) {
                throw new IOException();
            }
        }

        private void doInBackgroundImpl() {
            boolean allFilesExist;
            File outputDir = ResourceExtractor.this.getOutputDir();
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new RuntimeException();
            }
            String extractSuffix = BuildInfo.getExtractedFileSuffix();
            String[] existingFileNames = outputDir.list();
            boolean bl = allFilesExist = existingFileNames != null;
            if (allFilesExist) {
                List<String> existingFiles = Arrays.asList(existingFileNames);
                for (String assetName : ResourceExtractor.this.mAssetsToExtract) {
                    allFilesExist &= existingFiles.contains(assetName + extractSuffix);
                }
            }
            if (allFilesExist) {
                return;
            }
            ResourceExtractor.this.deleteFiles(existingFileNames);
            byte[] buffer = new byte[16384];
            for (String assetName : ResourceExtractor.this.mAssetsToExtract) {
                File output = new File(outputDir, assetName + extractSuffix);
                TraceEvent.begin("ExtractResource");
                try {
                    InputStream inputStream = ContextUtils.getApplicationContext().getAssets().open(assetName);
                    this.extractResourceHelper(inputStream, output, buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    TraceEvent.end("ExtractResource");
                }
            }
        }

        protected Void doInBackground(Void ... unused) {
            TraceEvent.begin("ResourceExtractor.ExtractTask.doInBackground");
            try {
                this.doInBackgroundImpl();
            }
            finally {
                TraceEvent.end("ResourceExtractor.ExtractTask.doInBackground");
            }
            return null;
        }

        private void onPostExecuteImpl() {
            for (int i = 0; i < this.mCompletionCallbacks.size(); ++i) {
                this.mCompletionCallbacks.get(i).run();
            }
            this.mCompletionCallbacks.clear();
        }

        protected void onPostExecute(Void result) {
            TraceEvent.begin("ResourceExtractor.ExtractTask.onPostExecute");
            try {
                this.onPostExecuteImpl();
            }
            finally {
                TraceEvent.end("ResourceExtractor.ExtractTask.onPostExecute");
            }
        }
    }
}

