/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import org.chromium.base.StreamUtil;

@SuppressLint(value={"SecureRandom"})
public class SecureRandomInitializer {
    private static final int NUM_RANDOM_BYTES = 16;

    public static void initialize(SecureRandom generator) throws IOException {
        FileInputStream fis = null;
        try {
            byte[] seedBytes = new byte[16];
            fis = new FileInputStream("/dev/urandom");
            if (fis.read(seedBytes) != seedBytes.length) {
                throw new IOException("Failed to get enough random data.");
            }
            generator.setSeed(seedBytes);
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(fis);
            throw throwable;
        }
        StreamUtil.closeQuietly(fis);
    }
}

