/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.MainDex;

@MainDex
class SystemMessageHandler
extends Handler {
    private static final String TAG = "cr.SysMessageHandler";
    private static final int SCHEDULED_WORK = 1;
    private static final int DELAYED_SCHEDULED_WORK = 2;
    private long mMessagePumpDelegateNative;
    private long mMessagePumpNative;
    private long mDelayedScheduledTimeTicks;

    protected SystemMessageHandler(long messagePumpDelegateNative, long messagePumpNative) {
        this.mMessagePumpDelegateNative = messagePumpDelegateNative;
        this.mMessagePumpNative = messagePumpNative;
    }

    public void handleMessage(Message msg) {
        if (msg.what == 2) {
            this.mDelayedScheduledTimeTicks = 0L;
        }
        this.nativeDoRunLoopOnce(this.mMessagePumpDelegateNative, this.mMessagePumpNative, this.mDelayedScheduledTimeTicks);
    }

    @CalledByNative
    private void scheduleWork() {
        this.sendMessage(this.obtainAsyncMessage(1));
    }

    @CalledByNative
    private void scheduleDelayedWork(long delayedTimeTicks, long millis) {
        if (this.mDelayedScheduledTimeTicks != 0L) {
            this.removeMessages(2);
        }
        this.mDelayedScheduledTimeTicks = delayedTimeTicks;
        this.sendMessageDelayed(this.obtainAsyncMessage(2), millis);
    }

    @CalledByNative
    private void removeAllPendingMessages() {
        this.removeMessages(1);
        this.removeMessages(2);
    }

    private Message obtainAsyncMessage(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        MessageCompat.setAsynchronous(msg, true);
        return msg;
    }

    @CalledByNative
    private static SystemMessageHandler create(long messagePumpDelegateNative, long messagePumpNative) {
        return new SystemMessageHandler(messagePumpDelegateNative, messagePumpNative);
    }

    private native void nativeDoRunLoopOnce(long var1, long var3, long var5);

    private static class MessageCompat {
        static final MessageWrapperImpl IMPL = Build.VERSION.SDK_INT >= 22 ? new LollipopMr1MessageWrapperImpl() : new LegacyMessageWrapperImpl();

        private MessageCompat() {
        }

        public static void setAsynchronous(Message message, boolean async) {
            IMPL.setAsynchronous(message, async);
        }

        static class LegacyMessageWrapperImpl
        implements MessageWrapperImpl {
            private Method mMessageMethodSetAsynchronous;

            LegacyMessageWrapperImpl() {
                try {
                    Class<?> messageClass = Class.forName("android.os.Message");
                    this.mMessageMethodSetAsynchronous = messageClass.getMethod("setAsynchronous", Boolean.TYPE);
                }
                catch (ClassNotFoundException e) {
                    Log.e(SystemMessageHandler.TAG, "Failed to find android.os.Message class", e);
                }
                catch (NoSuchMethodException e) {
                    Log.e(SystemMessageHandler.TAG, "Failed to load Message.setAsynchronous method", e);
                }
                catch (RuntimeException e) {
                    Log.e(SystemMessageHandler.TAG, "Exception while loading Message.setAsynchronous method", e);
                }
            }

            @Override
            public void setAsynchronous(Message msg, boolean async) {
                if (this.mMessageMethodSetAsynchronous == null) {
                    return;
                }
                try {
                    this.mMessageMethodSetAsynchronous.invoke((Object)msg, async);
                }
                catch (IllegalAccessException e) {
                    Log.e(SystemMessageHandler.TAG, "Illegal access to async message creation, disabling.", new Object[0]);
                    this.mMessageMethodSetAsynchronous = null;
                }
                catch (IllegalArgumentException e) {
                    Log.e(SystemMessageHandler.TAG, "Illegal argument for async message creation, disabling.", new Object[0]);
                    this.mMessageMethodSetAsynchronous = null;
                }
                catch (InvocationTargetException e) {
                    Log.e(SystemMessageHandler.TAG, "Invocation exception during async message creation, disabling.", new Object[0]);
                    this.mMessageMethodSetAsynchronous = null;
                }
                catch (RuntimeException e) {
                    Log.e(SystemMessageHandler.TAG, "Runtime exception during async message creation, disabling.", new Object[0]);
                    this.mMessageMethodSetAsynchronous = null;
                }
            }
        }

        static class LollipopMr1MessageWrapperImpl
        implements MessageWrapperImpl {
            LollipopMr1MessageWrapperImpl() {
            }

            @Override
            @SuppressLint(value={"NewApi"})
            public void setAsynchronous(Message msg, boolean async) {
                msg.setAsynchronous(async);
            }
        }

        static interface MessageWrapperImpl {
            public void setAsynchronous(Message var1, boolean var2);
        }
    }
}

