/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Parcel;
import android.os.Parcelable;
import org.chromium.base.annotations.CalledByNative;

public class UnguessableToken
implements Parcelable {
    private final long mHigh;
    private final long mLow;
    public static final Parcelable.Creator<UnguessableToken> CREATOR = new Parcelable.Creator<UnguessableToken>(){

        public UnguessableToken createFromParcel(Parcel source) {
            long high = source.readLong();
            long low = source.readLong();
            if (high == 0L || low == 0L) {
                return null;
            }
            return new UnguessableToken(high, low);
        }

        public UnguessableToken[] newArray(int size) {
            return new UnguessableToken[size];
        }
    };

    private UnguessableToken(long high, long low) {
        this.mHigh = high;
        this.mLow = low;
    }

    @CalledByNative
    private static UnguessableToken create(long high, long low) {
        return new UnguessableToken(high, low);
    }

    @CalledByNative
    public long getHighForSerialization() {
        return this.mHigh;
    }

    @CalledByNative
    public long getLowForSerialization() {
        return this.mLow;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mHigh);
        dest.writeLong(this.mLow);
    }

    @CalledByNative
    private UnguessableToken parcelAndUnparcelForTesting() {
        Parcel parcel = Parcel.obtain();
        this.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        UnguessableToken token = (UnguessableToken)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return token;
    }
}

