/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.os.Bundle;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;
import org.chromium.base.Log;
import org.chromium.base.PathUtils;
import org.chromium.base.annotations.SuppressFBWarnings;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.NativeLibraries;

class ModernLinker
extends Linker {
    private static final String TAG = "LibraryLoader";
    private boolean mInitialized;
    private boolean mWaitForSharedRelros;
    private HashMap<String, Linker.LibInfo> mSharedRelros;
    private Bundle mSharedRelrosBundle;
    private boolean mInBrowserProcess = true;
    private long mBaseLoadAddress = -1L;
    private long mCurrentLoadAddress = -1L;
    private boolean mPrepareLibraryLoadCalled;
    private HashMap<String, Linker.LibInfo> mLoadedLibraries;

    private ModernLinker() {
    }

    static Linker create() {
        return new ModernLinker();
    }

    private void ensureInitializedLocked() {
        assert (Thread.holdsLock(this.mLock));
        assert (NativeLibraries.sUseLinker);
        if (!this.mInitialized) {
            ModernLinker.loadLinkerJniLibrary();
            this.mInitialized = true;
        }
    }

    @Override
    public boolean isUsingBrowserSharedRelros() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareLibraryLoad() {
        assert (NativeLibraries.sUseLinker);
        Object object = this.mLock;
        synchronized (object) {
            assert (!this.mPrepareLibraryLoadCalled);
            this.ensureInitializedLocked();
            if (this.mInBrowserProcess) {
                this.setupBaseLoadAddressLocked();
                this.mSharedRelros = new HashMap();
            }
            this.mLoadedLibraries = new HashMap();
            this.mCurrentLoadAddress = this.mBaseLoadAddress;
            this.mPrepareLibraryLoadCalled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishLibraryLoad() {
        Object object = this.mLock;
        synchronized (object) {
            assert (this.mPrepareLibraryLoadCalled);
            if (!this.mInBrowserProcess && this.mSharedRelros != null) {
                this.closeLibInfoMap(this.mSharedRelros);
                this.mSharedRelros = null;
            }
            if (NativeLibraries.sEnableLinkerTests) {
                this.runTestRunnerClassForTesting(0, this.mInBrowserProcess);
            }
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    private void waitForSharedRelrosLocked() {
        assert (Thread.holdsLock(this.mLock));
        if (this.mSharedRelros != null) {
            return;
        }
        long startTime = 0L;
        while (this.mSharedRelros == null) {
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useSharedRelros(Bundle bundle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSharedRelros = this.createLibInfoMapFromBundle(bundle);
            this.mLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mInBrowserProcess) {
                return null;
            }
            if (this.mSharedRelrosBundle == null && this.mSharedRelros != null) {
                this.mSharedRelrosBundle = this.createBundleFromLibInfoMap(this.mSharedRelros);
            }
            return this.mSharedRelrosBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            this.mInBrowserProcess = false;
            this.mWaitForSharedRelros = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initServiceProcess(long baseLoadAddress) {
        Object object = this.mLock;
        synchronized (object) {
            assert (!this.mPrepareLibraryLoadCalled);
            this.mInBrowserProcess = false;
            this.mWaitForSharedRelros = true;
            this.mBaseLoadAddress = baseLoadAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBaseLoadAddress() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            this.setupBaseLoadAddressLocked();
            return this.mBaseLoadAddress;
        }
    }

    private void setupBaseLoadAddressLocked() {
        assert (Thread.holdsLock(this.mLock));
        if (this.mBaseLoadAddress == -1L) {
            this.mBaseLoadAddress = this.getRandomBaseLoadAddress();
        }
        if (this.mBaseLoadAddress == 0L) {
            Log.w(TAG, "Disabling shared RELROs due address space pressure", new Object[0]);
            this.mWaitForSharedRelros = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void loadLibraryImpl(@Nullable String zipFilePath, String libFilePath, boolean isFixedAddressPermitted) {
        Object object = this.mLock;
        synchronized (object) {
            String dlopenExtPath;
            assert (this.mPrepareLibraryLoadCalled);
            if (zipFilePath != null) {
                String cpuAbi = ModernLinker.nativeGetCpuAbi();
                dlopenExtPath = zipFilePath + "!/lib/" + cpuAbi + "/crazy." + libFilePath;
            } else {
                dlopenExtPath = libFilePath;
            }
            if (this.mLoadedLibraries.containsKey(dlopenExtPath)) {
                return;
            }
            long loadAddress = 0L;
            if (!this.mInBrowserProcess && this.mWaitForSharedRelros && isFixedAddressPermitted && (loadAddress = this.mCurrentLoadAddress) > this.mBaseLoadAddress + 0xC000000L) {
                String errorMessage = "Load address outside reservation, for: " + libFilePath;
                Log.e(TAG, errorMessage, new Object[0]);
                throw new UnsatisfiedLinkError(errorMessage);
            }
            Linker.LibInfo libInfo = new Linker.LibInfo();
            if (this.mInBrowserProcess && this.mCurrentLoadAddress != 0L) {
                String relroPath = PathUtils.getDataDirectory() + "/RELRO:" + libFilePath;
                if (ModernLinker.nativeCreateSharedRelro(dlopenExtPath, this.mCurrentLoadAddress, relroPath, libInfo)) {
                    this.mSharedRelros.put(dlopenExtPath, libInfo);
                } else {
                    String errorMessage = "Unable to create shared relro: " + relroPath;
                    Log.w(TAG, errorMessage, new Object[0]);
                }
            } else if (!this.mInBrowserProcess && this.mCurrentLoadAddress != 0L && this.mWaitForSharedRelros) {
                this.waitForSharedRelrosLocked();
                if (this.mSharedRelros.containsKey(dlopenExtPath)) {
                    libInfo = this.mSharedRelros.get(dlopenExtPath);
                }
            }
            if (!ModernLinker.nativeLoadLibrary(dlopenExtPath, loadAddress, libInfo)) {
                String errorMessage = "Unable to load library: " + dlopenExtPath;
                Log.e(TAG, errorMessage, new Object[0]);
                throw new UnsatisfiedLinkError(errorMessage);
            }
            if (NativeLibraries.sEnableLinkerTests) {
                String tag = this.mInBrowserProcess ? "BROWSER_LIBRARY_ADDRESS" : "RENDERER_LIBRARY_ADDRESS";
                Log.i(TAG, String.format(Locale.US, "%s: %s %x", tag, libFilePath, libInfo.mLoadAddress), new Object[0]);
            }
            if (loadAddress != 0L && this.mCurrentLoadAddress != 0L) {
                this.mCurrentLoadAddress = libInfo.mLoadAddress + libInfo.mLoadSize + 0x1000000L;
            }
            this.mLoadedLibraries.put(dlopenExtPath, libInfo);
        }
    }

    private static native String nativeGetCpuAbi();

    private static native boolean nativeLoadLibrary(String var0, long var1, Linker.LibInfo var3);

    private static native boolean nativeCreateSharedRelro(String var0, long var1, String var3, Linker.LibInfo var4);
}

