/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.base.metrics.RecordUserAction;

public class CachedMetrics {
    public static void commitCachedMetrics() {
        for (CachedHistogram event : CachedHistogram.sEvents) {
            event.commitAndClear();
        }
    }

    public static class TimesHistogramSample
    extends CachedHistogram {
        private final List<Long> mSamples = new ArrayList<Long>();
        private final TimeUnit mTimeUnit;

        public TimesHistogramSample(String histogramName, TimeUnit timeUnit) {
            super(histogramName);
            this.mTimeUnit = timeUnit;
        }

        public void record(long sample) {
            if (LibraryLoader.isInitialized()) {
                this.recordWithNative(sample);
            } else {
                this.mSamples.add(sample);
            }
        }

        private void recordWithNative(long sample) {
            RecordHistogram.recordTimesHistogram(this.mHistogramName, sample, this.mTimeUnit);
        }

        @Override
        protected void commitAndClear() {
            for (Long sample : this.mSamples) {
                this.recordWithNative(sample);
            }
            this.mSamples.clear();
        }
    }

    public static class EnumeratedHistogramSample
    extends CachedHistogram {
        private final List<Integer> mSamples = new ArrayList<Integer>();
        private final int mMaxValue;

        public EnumeratedHistogramSample(String histogramName, int maxValue) {
            super(histogramName);
            this.mMaxValue = maxValue;
        }

        public void record(int sample) {
            if (LibraryLoader.isInitialized()) {
                this.recordWithNative(sample);
            } else {
                this.mSamples.add(sample);
            }
        }

        private void recordWithNative(int sample) {
            RecordHistogram.recordEnumeratedHistogram(this.mHistogramName, sample, this.mMaxValue);
        }

        @Override
        protected void commitAndClear() {
            for (Integer sample : this.mSamples) {
                this.recordWithNative(sample);
            }
            this.mSamples.clear();
        }
    }

    public static class SparseHistogramSample
    extends CachedHistogram {
        private final List<Integer> mSamples = new ArrayList<Integer>();

        public SparseHistogramSample(String histogramName) {
            super(histogramName);
        }

        public void record(int sample) {
            if (LibraryLoader.isInitialized()) {
                this.recordWithNative(sample);
            } else {
                this.mSamples.add(sample);
            }
        }

        private void recordWithNative(int sample) {
            RecordHistogram.recordSparseSlowlyHistogram(this.mHistogramName, sample);
        }

        @Override
        protected void commitAndClear() {
            for (Integer sample : this.mSamples) {
                this.recordWithNative(sample);
            }
            this.mSamples.clear();
        }
    }

    public static class ActionEvent
    extends CachedHistogram {
        private int mCount;

        public ActionEvent(String actionName) {
            super(actionName);
        }

        public void record() {
            if (LibraryLoader.isInitialized()) {
                this.recordWithNative();
            } else {
                ++this.mCount;
            }
        }

        private void recordWithNative() {
            RecordUserAction.record(this.mHistogramName);
        }

        @Override
        protected void commitAndClear() {
            while (this.mCount > 0) {
                this.recordWithNative();
                --this.mCount;
            }
        }
    }

    private static abstract class CachedHistogram {
        private static final List<CachedHistogram> sEvents = new ArrayList<CachedHistogram>();
        protected final String mHistogramName;

        protected CachedHistogram(String histogramName) {
            this.mHistogramName = histogramName;
            sEvents.add(this);
        }

        protected abstract void commitAndClear();
    }
}

