/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class RecordHistogram {
    private static Throwable sDisabledBy;
    private static Map<String, Long> sCache;

    @VisibleForTesting
    public static void setDisabledForTests(boolean disabled) {
        if (disabled && sDisabledBy != null) {
            throw new IllegalStateException("Histograms are already disabled.", sDisabledBy);
        }
        sDisabledBy = disabled ? new Throwable() : null;
    }

    private static long getCachedHistogramKey(String name) {
        Long key = sCache.get(name);
        return key == null ? 0L : key;
    }

    public static void recordBooleanHistogram(String name, boolean sample) {
        if (sDisabledBy != null) {
            return;
        }
        long key = RecordHistogram.getCachedHistogramKey(name);
        long result = RecordHistogram.nativeRecordBooleanHistogram(name, key, sample);
        if (result != key) {
            sCache.put(name, result);
        }
    }

    public static void recordEnumeratedHistogram(String name, int sample, int boundary) {
        if (sDisabledBy != null) {
            return;
        }
        long key = RecordHistogram.getCachedHistogramKey(name);
        long result = RecordHistogram.nativeRecordEnumeratedHistogram(name, key, sample, boundary);
        if (result != key) {
            sCache.put(name, result);
        }
    }

    public static void recordCountHistogram(String name, int sample) {
        RecordHistogram.recordCustomCountHistogram(name, sample, 1, 1000000, 50);
    }

    public static void recordCount100Histogram(String name, int sample) {
        RecordHistogram.recordCustomCountHistogram(name, sample, 1, 100, 50);
    }

    public static void recordCount1000Histogram(String name, int sample) {
        RecordHistogram.recordCustomCountHistogram(name, sample, 1, 1000, 50);
    }

    public static void recordCustomCountHistogram(String name, int sample, int min, int max, int numBuckets) {
        if (sDisabledBy != null) {
            return;
        }
        long key = RecordHistogram.getCachedHistogramKey(name);
        long result = RecordHistogram.nativeRecordCustomCountHistogram(name, key, sample, min, max, numBuckets);
        if (result != key) {
            sCache.put(name, result);
        }
    }

    public static void recordLinearCountHistogram(String name, int sample, int min, int max, int numBuckets) {
        if (sDisabledBy != null) {
            return;
        }
        long key = RecordHistogram.getCachedHistogramKey(name);
        long result = RecordHistogram.nativeRecordLinearCountHistogram(name, key, sample, min, max, numBuckets);
        if (result != key) {
            sCache.put(name, result);
        }
    }

    public static void recordPercentageHistogram(String name, int sample) {
        if (sDisabledBy != null) {
            return;
        }
        long key = RecordHistogram.getCachedHistogramKey(name);
        long result = RecordHistogram.nativeRecordEnumeratedHistogram(name, key, sample, 101);
        if (result != key) {
            sCache.put(name, result);
        }
    }

    public static void recordSparseSlowlyHistogram(String name, int sample) {
        if (sDisabledBy != null) {
            return;
        }
        long key = RecordHistogram.getCachedHistogramKey(name);
        long result = RecordHistogram.nativeRecordSparseHistogram(name, key, sample);
        if (result != key) {
            sCache.put(name, result);
        }
    }

    public static void recordTimesHistogram(String name, long duration, TimeUnit timeUnit) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), 1L, TimeUnit.SECONDS.toMillis(10L), 50);
    }

    public static void recordMediumTimesHistogram(String name, long duration, TimeUnit timeUnit) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), 10L, TimeUnit.MINUTES.toMillis(3L), 50);
    }

    public static void recordLongTimesHistogram(String name, long duration, TimeUnit timeUnit) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), 1L, TimeUnit.HOURS.toMillis(1L), 50);
    }

    public static void recordCustomTimesHistogram(String name, long duration, long min, long max, TimeUnit timeUnit, int numBuckets) {
        RecordHistogram.recordCustomTimesHistogramMilliseconds(name, timeUnit.toMillis(duration), timeUnit.toMillis(min), timeUnit.toMillis(max), numBuckets);
    }

    public static void recordMemoryKBHistogram(String name, int sizeInKB) {
        RecordHistogram.recordCustomCountHistogram(name, sizeInKB, 1000, 500000, 50);
    }

    private static int clampToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    private static void recordCustomTimesHistogramMilliseconds(String name, long duration, long min, long max, int numBuckets) {
        if (sDisabledBy != null) {
            return;
        }
        long key = RecordHistogram.getCachedHistogramKey(name);
        long result = RecordHistogram.nativeRecordCustomTimesHistogramMilliseconds(name, key, RecordHistogram.clampToInt(duration), RecordHistogram.clampToInt(min), RecordHistogram.clampToInt(max), numBuckets);
        if (result != key) {
            sCache.put(name, result);
        }
    }

    @VisibleForTesting
    public static int getHistogramValueCountForTesting(String name, int sample) {
        return RecordHistogram.nativeGetHistogramValueCountForTesting(name, sample);
    }

    public static void initialize() {
        if (sDisabledBy != null) {
            return;
        }
        RecordHistogram.nativeInitialize();
    }

    private static native long nativeRecordCustomTimesHistogramMilliseconds(String var0, long var1, int var3, int var4, int var5, int var6);

    private static native long nativeRecordBooleanHistogram(String var0, long var1, boolean var3);

    private static native long nativeRecordEnumeratedHistogram(String var0, long var1, int var3, int var4);

    private static native long nativeRecordCustomCountHistogram(String var0, long var1, int var3, int var4, int var5, int var6);

    private static native long nativeRecordLinearCountHistogram(String var0, long var1, int var3, int var4, int var5, int var6);

    private static native long nativeRecordSparseHistogram(String var0, long var1, int var3);

    private static native int nativeGetHistogramValueCountForTesting(String var0, int var1);

    private static native void nativeInitialize();

    static {
        sCache = Collections.synchronizedMap(new HashMap());
    }
}

