/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class RecordUserAction {
    private static Throwable sDisabledBy;

    @VisibleForTesting
    public static void setDisabledForTests(boolean disabled) {
        if (disabled && sDisabledBy != null) {
            throw new IllegalStateException("UserActions are already disabled.", sDisabledBy);
        }
        sDisabledBy = disabled ? new Throwable() : null;
    }

    public static void record(final String action) {
        if (sDisabledBy != null) {
            return;
        }
        if (ThreadUtils.runningOnUiThread()) {
            RecordUserAction.nativeRecordUserAction(action);
            return;
        }
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RecordUserAction.nativeRecordUserAction(action);
            }
        });
    }

    private static native void nativeRecordUserAction(String var0);
}

