/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.process_launcher;

import android.content.Intent;
import android.util.SparseArray;
import javax.annotation.concurrent.GuardedBy;

public class ChildProcessCreationParams {
    private static final String EXTRA_LIBRARY_PROCESS_TYPE = "org.chromium.content.common.child_service_params.library_process_type";
    public static final int DEFAULT_ID = 0;
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static final SparseArray<ChildProcessCreationParams> sParamMap = new SparseArray();
    @GuardedBy(value="sLock")
    private static int sNextId = 1;
    private final String mPackageName;
    private final boolean mIsExternalService;
    private final int mLibraryProcessType;
    private final boolean mBindToCallerCheck;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDefault(ChildProcessCreationParams params) {
        Object object = sLock;
        synchronized (object) {
            sParamMap.append(0, (Object)params);
        }
    }

    public static ChildProcessCreationParams getDefault() {
        return ChildProcessCreationParams.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int register(ChildProcessCreationParams params) {
        assert (params != null);
        int id = -1;
        Object object = sLock;
        synchronized (object) {
            id = sNextId++;
            sParamMap.append(id, (Object)params);
        }
        assert (id > 0);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(int id) {
        assert (id > 0);
        Object object = sLock;
        synchronized (object) {
            sParamMap.delete(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChildProcessCreationParams get(int id) {
        assert (id >= 0);
        Object object = sLock;
        synchronized (object) {
            return (ChildProcessCreationParams)sParamMap.get(id);
        }
    }

    public ChildProcessCreationParams(String packageName, boolean isExternalService, int libraryProcessType, boolean bindToCallerCheck) {
        this.mPackageName = packageName;
        this.mIsExternalService = isExternalService;
        this.mLibraryProcessType = libraryProcessType;
        this.mBindToCallerCheck = bindToCallerCheck;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public boolean getIsExternalService() {
        return this.mIsExternalService;
    }

    public int getLibraryProcessType() {
        return this.mLibraryProcessType;
    }

    public boolean getBindToCallerCheck() {
        return this.mBindToCallerCheck;
    }

    public void addIntentExtras(Intent intent) {
        intent.putExtra(EXTRA_LIBRARY_PROCESS_TYPE, this.mLibraryProcessType);
    }

    public static int getLibraryProcessType(Intent intent) {
        return intent.getIntExtra(EXTRA_LIBRARY_PROCESS_TYPE, 2);
    }
}

