/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Process;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import java.util.Iterator;
import java.util.List;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android::cellular_signal_strength")
public class AndroidCellularSignalStrength {
    @TargetApi(value=18)
    @CalledByNative
    public static int getSignalStrengthDbm() {
        List<CellInfo> cellInfos = AndroidCellularSignalStrength.getRegisteredCellInfo();
        return cellInfos == null || cellInfos.size() != 1 ? Integer.MIN_VALUE : AndroidCellularSignalStrength.getSignalStrengthDbm(cellInfos.get(0));
    }

    @TargetApi(value=18)
    @CalledByNative
    public static int getSignalStrengthLevel() {
        List<CellInfo> cellInfos = AndroidCellularSignalStrength.getRegisteredCellInfo();
        return cellInfos == null || cellInfos.size() != 1 ? Integer.MIN_VALUE : AndroidCellularSignalStrength.getSignalStrengthLevel(cellInfos.get(0));
    }

    private static boolean isAPIAvailable() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        try {
            return ContextUtils.getApplicationContext().checkPermission("android.permission.ACCESS_COARSE_LOCATION", Process.myPid(), Process.myUid()) == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @TargetApi(value=18)
    private static List<CellInfo> getRegisteredCellInfo() {
        if (!AndroidCellularSignalStrength.isAPIAvailable()) {
            return null;
        }
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
        if (telephonyManager == null) {
            return null;
        }
        List cellInfos = telephonyManager.getAllCellInfo();
        if (cellInfos == null) {
            return null;
        }
        Iterator iter = cellInfos.iterator();
        while (iter.hasNext()) {
            if (((CellInfo)iter.next()).isRegistered()) continue;
            iter.remove();
        }
        return cellInfos;
    }

    @TargetApi(value=18)
    private static int getSignalStrengthDbm(CellInfo cellInfo) {
        if (cellInfo instanceof CellInfoCdma) {
            return ((CellInfoCdma)cellInfo).getCellSignalStrength().getDbm();
        }
        if (cellInfo instanceof CellInfoGsm) {
            return ((CellInfoGsm)cellInfo).getCellSignalStrength().getDbm();
        }
        if (cellInfo instanceof CellInfoLte) {
            return ((CellInfoLte)cellInfo).getCellSignalStrength().getDbm();
        }
        if (cellInfo instanceof CellInfoWcdma) {
            return ((CellInfoWcdma)cellInfo).getCellSignalStrength().getDbm();
        }
        return Integer.MIN_VALUE;
    }

    @TargetApi(value=18)
    private static int getSignalStrengthLevel(CellInfo cellInfo) {
        if (cellInfo instanceof CellInfoCdma) {
            return ((CellInfoCdma)cellInfo).getCellSignalStrength().getLevel();
        }
        if (cellInfo instanceof CellInfoGsm) {
            return ((CellInfoGsm)cellInfo).getCellSignalStrength().getLevel();
        }
        if (cellInfo instanceof CellInfoLte) {
            return ((CellInfoLte)cellInfo).getCellSignalStrength().getLevel();
        }
        if (cellInfo instanceof CellInfoWcdma) {
            return ((CellInfoWcdma)cellInfo).getCellSignalStrength().getLevel();
        }
        return Integer.MIN_VALUE;
    }
}

