/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.os.Build;
import android.security.KeyChain;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLConnection;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.List;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.CalledByNativeUnchecked;
import org.chromium.net.AndroidCertVerifyResult;
import org.chromium.net.X509Util;

class AndroidNetworkLibrary {
    private static final String TAG = "AndroidNetworkLibrary";

    AndroidNetworkLibrary() {
    }

    @CalledByNative
    public static boolean storeKeyPair(byte[] publicKey, byte[] privateKey) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.putExtra("PKEY", privateKey);
            intent.putExtra("KEY", publicKey);
            intent.addFlags(0x10000000);
            ContextUtils.getApplicationContext().startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            Log.w((String)TAG, (String)("could not store key pair: " + (Object)((Object)e)));
            return false;
        }
    }

    @CalledByNative
    public static String getMimeTypeFromExtension(String extension) {
        return URLConnection.guessContentTypeFromName("foo." + extension);
    }

    @CalledByNative
    public static boolean haveOnlyLoopbackAddresses() {
        Enumeration<NetworkInterface> list = null;
        try {
            list = NetworkInterface.getNetworkInterfaces();
            if (list == null) {
                return false;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("could not get network interfaces: " + e));
            return false;
        }
        while (list.hasMoreElements()) {
            NetworkInterface netIf = list.nextElement();
            try {
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                return false;
            }
            catch (SocketException e) {
            }
        }
        return true;
    }

    @CalledByNative
    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, String authType, String host) {
        try {
            return X509Util.verifyServerCertificates(certChain, authType, host);
        }
        catch (KeyStoreException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (NoSuchAlgorithmException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (IllegalArgumentException e) {
            return new AndroidCertVerifyResult(-1);
        }
    }

    @CalledByNativeUnchecked
    public static void addTestRootCertificate(byte[] rootCert) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.addTestRootCertificate(rootCert);
    }

    @CalledByNativeUnchecked
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.clearTestRootCertificates();
    }

    @CalledByNative
    private static String getNetworkCountryIso() {
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getNetworkCountryIso();
    }

    @CalledByNative
    private static String getNetworkOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getNetworkOperator();
    }

    @CalledByNative
    private static String getSimOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getSimOperator();
    }

    @CalledByNative
    private static boolean getIsRoaming() {
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isRoaming();
    }

    @TargetApi(value=23)
    @CalledByNative
    private static boolean getIsCaptivePortal() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(17);
    }

    @CalledByNative
    public static String getWifiSSID() {
        String ssid;
        WifiInfo wifiInfo;
        Intent intent = ContextUtils.getApplicationContext().registerReceiver(null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
        if (intent != null && (wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo")) != null && (ssid = wifiInfo.getSSID()) != null) {
            return ssid;
        }
        return "";
    }

    @TargetApi(value=24)
    @CalledByNative
    private static boolean isCleartextPermitted(String host) {
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkSecurityPolicy policy = NetworkSecurityPolicy.getInstance();
            if (Build.VERSION.SDK_INT >= 24) {
                return policy.isCleartextTrafficPermitted(host);
            }
            return policy.isCleartextTrafficPermitted();
        }
        return true;
    }

    @TargetApi(value=23)
    @CalledByNative
    private static byte[][] getDnsServers() {
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return new byte[0][0];
        }
        Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return new byte[0][0];
        }
        LinkProperties linkProperties = connectivityManager.getLinkProperties(network);
        if (linkProperties == null) {
            return new byte[0][0];
        }
        List dnsServersList = linkProperties.getDnsServers();
        byte[][] dnsServers = new byte[dnsServersList.size()][];
        for (int i = 0; i < dnsServersList.size(); ++i) {
            dnsServers[i] = ((InetAddress)dnsServersList.get(i)).getAddress();
        }
        return dnsServers;
    }
}

