/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.net.AndroidNetworkLibrary;
import org.chromium.net.NetworkChangeNotifier;

@SuppressLint(value={"NewApi"})
public class NetworkChangeNotifierAutoDetect
extends BroadcastReceiver {
    private static final String TAG = "NetworkChangeNotifierAutoDetect";
    private static final int UNKNOWN_LINK_SPEED = -1;
    private final NetworkConnectivityIntentFilter mIntentFilter;
    private final Observer mObserver;
    private final RegistrationPolicy mRegistrationPolicy;
    private ConnectivityManagerDelegate mConnectivityManagerDelegate;
    private WifiManagerDelegate mWifiManagerDelegate;
    private final MyNetworkCallback mNetworkCallback;
    private final NetworkRequest mNetworkRequest;
    private boolean mRegistered;
    private int mConnectionType;
    private String mWifiSSID;
    private double mMaxBandwidthMbps;
    private int mMaxBandwidthConnectionType;
    private boolean mIgnoreNextBroadcast;
    private boolean mShouldSignalObserver;

    @TargetApi(value=21)
    public NetworkChangeNotifierAutoDetect(Observer observer, RegistrationPolicy policy) {
        ThreadUtils.assertOnUiThread();
        this.mObserver = observer;
        this.mConnectivityManagerDelegate = new ConnectivityManagerDelegate(ContextUtils.getApplicationContext());
        this.mWifiManagerDelegate = new WifiManagerDelegate(ContextUtils.getApplicationContext());
        if (Build.VERSION.SDK_INT >= 21) {
            this.mNetworkCallback = new MyNetworkCallback();
            this.mNetworkRequest = new NetworkRequest.Builder().addCapability(12).removeCapability(15).build();
        } else {
            this.mNetworkCallback = null;
            this.mNetworkRequest = null;
        }
        NetworkState networkState = this.getCurrentNetworkState();
        this.mConnectionType = NetworkChangeNotifierAutoDetect.convertToConnectionType(networkState);
        this.mWifiSSID = networkState.getWifiSsid();
        this.mMaxBandwidthMbps = this.getCurrentMaxBandwidthInMbps(networkState);
        this.mMaxBandwidthConnectionType = this.mConnectionType;
        this.mIntentFilter = new NetworkConnectivityIntentFilter();
        this.mIgnoreNextBroadcast = false;
        this.mShouldSignalObserver = false;
        this.mRegistrationPolicy = policy;
        this.mRegistrationPolicy.init(this);
        this.mShouldSignalObserver = true;
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate delegate) {
        this.mConnectivityManagerDelegate = delegate;
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate delegate) {
        this.mWifiManagerDelegate = delegate;
    }

    @VisibleForTesting
    RegistrationPolicy getRegistrationPolicy() {
        return this.mRegistrationPolicy;
    }

    @VisibleForTesting
    boolean isReceiverRegisteredForTesting() {
        return this.mRegistered;
    }

    public void destroy() {
        this.mRegistrationPolicy.destroy();
        this.unregister();
    }

    public void register() {
        ThreadUtils.assertOnUiThread();
        if (this.mRegistered) {
            return;
        }
        if (this.mShouldSignalObserver) {
            NetworkState networkState = this.getCurrentNetworkState();
            this.connectionTypeChanged(networkState);
            this.maxBandwidthChanged(networkState);
        }
        this.mIgnoreNextBroadcast = ContextUtils.getApplicationContext().registerReceiver((BroadcastReceiver)this, (IntentFilter)this.mIntentFilter) != null;
        this.mRegistered = true;
        if (this.mNetworkCallback != null) {
            this.mNetworkCallback.initializeVpnInPlace();
            this.mConnectivityManagerDelegate.registerNetworkCallback(this.mNetworkRequest, this.mNetworkCallback);
            if (this.mShouldSignalObserver) {
                Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
                long[] netIds = new long[networks.length];
                for (int i = 0; i < networks.length; ++i) {
                    netIds[i] = NetworkChangeNotifierAutoDetect.networkToNetId(networks[i]);
                }
                this.mObserver.purgeActiveNetworkList(netIds);
            }
        }
    }

    public void unregister() {
        if (!this.mRegistered) {
            return;
        }
        ContextUtils.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
        this.mRegistered = false;
        if (this.mNetworkCallback != null) {
            this.mConnectivityManagerDelegate.unregisterNetworkCallback(this.mNetworkCallback);
        }
    }

    public NetworkState getCurrentNetworkState() {
        return this.mConnectivityManagerDelegate.getNetworkState(this.mWifiManagerDelegate);
    }

    @TargetApi(value=21)
    private static Network[] getAllNetworksFiltered(ConnectivityManagerDelegate connectivityManagerDelegate, Network ignoreNetwork) {
        Network[] networks = connectivityManagerDelegate.getAllNetworksUnfiltered();
        int filteredIndex = 0;
        for (Network network : networks) {
            NetworkCapabilities capabilities;
            if (network.equals((Object)ignoreNetwork) || (capabilities = connectivityManagerDelegate.getNetworkCapabilities(network)) == null || !capabilities.hasCapability(12)) continue;
            if (capabilities.hasTransport(4)) {
                if (!connectivityManagerDelegate.vpnAccessible(network)) continue;
                return new Network[]{network};
            }
            networks[filteredIndex++] = network;
        }
        return Arrays.copyOf(networks, filteredIndex);
    }

    public long[] getNetworksAndTypes() {
        if (Build.VERSION.SDK_INT < 21) {
            return new long[0];
        }
        Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
        long[] networksAndTypes = new long[networks.length * 2];
        int index = 0;
        for (Network network : networks) {
            networksAndTypes[index++] = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            networksAndTypes[index++] = this.mConnectivityManagerDelegate.getConnectionType(network);
        }
        return networksAndTypes;
    }

    public long getDefaultNetId() {
        if (Build.VERSION.SDK_INT < 21) {
            return -1L;
        }
        return this.mConnectivityManagerDelegate.getDefaultNetId();
    }

    public static int convertToConnectionType(NetworkState networkState) {
        if (!networkState.isConnected()) {
            return 6;
        }
        return NetworkChangeNotifierAutoDetect.convertToConnectionType(networkState.getNetworkType(), networkState.getNetworkSubType());
    }

    private static int convertToConnectionType(int type, int subtype) {
        switch (type) {
            case 9: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 0: {
                switch (subtype) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 3;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 4;
                    }
                    case 13: {
                        return 5;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public static int convertToConnectionSubtype(NetworkState networkState) {
        if (!networkState.isConnected()) {
            return 1;
        }
        switch (networkState.getNetworkType()) {
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                return 0;
            }
            case 0: {
                switch (networkState.getNetworkSubType()) {
                    case 1: {
                        return 7;
                    }
                    case 2: {
                        return 8;
                    }
                    case 4: {
                        return 5;
                    }
                    case 7: {
                        return 6;
                    }
                    case 11: {
                        return 4;
                    }
                    case 3: {
                        return 9;
                    }
                    case 5: {
                        return 10;
                    }
                    case 6: {
                        return 11;
                    }
                    case 8: {
                        return 14;
                    }
                    case 9: {
                        return 15;
                    }
                    case 10: {
                        return 12;
                    }
                    case 12: {
                        return 13;
                    }
                    case 14: {
                        return 16;
                    }
                    case 15: {
                        return 17;
                    }
                    case 13: {
                        return 18;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public double getCurrentMaxBandwidthInMbps(NetworkState networkState) {
        return NetworkChangeNotifier.getMaxBandwidthForConnectionSubtype(NetworkChangeNotifierAutoDetect.convertToConnectionSubtype(networkState));
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mIgnoreNextBroadcast) {
            this.mIgnoreNextBroadcast = false;
            return;
        }
        NetworkState networkState = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.connectionTypeChanged(networkState);
            this.maxBandwidthChanged(networkState);
        }
    }

    private void connectionTypeChanged(NetworkState networkState) {
        int newConnectionType = NetworkChangeNotifierAutoDetect.convertToConnectionType(networkState);
        String newWifiSSID = networkState.getWifiSsid();
        if (newConnectionType == this.mConnectionType && newWifiSSID.equals(this.mWifiSSID)) {
            return;
        }
        this.mConnectionType = newConnectionType;
        this.mWifiSSID = newWifiSSID;
        this.mObserver.onConnectionTypeChanged(newConnectionType);
    }

    private void maxBandwidthChanged(NetworkState networkState) {
        double newMaxBandwidthMbps = this.getCurrentMaxBandwidthInMbps(networkState);
        if (newMaxBandwidthMbps == this.mMaxBandwidthMbps && this.mConnectionType == this.mMaxBandwidthConnectionType) {
            return;
        }
        this.mMaxBandwidthMbps = newMaxBandwidthMbps;
        this.mMaxBandwidthConnectionType = this.mConnectionType;
        this.mObserver.onMaxBandwidthChanged(newMaxBandwidthMbps);
    }

    @TargetApi(value=21)
    @VisibleForTesting
    static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT >= 23) {
            return network.getNetworkHandle();
        }
        return Integer.parseInt(network.toString());
    }

    @SuppressLint(value={"NewApi", "ParcelCreator"})
    private static class NetworkConnectivityIntentFilter
    extends IntentFilter {
        NetworkConnectivityIntentFilter() {
            this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(int var1);

        public void onMaxBandwidthChanged(double var1);

        public void onNetworkConnect(long var1, int var3);

        public void onNetworkSoonToDisconnect(long var1);

        public void onNetworkDisconnect(long var1);

        public void purgeActiveNetworkList(long[] var1);
    }

    public static abstract class RegistrationPolicy {
        private NetworkChangeNotifierAutoDetect mNotifier;

        protected final void register() {
            assert (this.mNotifier != null);
            this.mNotifier.register();
        }

        protected final void unregister() {
            assert (this.mNotifier != null);
            this.mNotifier.unregister();
        }

        protected void init(NetworkChangeNotifierAutoDetect notifier) {
            this.mNotifier = notifier;
        }

        protected abstract void destroy();
    }

    @TargetApi(value=21)
    private class MyNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private Network mVpnInPlace;

        private MyNetworkCallback() {
        }

        void initializeVpnInPlace() {
            NetworkCapabilities capabilities;
            Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, null);
            this.mVpnInPlace = null;
            if (networks.length == 1 && (capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(networks[0])) != null && capabilities.hasTransport(4)) {
                this.mVpnInPlace = networks[0];
            }
        }

        private boolean ignoreNetworkDueToVpn(Network network) {
            return this.mVpnInPlace != null && !this.mVpnInPlace.equals((Object)network);
        }

        private boolean ignoreConnectedInaccessibleVpn(Network network, NetworkCapabilities capabilities) {
            if (capabilities == null) {
                capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
            }
            return capabilities == null || capabilities.hasTransport(4) && !NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.vpnAccessible(network);
        }

        private boolean ignoreConnectedNetwork(Network network, NetworkCapabilities capabilities) {
            return this.ignoreNetworkDueToVpn(network) || this.ignoreConnectedInaccessibleVpn(network, capabilities);
        }

        public void onAvailable(Network network) {
            NetworkCapabilities capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
            if (this.ignoreConnectedNetwork(network, capabilities)) {
                return;
            }
            final boolean makeVpnDefault = capabilities.hasTransport(4);
            if (makeVpnDefault) {
                this.mVpnInPlace = network;
            }
            final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            final int connectionType = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getConnectionType(network);
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                    if (makeVpnDefault) {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(connectionType);
                        NetworkChangeNotifierAutoDetect.this.mObserver.purgeActiveNetworkList(new long[]{netId});
                    }
                }
            });
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            if (this.ignoreConnectedNetwork(network, networkCapabilities)) {
                return;
            }
            final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            final int connectionType = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getConnectionType(network);
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                }
            });
        }

        public void onLosing(Network network, int maxMsToLive) {
            if (this.ignoreConnectedNetwork(network, null)) {
                return;
            }
            final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkSoonToDisconnect(netId);
                }
            });
        }

        public void onLost(final Network network) {
            if (this.ignoreNetworkDueToVpn(network)) {
                return;
            }
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkDisconnect(NetworkChangeNotifierAutoDetect.networkToNetId(network));
                }
            });
            if (this.mVpnInPlace != null) {
                assert (network.equals((Object)this.mVpnInPlace));
                this.mVpnInPlace = null;
                for (Network newNetwork : NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, network)) {
                    this.onAvailable(newNetwork);
                }
                final int newConnectionType = NetworkChangeNotifierAutoDetect.convertToConnectionType(NetworkChangeNotifierAutoDetect.this.getCurrentNetworkState());
                ThreadUtils.postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(newConnectionType);
                    }
                });
            }
        }
    }

    static class WifiManagerDelegate {
        private final Context mContext;
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private boolean mHasWifiPermissionComputed;
        @GuardedBy(value="mLock")
        private boolean mHasWifiPermission;
        @GuardedBy(value="mLock")
        private WifiManager mWifiManager;

        WifiManagerDelegate(Context context) {
            this.mContext = context;
        }

        WifiManagerDelegate() {
            this.mContext = null;
        }

        @GuardedBy(value="mLock")
        @SuppressLint(value={"WifiManagerPotentialLeak"})
        private boolean hasPermissionLocked() {
            if (this.mHasWifiPermissionComputed) {
                return this.mHasWifiPermission;
            }
            this.mHasWifiPermission = this.mContext.getPackageManager().checkPermission("android.permission.ACCESS_WIFI_STATE", this.mContext.getPackageName()) == 0;
            this.mWifiManager = this.mHasWifiPermission ? (WifiManager)this.mContext.getSystemService("wifi") : null;
            this.mHasWifiPermissionComputed = true;
            return this.mHasWifiPermission;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getWifiSsid() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.hasPermissionLocked()) {
                    WifiInfo wifiInfo = this.getWifiInfoLocked();
                    if (wifiInfo != null) {
                        return wifiInfo.getSSID();
                    }
                    return "";
                }
            }
            return AndroidNetworkLibrary.getWifiSSID();
        }

        @GuardedBy(value="mLock")
        private WifiInfo getWifiInfoLocked() {
            try {
                WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
                RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo1stSuccess", true);
                return wifiInfo;
            }
            catch (NullPointerException firstException) {
                RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo1stSuccess", false);
                try {
                    WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
                    RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo2ndSuccess", true);
                    return wifiInfo;
                }
                catch (NullPointerException secondException) {
                    RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo2ndSuccess", false);
                    return null;
                }
            }
        }
    }

    static class ConnectivityManagerDelegate {
        private static final int NETWORK_INFO_DISCONNECTED = 0;
        private static final int NETWORK_INFO_CONNECTED = 1;
        private static final int NETWORK_INFO_ANDROID_API_LEVEL_TOO_OLD_FOR_UNBLOCKING = 2;
        private static final int NETWORK_INFO_NOT_BLOCKED = 3;
        private static final int NETWORK_INFO_APP_NOT_IN_FOREGROUND = 4;
        private static final int NETWORK_INFO_UNBLOCKED = 5;
        private static final int NETWORK_INFO_BOUNDARY = 6;
        private final ConnectivityManager mConnectivityManager;

        ConnectivityManagerDelegate(Context context) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.mConnectivityManager = null;
        }

        @TargetApi(value=21)
        private NetworkInfo getActiveNetworkInfo() {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                ConnectivityManagerDelegate.recordGetActiveNetworkInfoResult(0);
                return null;
            }
            if (networkInfo.isConnected()) {
                ConnectivityManagerDelegate.recordGetActiveNetworkInfoResult(1);
                return networkInfo;
            }
            if (Build.VERSION.SDK_INT < 21) {
                ConnectivityManagerDelegate.recordGetActiveNetworkInfoResult(2);
                return null;
            }
            if (networkInfo.getDetailedState() != NetworkInfo.DetailedState.BLOCKED) {
                ConnectivityManagerDelegate.recordGetActiveNetworkInfoResult(3);
                return null;
            }
            if (ApplicationStatus.getStateForApplication() != 1) {
                ConnectivityManagerDelegate.recordGetActiveNetworkInfoResult(4);
                return null;
            }
            ConnectivityManagerDelegate.recordGetActiveNetworkInfoResult(5);
            return networkInfo;
        }

        private static void recordGetActiveNetworkInfoResult(int result) {
            assert (result >= 0 && result < 6);
            RecordHistogram.recordEnumeratedHistogram("NCN.GetActiveNetworkInfoResult", result, 6);
        }

        NetworkState getNetworkState(WifiManagerDelegate wifiManagerDelegate) {
            NetworkInfo networkInfo = this.getActiveNetworkInfo();
            if (networkInfo == null) {
                return new NetworkState(false, -1, -1, null);
            }
            if (networkInfo.getType() == 1) {
                if (networkInfo.getExtraInfo() != null && !"".equals(networkInfo.getExtraInfo())) {
                    return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), networkInfo.getExtraInfo());
                }
                return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), wifiManagerDelegate.getWifiSsid());
            }
            return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), null);
        }

        private NetworkInfo getNetworkInfo(Network network) {
            try {
                NetworkInfo networkInfo = this.mConnectivityManager.getNetworkInfo(network);
                RecordHistogram.recordBooleanHistogram("NCN.getNetInfo1stSuccess", true);
                return networkInfo;
            }
            catch (NullPointerException firstException) {
                RecordHistogram.recordBooleanHistogram("NCN.getNetInfo1stSuccess", false);
                try {
                    NetworkInfo networkInfo = this.mConnectivityManager.getNetworkInfo(network);
                    RecordHistogram.recordBooleanHistogram("NCN.getNetInfo2ndSuccess", true);
                    return networkInfo;
                }
                catch (NullPointerException secondException) {
                    RecordHistogram.recordBooleanHistogram("NCN.getNetInfo2ndSuccess", false);
                    return null;
                }
            }
        }

        @TargetApi(value=21)
        int getConnectionType(Network network) {
            NetworkInfo networkInfo = this.getNetworkInfo(network);
            if (networkInfo != null && networkInfo.getType() == 17) {
                networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            }
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkChangeNotifierAutoDetect.convertToConnectionType(networkInfo.getType(), networkInfo.getSubtype());
            }
            return 6;
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected Network[] getAllNetworksUnfiltered() {
            return this.mConnectivityManager.getAllNetworks();
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected boolean vpnAccessible(Network network) {
            try {
                network.getSocketFactory().createSocket().close();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected NetworkCapabilities getNetworkCapabilities(Network network) {
            return this.mConnectivityManager.getNetworkCapabilities(network);
        }

        @TargetApi(value=21)
        void registerNetworkCallback(NetworkRequest networkRequest, ConnectivityManager.NetworkCallback networkCallback) {
            this.mConnectivityManager.registerNetworkCallback(networkRequest, networkCallback);
        }

        @TargetApi(value=21)
        void unregisterNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.mConnectivityManager.unregisterNetworkCallback(networkCallback);
        }

        @TargetApi(value=21)
        long getDefaultNetId() {
            NetworkInfo defaultNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (defaultNetworkInfo == null) {
                return -1L;
            }
            Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this, null);
            long defaultNetId = -1L;
            for (Network network : networks) {
                NetworkInfo networkInfo = this.getNetworkInfo(network);
                if (networkInfo == null || networkInfo.getType() != defaultNetworkInfo.getType() && networkInfo.getType() != 17) continue;
                assert (defaultNetId == -1L);
                defaultNetId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            }
            return defaultNetId;
        }
    }

    static class NetworkState {
        private final boolean mConnected;
        private final int mType;
        private final int mSubtype;
        private final String mWifiSsid;

        public NetworkState(boolean connected, int type, int subtype, String wifiSsid) {
            this.mConnected = connected;
            this.mType = type;
            this.mSubtype = subtype;
            assert (this.mType == 1 || wifiSsid == null);
            this.mWifiSsid = wifiSsid == null ? "" : wifiSsid;
        }

        public boolean isConnected() {
            return this.mConnected;
        }

        public int getNetworkType() {
            return this.mType;
        }

        public int getNetworkSubType() {
            return this.mSubtype;
        }

        public String getWifiSsid() {
            return this.mWifiSsid;
        }
    }
}

