/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.net.NetworkChangeNotifier;
import org.chromium.net.impl.CronetEngineBuilderImpl;
import org.chromium.net.impl.ImplVersion;

@JNINamespace(value="cronet")
@VisibleForTesting
public class CronetLibraryLoader {
    private static final Object sLoadLock = new Object();
    private static final String LIBRARY_NAME = "cronet." + ImplVersion.getCronetVersion();
    private static final String TAG = CronetLibraryLoader.class.getSimpleName();
    private static volatile boolean sLibraryLoaded = false;
    private static volatile boolean sMainThreadInitDone = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInitialized(final Context applicationContext, CronetEngineBuilderImpl builder) {
        Object object = sLoadLock;
        synchronized (object) {
            if (!sLibraryLoaded) {
                ContextUtils.initApplicationContext(applicationContext);
                if (builder.libraryLoader() != null) {
                    builder.libraryLoader().loadLibrary(LIBRARY_NAME);
                } else {
                    System.loadLibrary(LIBRARY_NAME);
                }
                ContextUtils.initApplicationContextForNative();
                String implVersion = ImplVersion.getCronetVersion();
                if (!implVersion.equals(CronetLibraryLoader.nativeGetCronetVersion())) {
                    throw new RuntimeException(String.format("Expected Cronet version number %s, actual version number %s.", implVersion, CronetLibraryLoader.nativeGetCronetVersion()));
                }
                Log.i(TAG, "Cronet version: %s, arch: %s", implVersion, System.getProperty("os.arch"));
                sLibraryLoaded = true;
            }
            if (!sMainThreadInitDone) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        CronetLibraryLoader.ensureInitializedOnMainThread(applicationContext);
                    }
                };
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    task.run();
                } else {
                    new Handler(Looper.getMainLooper()).post(task);
                }
            }
        }
    }

    static void ensureInitializedOnMainThread(Context context) {
        assert (sLibraryLoaded);
        assert (Looper.getMainLooper() == Looper.myLooper());
        if (sMainThreadInitDone) {
            return;
        }
        NetworkChangeNotifier.init(context);
        NetworkChangeNotifier.registerToReceiveNotificationsAlways();
        CronetLibraryLoader.nativeCronetInitOnMainThread();
        sMainThreadInitDone = true;
    }

    private static native void nativeCronetInitOnMainThread();

    private static native String nativeGetCronetVersion();
}

