/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.support.annotation.Nullable;
import java.util.Date;
import org.chromium.base.VisibleForTesting;
import org.chromium.net.RequestFinishedInfo;

@VisibleForTesting
public final class CronetMetrics
extends RequestFinishedInfo.Metrics {
    private final long mRequestStartMs;
    private final long mDnsStartMs;
    private final long mDnsEndMs;
    private final long mConnectStartMs;
    private final long mConnectEndMs;
    private final long mSslStartMs;
    private final long mSslEndMs;
    private final long mSendingStartMs;
    private final long mSendingEndMs;
    private final long mPushStartMs;
    private final long mPushEndMs;
    private final long mResponseStartMs;
    private final long mRequestEndMs;
    private final boolean mSocketReused;
    @Nullable
    private final Long mTtfbMs;
    @Nullable
    private final Long mTotalTimeMs;
    @Nullable
    private final Long mSentByteCount;
    @Nullable
    private final Long mReceivedByteCount;

    @Nullable
    private static Date toDate(long timestamp) {
        if (timestamp != -1L) {
            return new Date(timestamp);
        }
        return null;
    }

    private static boolean checkOrder(long start, long end) {
        return end >= start && start != -1L || end == -1L;
    }

    public CronetMetrics(@Nullable Long ttfbMs, @Nullable Long totalTimeMs, @Nullable Long sentByteCount, @Nullable Long receivedByteCount) {
        this.mTtfbMs = ttfbMs;
        this.mTotalTimeMs = totalTimeMs;
        this.mSentByteCount = sentByteCount;
        this.mReceivedByteCount = receivedByteCount;
        this.mRequestStartMs = -1L;
        this.mDnsStartMs = -1L;
        this.mDnsEndMs = -1L;
        this.mConnectStartMs = -1L;
        this.mConnectEndMs = -1L;
        this.mSslStartMs = -1L;
        this.mSslEndMs = -1L;
        this.mSendingStartMs = -1L;
        this.mSendingEndMs = -1L;
        this.mPushStartMs = -1L;
        this.mPushEndMs = -1L;
        this.mResponseStartMs = -1L;
        this.mRequestEndMs = -1L;
        this.mSocketReused = false;
    }

    public CronetMetrics(long requestStartMs, long dnsStartMs, long dnsEndMs, long connectStartMs, long connectEndMs, long sslStartMs, long sslEndMs, long sendingStartMs, long sendingEndMs, long pushStartMs, long pushEndMs, long responseStartMs, long requestEndMs, boolean socketReused, long sentByteCount, long receivedByteCount) {
        assert (CronetMetrics.checkOrder(dnsStartMs, dnsEndMs));
        assert (CronetMetrics.checkOrder(connectStartMs, connectEndMs));
        assert (CronetMetrics.checkOrder(sslStartMs, sslEndMs));
        assert (CronetMetrics.checkOrder(sendingStartMs, sendingEndMs));
        assert (CronetMetrics.checkOrder(pushStartMs, pushEndMs));
        assert (requestEndMs >= responseStartMs);
        assert (dnsStartMs >= requestStartMs || dnsStartMs == -1L);
        assert (sendingStartMs >= requestStartMs || sendingStartMs == -1L);
        assert (sslStartMs >= connectStartMs || sslStartMs == -1L);
        assert (responseStartMs >= sendingStartMs || responseStartMs == -1L);
        this.mRequestStartMs = requestStartMs;
        this.mDnsStartMs = dnsStartMs;
        this.mDnsEndMs = dnsEndMs;
        this.mConnectStartMs = connectStartMs;
        this.mConnectEndMs = connectEndMs;
        this.mSslStartMs = sslStartMs;
        this.mSslEndMs = sslEndMs;
        this.mSendingStartMs = sendingStartMs;
        this.mSendingEndMs = sendingEndMs;
        this.mPushStartMs = pushStartMs;
        this.mPushEndMs = pushEndMs;
        this.mResponseStartMs = responseStartMs;
        this.mRequestEndMs = requestEndMs;
        this.mSocketReused = socketReused;
        this.mSentByteCount = sentByteCount;
        this.mReceivedByteCount = receivedByteCount;
        this.mTtfbMs = requestStartMs != -1L && responseStartMs != -1L ? Long.valueOf(responseStartMs - requestStartMs) : null;
        this.mTotalTimeMs = requestStartMs != -1L && requestEndMs != -1L ? Long.valueOf(requestEndMs - requestStartMs) : null;
    }

    @Nullable
    public Date getRequestStart() {
        return CronetMetrics.toDate(this.mRequestStartMs);
    }

    @Nullable
    public Date getDnsStart() {
        return CronetMetrics.toDate(this.mDnsStartMs);
    }

    @Nullable
    public Date getDnsEnd() {
        return CronetMetrics.toDate(this.mDnsEndMs);
    }

    @Nullable
    public Date getConnectStart() {
        return CronetMetrics.toDate(this.mConnectStartMs);
    }

    @Nullable
    public Date getConnectEnd() {
        return CronetMetrics.toDate(this.mConnectEndMs);
    }

    @Nullable
    public Date getSslStart() {
        return CronetMetrics.toDate(this.mSslStartMs);
    }

    @Nullable
    public Date getSslEnd() {
        return CronetMetrics.toDate(this.mSslEndMs);
    }

    @Nullable
    public Date getSendingStart() {
        return CronetMetrics.toDate(this.mSendingStartMs);
    }

    @Nullable
    public Date getSendingEnd() {
        return CronetMetrics.toDate(this.mSendingEndMs);
    }

    @Nullable
    public Date getPushStart() {
        return CronetMetrics.toDate(this.mPushStartMs);
    }

    @Nullable
    public Date getPushEnd() {
        return CronetMetrics.toDate(this.mPushEndMs);
    }

    @Nullable
    public Date getResponseStart() {
        return CronetMetrics.toDate(this.mResponseStartMs);
    }

    @Nullable
    public Date getRequestEnd() {
        return CronetMetrics.toDate(this.mRequestEndMs);
    }

    @Nullable
    public boolean getSocketReused() {
        return this.mSocketReused;
    }

    @Nullable
    public Long getTtfbMs() {
        return this.mTtfbMs;
    }

    @Nullable
    public Long getTotalTimeMs() {
        return this.mTotalTimeMs;
    }

    @Nullable
    public Long getSentByteCount() {
        return this.mSentByteCount;
    }

    @Nullable
    public Long getReceivedByteCount() {
        return this.mReceivedByteCount;
    }
}

