/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.annotation.SuppressLint;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Log;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;
import org.chromium.net.impl.CronetUrlRequest;
import org.chromium.net.impl.VersionSafeCallbacks;

@JNINamespace(value="cronet")
@VisibleForTesting
public final class CronetUploadDataStream
extends UploadDataSink {
    private static final String TAG = CronetUploadDataStream.class.getSimpleName();
    private final Executor mExecutor;
    private final VersionSafeCallbacks.UploadDataProviderWrapper mDataProvider;
    private long mLength;
    private long mRemainingLength;
    private CronetUrlRequest mRequest;
    private final Runnable mReadTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CronetUploadDataStream.this.mLock;
            synchronized (object) {
                if (CronetUploadDataStream.this.mUploadDataStreamAdapter == 0L) {
                    return;
                }
                CronetUploadDataStream.this.checkState(UserCallback.NOT_IN_CALLBACK);
                if (CronetUploadDataStream.this.mByteBuffer == null) {
                    throw new IllegalStateException("Unexpected readData call. Buffer is null");
                }
                CronetUploadDataStream.this.mInWhichUserCallback = UserCallback.READ;
            }
            try {
                CronetUploadDataStream.this.checkCallingThread();
                CronetUploadDataStream.this.mDataProvider.read((UploadDataSink)CronetUploadDataStream.this, CronetUploadDataStream.this.mByteBuffer);
            }
            catch (Exception exception) {
                CronetUploadDataStream.this.onError(exception);
            }
        }
    };
    private ByteBuffer mByteBuffer = null;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private long mUploadDataStreamAdapter = 0L;
    @GuardedBy(value="mLock")
    private UserCallback mInWhichUserCallback = UserCallback.NOT_IN_CALLBACK;
    @GuardedBy(value="mLock")
    private boolean mDestroyAdapterPostponed = false;
    private Runnable mOnDestroyedCallbackForTesting;

    public CronetUploadDataStream(UploadDataProvider dataProvider, Executor executor) {
        this.mExecutor = executor;
        this.mDataProvider = new VersionSafeCallbacks.UploadDataProviderWrapper(dataProvider);
    }

    @CalledByNative
    void readData(ByteBuffer byteBuffer) {
        this.mByteBuffer = byteBuffer;
        this.postTaskToExecutor(this.mReadTask);
    }

    @CalledByNative
    void rewind() {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetUploadDataStream.this.mLock;
                synchronized (object) {
                    if (CronetUploadDataStream.this.mUploadDataStreamAdapter == 0L) {
                        return;
                    }
                    CronetUploadDataStream.this.checkState(UserCallback.NOT_IN_CALLBACK);
                    CronetUploadDataStream.this.mInWhichUserCallback = UserCallback.REWIND;
                }
                try {
                    CronetUploadDataStream.this.checkCallingThread();
                    CronetUploadDataStream.this.mDataProvider.rewind((UploadDataSink)CronetUploadDataStream.this);
                }
                catch (Exception exception) {
                    CronetUploadDataStream.this.onError(exception);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    private void checkCallingThread() {
        if (this.mRequest != null) {
            this.mRequest.checkCallingThread();
        }
    }

    @GuardedBy(value="mLock")
    private void checkState(UserCallback mode) {
        if (this.mInWhichUserCallback != mode) {
            throw new IllegalStateException("Expected " + (Object)((Object)mode) + ", but was " + (Object)((Object)this.mInWhichUserCallback));
        }
    }

    @CalledByNative
    void onUploadDataStreamDestroyed() {
        this.destroyAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable exception) {
        boolean sendClose;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInWhichUserCallback == UserCallback.NOT_IN_CALLBACK) {
                throw new IllegalStateException("There is no read or rewind or length check in progress.");
            }
            sendClose = this.mInWhichUserCallback == UserCallback.GET_LENGTH;
            this.mInWhichUserCallback = UserCallback.NOT_IN_CALLBACK;
            this.mByteBuffer = null;
            this.destroyAdapterIfPostponed();
        }
        if (sendClose) {
            try {
                this.mDataProvider.close();
            }
            catch (Exception e) {
                Log.e(TAG, "Failure closing data provider", e);
            }
        }
        this.mRequest.onUploadException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DefaultLocale"})
    public void onReadSucceeded(boolean lastChunk) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(UserCallback.READ);
            if (lastChunk && this.mLength >= 0L) {
                throw new IllegalArgumentException("Non-chunked upload can't have last chunk");
            }
            int bytesRead = this.mByteBuffer.position();
            this.mRemainingLength -= (long)bytesRead;
            if (this.mRemainingLength < 0L && this.mLength >= 0L) {
                throw new IllegalArgumentException(String.format("Read upload data length %d exceeds expected length %d", this.mLength - this.mRemainingLength, this.mLength));
            }
            this.mByteBuffer = null;
            this.mInWhichUserCallback = UserCallback.NOT_IN_CALLBACK;
            this.destroyAdapterIfPostponed();
            if (this.mUploadDataStreamAdapter == 0L) {
                return;
            }
            this.nativeOnReadSucceeded(this.mUploadDataStreamAdapter, bytesRead, lastChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadError(Exception exception) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(UserCallback.READ);
            this.onError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRewindSucceeded() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(UserCallback.REWIND);
            this.mInWhichUserCallback = UserCallback.NOT_IN_CALLBACK;
            this.mRemainingLength = this.mLength;
            if (this.mUploadDataStreamAdapter == 0L) {
                return;
            }
            this.nativeOnRewindSucceeded(this.mUploadDataStreamAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRewindError(Exception exception) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(UserCallback.REWIND);
            this.onError(exception);
        }
    }

    void postTaskToExecutor(Runnable task) {
        try {
            this.mExecutor.execute(task);
        }
        catch (Throwable e) {
            this.mRequest.onUploadException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAdapter() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInWhichUserCallback == UserCallback.READ) {
                this.mDestroyAdapterPostponed = true;
                return;
            }
            if (this.mUploadDataStreamAdapter == 0L) {
                return;
            }
            CronetUploadDataStream.nativeDestroy(this.mUploadDataStreamAdapter);
            this.mUploadDataStreamAdapter = 0L;
            if (this.mOnDestroyedCallbackForTesting != null) {
                this.mOnDestroyedCallbackForTesting.run();
            }
        }
        this.postTaskToExecutor(new Runnable(){

            @Override
            public void run() {
                try {
                    CronetUploadDataStream.this.checkCallingThread();
                    CronetUploadDataStream.this.mDataProvider.close();
                }
                catch (Exception e) {
                    Log.e(TAG, "Exception thrown when closing", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAdapterIfPostponed() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInWhichUserCallback == UserCallback.READ) {
                throw new IllegalStateException("Method should not be called when read has not completed.");
            }
            if (this.mDestroyAdapterPostponed) {
                this.destroyAdapter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeWithRequest(CronetUrlRequest urlRequest) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRequest = urlRequest;
            this.mInWhichUserCallback = UserCallback.GET_LENGTH;
        }
        try {
            urlRequest.checkCallingThread();
            this.mRemainingLength = this.mLength = this.mDataProvider.getLength();
        }
        catch (Throwable t) {
            this.onError(t);
        }
        object = this.mLock;
        synchronized (object) {
            this.mInWhichUserCallback = UserCallback.NOT_IN_CALLBACK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachNativeAdapterToRequest(long requestAdapter) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUploadDataStreamAdapter = this.nativeAttachUploadDataToRequest(requestAdapter, this.mLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long createUploadDataStreamForTesting() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.mUploadDataStreamAdapter = this.nativeCreateAdapterForTesting();
            this.mRemainingLength = this.mLength = this.mDataProvider.getLength();
            return this.nativeCreateUploadDataStreamForTesting(this.mLength, this.mUploadDataStreamAdapter);
        }
    }

    @VisibleForTesting
    void setOnDestroyedCallbackForTesting(Runnable onDestroyedCallbackForTesting) {
        this.mOnDestroyedCallbackForTesting = onDestroyedCallbackForTesting;
    }

    private native long nativeAttachUploadDataToRequest(long var1, long var3);

    private native long nativeCreateAdapterForTesting();

    private native long nativeCreateUploadDataStreamForTesting(long var1, long var3);

    @NativeClassQualifiedName(value="CronetUploadDataStreamAdapter")
    private native void nativeOnReadSucceeded(long var1, int var3, boolean var4);

    @NativeClassQualifiedName(value="CronetUploadDataStreamAdapter")
    private native void nativeOnRewindSucceeded(long var1);

    @NativeClassQualifiedName(value="CronetUploadDataStreamAdapter")
    private static native void nativeDestroy(long var0);

    static enum UserCallback {
        READ,
        REWIND,
        GET_LENGTH,
        NOT_IN_CALLBACK;

    }
}

