/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Log;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNIAdditionalImport;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.net.CronetException;
import org.chromium.net.InlineExecutionProhibitedException;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.impl.CallbackExceptionImpl;
import org.chromium.net.impl.CronetExceptionImpl;
import org.chromium.net.impl.CronetMetrics;
import org.chromium.net.impl.CronetUploadDataStream;
import org.chromium.net.impl.CronetUrlRequestContext;
import org.chromium.net.impl.NetworkExceptionImpl;
import org.chromium.net.impl.Preconditions;
import org.chromium.net.impl.QuicExceptionImpl;
import org.chromium.net.impl.RequestFinishedInfoImpl;
import org.chromium.net.impl.UrlRequestBase;
import org.chromium.net.impl.UrlResponseInfoImpl;
import org.chromium.net.impl.VersionSafeCallbacks;

@JNINamespace(value="cronet")
@JNIAdditionalImport(value={VersionSafeCallbacks.class})
@VisibleForTesting
public final class CronetUrlRequest
extends UrlRequestBase {
    private final boolean mAllowDirectExecutor;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private long mUrlRequestAdapter;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mStarted;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mWaitingOnRedirect;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean mWaitingOnRead;
    private final Object mUrlRequestAdapterLock = new Object();
    private final CronetUrlRequestContext mRequestContext;
    private final Executor mExecutor;
    private final List<String> mUrlChain = new ArrayList<String>();
    private long mReceivedByteCountFromRedirects;
    private final VersionSafeCallbacks.UrlRequestCallback mCallback;
    private final String mInitialUrl;
    private final int mPriority;
    private String mInitialMethod;
    private final HeadersList mRequestHeaders = new HeadersList();
    private final Collection<Object> mRequestAnnotations;
    private final boolean mDisableCache;
    private final boolean mDisableConnectionMigration;
    private CronetUploadDataStream mUploadDataStream;
    private UrlResponseInfoImpl mResponseInfo;
    private int mFinishedReason;
    private CronetException mException;
    private CronetMetrics mMetrics;
    private OnReadCompletedRunnable mOnReadCompletedTask;
    @GuardedBy(value="mUrlRequestAdapterLock")
    private Runnable mOnDestroyedCallbackForTesting;

    CronetUrlRequest(CronetUrlRequestContext requestContext, String url, int priority, UrlRequest.Callback callback, Executor executor, Collection<Object> requestAnnotations, boolean disableCache, boolean disableConnectionMigration, boolean allowDirectExecutor) {
        if (url == null) {
            throw new NullPointerException("URL is required");
        }
        if (callback == null) {
            throw new NullPointerException("Listener is required");
        }
        if (executor == null) {
            throw new NullPointerException("Executor is required");
        }
        this.mAllowDirectExecutor = allowDirectExecutor;
        this.mRequestContext = requestContext;
        this.mInitialUrl = url;
        this.mUrlChain.add(url);
        this.mPriority = CronetUrlRequest.convertRequestPriority(priority);
        this.mCallback = new VersionSafeCallbacks.UrlRequestCallback(callback);
        this.mExecutor = executor;
        this.mRequestAnnotations = requestAnnotations;
        this.mDisableCache = disableCache;
        this.mDisableConnectionMigration = disableConnectionMigration;
    }

    public void setHttpMethod(String method) {
        this.checkNotStarted();
        if (method == null) {
            throw new NullPointerException("Method is required.");
        }
        this.mInitialMethod = method;
    }

    public void addHeader(String header, String value) {
        this.checkNotStarted();
        if (header == null) {
            throw new NullPointerException("Invalid header name.");
        }
        if (value == null) {
            throw new NullPointerException("Invalid header value.");
        }
        this.mRequestHeaders.add(new AbstractMap.SimpleImmutableEntry<String, String>(header, value));
    }

    public void setUploadDataProvider(UploadDataProvider uploadDataProvider, Executor executor) {
        if (uploadDataProvider == null) {
            throw new NullPointerException("Invalid UploadDataProvider.");
        }
        if (this.mInitialMethod == null) {
            this.mInitialMethod = "POST";
        }
        this.mUploadDataStream = new CronetUploadDataStream(uploadDataProvider, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            this.checkNotStarted();
            try {
                this.mUrlRequestAdapter = this.nativeCreateRequestAdapter(this.mRequestContext.getUrlRequestContextAdapter(), this.mInitialUrl, this.mPriority, this.mDisableCache, this.mDisableConnectionMigration, this.mRequestContext.hasRequestFinishedListener());
                this.mRequestContext.onRequestStarted();
                if (this.mInitialMethod != null && !this.nativeSetHttpMethod(this.mUrlRequestAdapter, this.mInitialMethod)) {
                    throw new IllegalArgumentException("Invalid http method " + this.mInitialMethod);
                }
                boolean hasContentType = false;
                for (Map.Entry header : this.mRequestHeaders) {
                    if (((String)header.getKey()).equalsIgnoreCase("Content-Type") && !((String)header.getValue()).isEmpty()) {
                        hasContentType = true;
                    }
                    if (this.nativeAddRequestHeader(this.mUrlRequestAdapter, (String)header.getKey(), (String)header.getValue())) continue;
                    throw new IllegalArgumentException("Invalid header " + (String)header.getKey() + "=" + (String)header.getValue());
                }
                if (this.mUploadDataStream != null) {
                    if (!hasContentType) {
                        throw new IllegalArgumentException("Requests with upload data must have a Content-Type.");
                    }
                    this.mStarted = true;
                    this.mUploadDataStream.postTaskToExecutor(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            CronetUrlRequest.this.mUploadDataStream.initializeWithRequest(CronetUrlRequest.this);
                            Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                            synchronized (object) {
                                if (CronetUrlRequest.this.isDoneLocked()) {
                                    return;
                                }
                                CronetUrlRequest.this.mUploadDataStream.attachNativeAdapterToRequest(CronetUrlRequest.this.mUrlRequestAdapter);
                                CronetUrlRequest.this.startInternalLocked();
                            }
                        }
                    });
                    return;
                }
            }
            catch (RuntimeException e) {
                this.destroyRequestAdapterLocked(1);
                throw e;
            }
            this.mStarted = true;
            this.startInternalLocked();
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private void startInternalLocked() {
        this.nativeStart(this.mUrlRequestAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void followRedirect() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (!this.mWaitingOnRedirect) {
                throw new IllegalStateException("No redirect to follow.");
            }
            this.mWaitingOnRedirect = false;
            if (this.isDoneLocked()) {
                return;
            }
            this.nativeFollowDeferredRedirect(this.mUrlRequestAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ByteBuffer buffer) {
        Preconditions.checkHasRemaining((ByteBuffer)buffer);
        Preconditions.checkDirect((ByteBuffer)buffer);
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (!this.mWaitingOnRead) {
                throw new IllegalStateException("Unexpected read attempt.");
            }
            this.mWaitingOnRead = false;
            if (this.isDoneLocked()) {
                return;
            }
            if (!this.nativeReadData(this.mUrlRequestAdapter, buffer, buffer.position(), buffer.limit())) {
                this.mWaitingOnRead = true;
                throw new IllegalArgumentException("Unable to call native read");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.isDoneLocked() || !this.mStarted) {
                return;
            }
            this.destroyRequestAdapterLocked(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            return this.isDoneLocked();
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private boolean isDoneLocked() {
        return this.mStarted && this.mUrlRequestAdapter == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStatus(UrlRequest.StatusListener unsafeListener) {
        final VersionSafeCallbacks.UrlRequestStatusListener listener = new VersionSafeCallbacks.UrlRequestStatusListener(unsafeListener);
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mUrlRequestAdapter != 0L) {
                this.nativeGetStatus(this.mUrlRequestAdapter, listener);
                return;
            }
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                listener.onStatus(-1);
            }
        };
        this.postTaskToExecutor(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setOnDestroyedCallbackForTesting(Runnable onDestroyedCallbackForTesting) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            this.mOnDestroyedCallbackForTesting = onDestroyedCallbackForTesting;
        }
    }

    @VisibleForTesting
    public void setOnDestroyedUploadCallbackForTesting(Runnable onDestroyedUploadCallbackForTesting) {
        this.mUploadDataStream.setOnDestroyedCallbackForTesting(onDestroyedUploadCallbackForTesting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long getUrlRequestAdapterForTesting() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            return this.mUrlRequestAdapter;
        }
    }

    private void postTaskToExecutor(Runnable task) {
        try {
            this.mExecutor.execute(task);
        }
        catch (RejectedExecutionException failException) {
            Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", failException);
            this.failWithException((CronetException)new CronetExceptionImpl("Exception posting task to executor", (Throwable)failException));
        }
    }

    private static int convertRequestPriority(int priority) {
        switch (priority) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 4;
    }

    private UrlResponseInfoImpl prepareResponseInfoOnNetworkThread(int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer) {
        HeadersList headersList = new HeadersList();
        for (int i = 0; i < headers.length; i += 2) {
            headersList.add(new AbstractMap.SimpleImmutableEntry<String, String>(headers[i], headers[i + 1]));
        }
        return new UrlResponseInfoImpl(new ArrayList<String>(this.mUrlChain), httpStatusCode, httpStatusText, (List)headersList, wasCached, negotiatedProtocol, proxyServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotStarted() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mStarted || this.isDoneLocked()) {
                throw new IllegalStateException("Request is already started.");
            }
        }
    }

    @GuardedBy(value="mUrlRequestAdapterLock")
    private void destroyRequestAdapterLocked(int finishedReason) {
        assert (this.mException == null || finishedReason == 1);
        this.mFinishedReason = finishedReason;
        if (this.mUrlRequestAdapter == 0L) {
            return;
        }
        this.mRequestContext.onRequestDestroyed();
        this.nativeDestroy(this.mUrlRequestAdapter, finishedReason == 2);
        this.mUrlRequestAdapter = 0L;
    }

    private void onCallbackException(Exception e) {
        CallbackExceptionImpl requestError = new CallbackExceptionImpl("Exception received from UrlRequest.Callback", (Throwable)e);
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in CalledByNative method", e);
        this.failWithException((CronetException)requestError);
    }

    void onUploadException(Throwable e) {
        CallbackExceptionImpl uploadError = new CallbackExceptionImpl("Exception received from UploadDataProvider", e);
        Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in upload method", e);
        this.failWithException((CronetException)uploadError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failWithException(CronetException exception) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.isDoneLocked()) {
                return;
            }
            assert (this.mException == null);
            this.mException = exception;
            this.destroyRequestAdapterLocked(1);
        }
    }

    @CalledByNative
    private void onRedirectReceived(final String newLocation, int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer, long receivedByteCount) {
        final UrlResponseInfoImpl responseInfo = this.prepareResponseInfoOnNetworkThread(httpStatusCode, httpStatusText, headers, wasCached, negotiatedProtocol, proxyServer);
        this.mReceivedByteCountFromRedirects += receivedByteCount;
        responseInfo.setReceivedByteCount(this.mReceivedByteCountFromRedirects);
        this.mUrlChain.add(newLocation);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CronetUrlRequest.this.checkCallingThread();
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRedirect = true;
                }
                try {
                    CronetUrlRequest.this.mCallback.onRedirectReceived((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)responseInfo, newLocation);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onCallbackException(e);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onResponseStarted(int httpStatusCode, String httpStatusText, String[] headers, boolean wasCached, String negotiatedProtocol, String proxyServer) {
        this.mResponseInfo = this.prepareResponseInfoOnNetworkThread(httpStatusCode, httpStatusText, headers, wasCached, negotiatedProtocol, proxyServer);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CronetUrlRequest.this.checkCallingThread();
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRead = true;
                }
                try {
                    CronetUrlRequest.this.mCallback.onResponseStarted((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo);
                }
                catch (Exception e) {
                    CronetUrlRequest.this.onCallbackException(e);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onReadCompleted(ByteBuffer byteBuffer, int bytesRead, int initialPosition, int initialLimit, long receivedByteCount) {
        this.mResponseInfo.setReceivedByteCount(this.mReceivedByteCountFromRedirects + receivedByteCount);
        if (byteBuffer.position() != initialPosition || byteBuffer.limit() != initialLimit) {
            this.failWithException((CronetException)new CronetExceptionImpl("ByteBuffer modified externally during read", null));
            return;
        }
        if (this.mOnReadCompletedTask == null) {
            this.mOnReadCompletedTask = new OnReadCompletedRunnable();
        }
        byteBuffer.position(initialPosition + bytesRead);
        this.mOnReadCompletedTask.mByteBuffer = byteBuffer;
        this.postTaskToExecutor(this.mOnReadCompletedTask);
    }

    @CalledByNative
    private void onSucceeded(long receivedByteCount) {
        this.mResponseInfo.setReceivedByteCount(this.mReceivedByteCountFromRedirects + receivedByteCount);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.destroyRequestAdapterLocked(0);
                }
                try {
                    CronetUrlRequest.this.mCallback.onSucceeded((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo);
                    CronetUrlRequest.this.maybeReportMetrics();
                }
                catch (Exception e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onSucceeded method", e);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onError(int errorCode, int nativeError, int nativeQuicError, String errorString, long receivedByteCount) {
        if (this.mResponseInfo != null) {
            this.mResponseInfo.setReceivedByteCount(this.mReceivedByteCountFromRedirects + receivedByteCount);
        }
        if (errorCode == 10) {
            this.failWithException((CronetException)new QuicExceptionImpl("Exception in CronetUrlRequest: " + errorString, nativeError, nativeQuicError));
        } else {
            int javaError = this.mapUrlRequestErrorToApiErrorCode(errorCode);
            this.failWithException((CronetException)new NetworkExceptionImpl("Exception in CronetUrlRequest: " + errorString, javaError, nativeError));
        }
    }

    @CalledByNative
    private void onCanceled() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CronetUrlRequest.this.mCallback.onCanceled((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo);
                    CronetUrlRequest.this.maybeReportMetrics();
                }
                catch (Exception e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onCanceled method", e);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    @CalledByNative
    private void onStatus(final VersionSafeCallbacks.UrlRequestStatusListener listener, final int loadState) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                listener.onStatus(UrlRequestBase.convertLoadState((int)loadState));
            }
        };
        this.postTaskToExecutor(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onMetricsCollected(long requestStartMs, long dnsStartMs, long dnsEndMs, long connectStartMs, long connectEndMs, long sslStartMs, long sslEndMs, long sendingStartMs, long sendingEndMs, long pushStartMs, long pushEndMs, long responseStartMs, long requestEndMs, boolean socketReused, long sentByteCount, long receivedByteCount) {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mMetrics != null) {
                throw new IllegalStateException("Metrics collection should only happen once.");
            }
            this.mMetrics = new CronetMetrics(requestStartMs, dnsStartMs, dnsEndMs, connectStartMs, connectEndMs, sslStartMs, sslEndMs, sendingStartMs, sendingEndMs, pushStartMs, pushEndMs, responseStartMs, requestEndMs, socketReused, sentByteCount, receivedByteCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onNativeAdapterDestroyed() {
        Object object = this.mUrlRequestAdapterLock;
        synchronized (object) {
            if (this.mOnDestroyedCallbackForTesting != null) {
                this.mOnDestroyedCallbackForTesting.run();
            }
            if (this.mException == null) {
                return;
            }
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CronetUrlRequest.this.mCallback.onFailed((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo, CronetUrlRequest.this.mException);
                    CronetUrlRequest.this.maybeReportMetrics();
                }
                catch (Exception e) {
                    Log.e(CronetUrlRequestContext.LOG_TAG, "Exception in onFailed method", e);
                }
            }
        };
        try {
            this.mExecutor.execute(task);
        }
        catch (RejectedExecutionException e) {
            Log.e(CronetUrlRequestContext.LOG_TAG, "Exception posting task to executor", e);
        }
    }

    void checkCallingThread() {
        if (!this.mAllowDirectExecutor && this.mRequestContext.isNetworkThread(Thread.currentThread())) {
            throw new InlineExecutionProhibitedException();
        }
    }

    private int mapUrlRequestErrorToApiErrorCode(int errorCode) {
        switch (errorCode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
        }
        Log.e(CronetUrlRequestContext.LOG_TAG, "Unknown error code: " + errorCode, new Object[0]);
        return errorCode;
    }

    private void maybeReportMetrics() {
        if (this.mMetrics != null) {
            this.mRequestContext.reportFinished((RequestFinishedInfo)new RequestFinishedInfoImpl(this.mInitialUrl, this.mRequestAnnotations, (RequestFinishedInfo.Metrics)this.mMetrics, this.mFinishedReason, (UrlResponseInfo)this.mResponseInfo, this.mException));
        }
    }

    private native long nativeCreateRequestAdapter(long var1, String var3, int var4, boolean var5, boolean var6, boolean var7);

    @NativeClassQualifiedName(value="CronetURLRequestAdapter")
    private native boolean nativeSetHttpMethod(long var1, String var3);

    @NativeClassQualifiedName(value="CronetURLRequestAdapter")
    private native boolean nativeAddRequestHeader(long var1, String var3, String var4);

    @NativeClassQualifiedName(value="CronetURLRequestAdapter")
    private native void nativeStart(long var1);

    @NativeClassQualifiedName(value="CronetURLRequestAdapter")
    private native void nativeFollowDeferredRedirect(long var1);

    @NativeClassQualifiedName(value="CronetURLRequestAdapter")
    private native boolean nativeReadData(long var1, ByteBuffer var3, int var4, int var5);

    @NativeClassQualifiedName(value="CronetURLRequestAdapter")
    private native void nativeDestroy(long var1, boolean var3);

    @NativeClassQualifiedName(value="CronetURLRequestAdapter")
    private native void nativeGetStatus(long var1, VersionSafeCallbacks.UrlRequestStatusListener var3);

    private final class OnReadCompletedRunnable
    implements Runnable {
        ByteBuffer mByteBuffer;

        private OnReadCompletedRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CronetUrlRequest.this.checkCallingThread();
            ByteBuffer buffer = this.mByteBuffer;
            this.mByteBuffer = null;
            try {
                Object object = CronetUrlRequest.this.mUrlRequestAdapterLock;
                synchronized (object) {
                    if (CronetUrlRequest.this.isDoneLocked()) {
                        return;
                    }
                    CronetUrlRequest.this.mWaitingOnRead = true;
                }
                CronetUrlRequest.this.mCallback.onReadCompleted((UrlRequest)CronetUrlRequest.this, (UrlResponseInfo)CronetUrlRequest.this.mResponseInfo, buffer);
            }
            catch (Exception e) {
                CronetUrlRequest.this.onCallbackException(e);
            }
        }
    }

    private static final class HeadersList
    extends ArrayList<Map.Entry<String, String>> {
        private HeadersList() {
        }
    }
}

