/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Log;
import org.chromium.base.ObserverList;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.base.annotations.UsedByReflection;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.CronetEngine;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.NetworkQualityRttListener;
import org.chromium.net.NetworkQualityThroughputListener;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UrlRequest;
import org.chromium.net.impl.BidirectionalStreamBuilderImpl;
import org.chromium.net.impl.CronetBidirectionalStream;
import org.chromium.net.impl.CronetEngineBase;
import org.chromium.net.impl.CronetEngineBuilderImpl;
import org.chromium.net.impl.CronetLibraryLoader;
import org.chromium.net.impl.CronetUrlRequest;
import org.chromium.net.impl.ImplVersion;
import org.chromium.net.impl.UrlRequestBase;
import org.chromium.net.impl.VersionSafeCallbacks;
import org.chromium.net.urlconnection.CronetHttpURLConnection;
import org.chromium.net.urlconnection.CronetURLStreamHandlerFactory;

@JNINamespace(value="cronet")
@UsedByReflection(value="CronetEngine.java")
@VisibleForTesting
public class CronetUrlRequestContext
extends CronetEngineBase {
    private static final int LOG_NONE = 3;
    private static final int LOG_DEBUG = -1;
    private static final int LOG_VERBOSE = -2;
    static final String LOG_TAG = CronetUrlRequestContext.class.getSimpleName();
    private final Object mLock = new Object();
    private final ConditionVariable mInitCompleted = new ConditionVariable(false);
    private final AtomicInteger mActiveRequestCount = new AtomicInteger(0);
    @GuardedBy(value="mLock")
    private long mUrlRequestContextAdapter = 0L;
    private Thread mNetworkThread;
    private boolean mNetworkQualityEstimatorEnabled;
    private final Object mNetworkQualityLock = new Object();
    private final Object mFinishedListenerLock = new Object();
    @GuardedBy(value="mNetworkQualityLock")
    private int mEffectiveConnectionType = 0;
    @GuardedBy(value="mNetworkQualityLock")
    private int mHttpRttMs = -1;
    @GuardedBy(value="mNetworkQualityLock")
    private int mTransportRttMs = -1;
    @GuardedBy(value="mNetworkQualityLock")
    private int mDownstreamThroughputKbps = -1;
    @GuardedBy(value="mNetworkQualityLock")
    private final ObserverList<VersionSafeCallbacks.NetworkQualityRttListenerWrapper> mRttListenerList = new ObserverList();
    @GuardedBy(value="mNetworkQualityLock")
    private final ObserverList<VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper> mThroughputListenerList = new ObserverList();
    @GuardedBy(value="mFinishedListenerLock")
    private final Map<RequestFinishedInfo.Listener, VersionSafeCallbacks.RequestFinishedInfoListener> mFinishedListenerMap = new HashMap<RequestFinishedInfo.Listener, VersionSafeCallbacks.RequestFinishedInfoListener>();
    private ConditionVariable mWaitGetCertVerifierDataComplete = new ConditionVariable();
    private String mCertVerifierData;
    private volatile ConditionVariable mStopNetLogCompleted;
    @GuardedBy(value="mLock")
    private boolean mIsLogging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByReflection(value="CronetEngine.java")
    public CronetUrlRequestContext(final CronetEngineBuilderImpl builder) {
        CronetLibraryLoader.ensureInitialized(builder.getContext(), builder);
        CronetUrlRequestContext.nativeSetMinLogLevel(this.getLoggingLevel());
        Object object = this.mLock;
        synchronized (object) {
            this.mUrlRequestContextAdapter = CronetUrlRequestContext.nativeCreateRequestContextAdapter(CronetUrlRequestContext.createNativeUrlRequestContextConfig(builder));
            if (this.mUrlRequestContextAdapter == 0L) {
                throw new NullPointerException("Context Adapter creation failed.");
            }
            this.mNetworkQualityEstimatorEnabled = builder.networkQualityEstimatorEnabled();
        }
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CronetLibraryLoader.ensureInitializedOnMainThread(builder.getContext());
                Object object = CronetUrlRequestContext.this.mLock;
                synchronized (object) {
                    CronetUrlRequestContext.this.nativeInitRequestContextOnMainThread(CronetUrlRequestContext.this.mUrlRequestContextAdapter);
                }
            }
        };
        if (Looper.getMainLooper() == Looper.myLooper()) {
            task.run();
        } else {
            new Handler(Looper.getMainLooper()).post(task);
        }
    }

    @VisibleForTesting
    public static long createNativeUrlRequestContextConfig(CronetEngineBuilderImpl builder) {
        long urlRequestContextConfig = CronetUrlRequestContext.nativeCreateRequestContextConfig(builder.getUserAgent(), builder.storagePath(), builder.quicEnabled(), builder.getDefaultQuicUserAgentId(), builder.http2Enabled(), builder.sdchEnabled(), builder.brotliEnabled(), builder.cacheDisabled(), builder.httpCacheMode(), builder.httpCacheMaxSize(), builder.experimentalOptions(), builder.mockCertVerifier(), builder.networkQualityEstimatorEnabled(), builder.publicKeyPinningBypassForLocalTrustAnchorsEnabled(), builder.certVerifierData());
        for (CronetEngineBuilderImpl.QuicHint quicHint : builder.quicHints()) {
            CronetUrlRequestContext.nativeAddQuicHint(urlRequestContextConfig, quicHint.mHost, quicHint.mPort, quicHint.mAlternatePort);
        }
        for (CronetEngineBuilderImpl.Pkp pkp : builder.publicKeyPins()) {
            CronetUrlRequestContext.nativeAddPkp(urlRequestContextConfig, pkp.mHost, pkp.mHashes, pkp.mIncludeSubdomains, pkp.mExpirationDate.getTime());
        }
        return urlRequestContextConfig;
    }

    public ExperimentalBidirectionalStream.Builder newBidirectionalStreamBuilder(String url, BidirectionalStream.Callback callback, Executor executor) {
        return new BidirectionalStreamBuilderImpl(url, callback, executor, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UrlRequestBase createRequest(String url, UrlRequest.Callback callback, Executor executor, int priority, Collection<Object> requestAnnotations, boolean disableCache, boolean disableConnectionMigration, boolean allowDirectExecutor) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            return new CronetUrlRequest(this, url, priority, callback, executor, requestAnnotations, disableCache, disableConnectionMigration, allowDirectExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExperimentalBidirectionalStream createBidirectionalStream(String url, BidirectionalStream.Callback callback, Executor executor, String httpMethod, List<Map.Entry<String, String>> requestHeaders, int priority, boolean delayRequestHeadersUntilFirstFlush, Collection<Object> requestAnnotations) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            return new CronetBidirectionalStream(this, url, priority, callback, executor, httpMethod, requestHeaders, delayRequestHeadersUntilFirstFlush, requestAnnotations);
        }
    }

    public String getVersionString() {
        return "Cronet/" + ImplVersion.getCronetVersionWithLastChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            if (this.mActiveRequestCount.get() != 0) {
                throw new IllegalStateException("Cannot shutdown with active requests.");
            }
            if (Thread.currentThread() == this.mNetworkThread) {
                throw new IllegalThreadStateException("Cannot shutdown from network thread.");
            }
        }
        this.mInitCompleted.block();
        this.stopNetLog();
        object = this.mLock;
        synchronized (object) {
            if (!this.haveRequestContextAdapter()) {
                return;
            }
            this.nativeDestroy(this.mUrlRequestContextAdapter);
            this.mUrlRequestContextAdapter = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNetLogToFile(String fileName, boolean logAll) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            if (!this.nativeStartNetLogToFile(this.mUrlRequestContextAdapter, fileName, logAll)) {
                throw new RuntimeException("Unable to start NetLog");
            }
            this.mIsLogging = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNetLogToDisk(String dirPath, boolean logAll, int maxSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            this.nativeStartNetLogToDisk(this.mUrlRequestContextAdapter, dirPath, logAll, maxSize);
            this.mIsLogging = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopNetLog() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsLogging) {
                return;
            }
            this.checkHaveAdapter();
            this.mStopNetLogCompleted = new ConditionVariable();
            this.nativeStopNetLog(this.mUrlRequestContextAdapter);
            this.mIsLogging = false;
        }
        this.mStopNetLogCompleted.block();
    }

    @CalledByNative
    public void stopNetLogCompleted() {
        this.mStopNetLogCompleted.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCertVerifierData(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be a positive value");
        }
        if (timeout == 0L) {
            timeout = 100L;
        }
        this.mWaitGetCertVerifierDataComplete.close();
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            this.nativeGetCertVerifierData(this.mUrlRequestContextAdapter);
        }
        this.mWaitGetCertVerifierDataComplete.block(timeout);
        return this.mCertVerifierData;
    }

    public byte[] getGlobalMetricsDeltas() {
        return CronetUrlRequestContext.nativeGetHistogramDeltas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEffectiveConnectionType() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return CronetUrlRequestContext.convertConnectionTypeToApiValue(this.mEffectiveConnectionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHttpRttMs() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return this.mHttpRttMs != -1 ? this.mHttpRttMs : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransportRttMs() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return this.mTransportRttMs != -1 ? this.mTransportRttMs : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownstreamThroughputKbps() {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            return this.mDownstreamThroughputKbps != -1 ? this.mDownstreamThroughputKbps : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void configureNetworkQualityEstimatorForTesting(boolean useLocalHostRequests, boolean useSmallerResponses, boolean disableOfflineCheck) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            this.nativeConfigureNetworkQualityEstimatorForTesting(this.mUrlRequestContextAdapter, useLocalHostRequests, useSmallerResponses, disableOfflineCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRttListener(NetworkQualityRttListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mRttListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    this.nativeProvideRTTObservations(this.mUrlRequestContextAdapter, true);
                }
            }
            this.mRttListenerList.addObserver(new VersionSafeCallbacks.NetworkQualityRttListenerWrapper(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRttListener(NetworkQualityRttListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mRttListenerList.removeObserver(new VersionSafeCallbacks.NetworkQualityRttListenerWrapper(listener)) && this.mRttListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    this.nativeProvideRTTObservations(this.mUrlRequestContextAdapter, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThroughputListener(NetworkQualityThroughputListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mThroughputListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    this.nativeProvideThroughputObservations(this.mUrlRequestContextAdapter, true);
                }
            }
            this.mThroughputListenerList.addObserver(new VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThroughputListener(NetworkQualityThroughputListener listener) {
        if (!this.mNetworkQualityEstimatorEnabled) {
            throw new IllegalStateException("Network quality estimator must be enabled");
        }
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            if (this.mThroughputListenerList.removeObserver(new VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper(listener)) && this.mThroughputListenerList.isEmpty()) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.checkHaveAdapter();
                    this.nativeProvideThroughputObservations(this.mUrlRequestContextAdapter, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestFinishedListener(RequestFinishedInfo.Listener listener) {
        Object object = this.mFinishedListenerLock;
        synchronized (object) {
            this.mFinishedListenerMap.put(listener, new VersionSafeCallbacks.RequestFinishedInfoListener(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestFinishedListener(RequestFinishedInfo.Listener listener) {
        Object object = this.mFinishedListenerLock;
        synchronized (object) {
            this.mFinishedListenerMap.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRequestFinishedListener() {
        Object object = this.mFinishedListenerLock;
        synchronized (object) {
            return !this.mFinishedListenerMap.isEmpty();
        }
    }

    public URLConnection openConnection(URL url) {
        return this.openConnection(url, Proxy.NO_PROXY);
    }

    public URLConnection openConnection(URL url, Proxy proxy) {
        if (proxy.type() != Proxy.Type.DIRECT) {
            throw new UnsupportedOperationException();
        }
        String protocol = url.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return new CronetHttpURLConnection(url, (CronetEngine)this);
        }
        throw new UnsupportedOperationException("Unexpected protocol:" + protocol);
    }

    public URLStreamHandlerFactory createURLStreamHandlerFactory() {
        return new CronetURLStreamHandlerFactory(this);
    }

    void onRequestStarted() {
        this.mActiveRequestCount.incrementAndGet();
    }

    void onRequestDestroyed() {
        this.mActiveRequestCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long getUrlRequestContextAdapter() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkHaveAdapter();
            return this.mUrlRequestContextAdapter;
        }
    }

    @GuardedBy(value="mLock")
    private void checkHaveAdapter() throws IllegalStateException {
        if (!this.haveRequestContextAdapter()) {
            throw new IllegalStateException("Engine is shut down.");
        }
    }

    @GuardedBy(value="mLock")
    private boolean haveRequestContextAdapter() {
        return this.mUrlRequestContextAdapter != 0L;
    }

    private int getLoggingLevel() {
        int loggingLevel = Log.isLoggable(LOG_TAG, 2) ? -2 : (Log.isLoggable(LOG_TAG, 3) ? -1 : 3);
        return loggingLevel;
    }

    private static int convertConnectionTypeToApiValue(int type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 0: {
                return 0;
            }
        }
        throw new RuntimeException("Internal Error: Illegal EffectiveConnectionType value " + type);
    }

    @CalledByNative
    private void initNetworkThread() {
        this.mNetworkThread = Thread.currentThread();
        this.mInitCompleted.open();
        Thread.currentThread().setName("ChromiumNet");
        Process.setThreadPriority((int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onEffectiveConnectionTypeChanged(int effectiveConnectionType) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            this.mEffectiveConnectionType = effectiveConnectionType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onRTTOrThroughputEstimatesComputed(int httpRttMs, int transportRttMs, int downstreamThroughputKbps) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            this.mHttpRttMs = httpRttMs;
            this.mTransportRttMs = transportRttMs;
            this.mDownstreamThroughputKbps = downstreamThroughputKbps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onRttObservation(final int rttMs, final long whenMs, final int source) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            for (final VersionSafeCallbacks.NetworkQualityRttListenerWrapper listener : this.mRttListenerList) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        listener.onRttObservation(rttMs, whenMs, source);
                    }
                };
                CronetUrlRequestContext.postObservationTaskToExecutor(listener.getExecutor(), task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void onThroughputObservation(final int throughputKbps, final long whenMs, final int source) {
        Object object = this.mNetworkQualityLock;
        synchronized (object) {
            for (final VersionSafeCallbacks.NetworkQualityThroughputListenerWrapper listener : this.mThroughputListenerList) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        listener.onThroughputObservation(throughputKbps, whenMs, source);
                    }
                };
                CronetUrlRequestContext.postObservationTaskToExecutor(listener.getExecutor(), task);
            }
        }
    }

    @CalledByNative
    private void onGetCertVerifierData(String certVerifierData) {
        this.mCertVerifierData = certVerifierData;
        this.mWaitGetCertVerifierDataComplete.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportFinished(final RequestFinishedInfo requestInfo) {
        ArrayList<VersionSafeCallbacks.RequestFinishedInfoListener> currentListeners;
        Iterator<VersionSafeCallbacks.RequestFinishedInfoListener> iterator = this.mFinishedListenerLock;
        synchronized (iterator) {
            currentListeners = new ArrayList<VersionSafeCallbacks.RequestFinishedInfoListener>(this.mFinishedListenerMap.values());
        }
        for (final VersionSafeCallbacks.RequestFinishedInfoListener listener : currentListeners) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    listener.onRequestFinished(requestInfo);
                }
            };
            CronetUrlRequestContext.postObservationTaskToExecutor(listener.getExecutor(), task);
        }
    }

    private static void postObservationTaskToExecutor(Executor executor, Runnable task) {
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException failException) {
            Log.e(LOG_TAG, "Exception posting task to executor", failException);
        }
    }

    private static native long nativeCreateRequestContextConfig(String var0, String var1, boolean var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, long var9, String var11, long var12, boolean var14, boolean var15, String var16);

    private static native void nativeAddQuicHint(long var0, String var2, int var3, int var4);

    private static native void nativeAddPkp(long var0, String var2, byte[][] var3, boolean var4, long var5);

    private static native long nativeCreateRequestContextAdapter(long var0);

    private static native int nativeSetMinLogLevel(int var0);

    private static native byte[] nativeGetHistogramDeltas();

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeDestroy(long var1);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native boolean nativeStartNetLogToFile(long var1, String var3, boolean var4);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeStartNetLogToDisk(long var1, String var3, boolean var4, int var5);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeStopNetLog(long var1);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeGetCertVerifierData(long var1);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeInitRequestContextOnMainThread(long var1);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeConfigureNetworkQualityEstimatorForTesting(long var1, boolean var3, boolean var4, boolean var5);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeProvideRTTObservations(long var1, boolean var3);

    @NativeClassQualifiedName(value="CronetURLRequestContextAdapter")
    private native void nativeProvideThroughputObservations(long var1, boolean var3);

    public boolean isNetworkThread(Thread thread) {
        return thread == this.mNetworkThread;
    }
}

