/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.urlconnection;

import java.io.IOException;
import java.net.HttpRetryException;
import java.nio.ByteBuffer;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;
import org.chromium.net.urlconnection.CronetHttpURLConnection;
import org.chromium.net.urlconnection.CronetOutputStream;
import org.chromium.net.urlconnection.MessageLoop;

final class CronetChunkedOutputStream
extends CronetOutputStream {
    private final CronetHttpURLConnection mConnection;
    private final MessageLoop mMessageLoop;
    private final ByteBuffer mBuffer;
    private final UploadDataProvider mUploadDataProvider = new UploadDataProviderImpl();
    private boolean mLastChunk = false;

    CronetChunkedOutputStream(CronetHttpURLConnection connection, int chunkLength, MessageLoop messageLoop) {
        if (connection == null) {
            throw new NullPointerException();
        }
        if (chunkLength <= 0) {
            throw new IllegalArgumentException("chunkLength should be greater than 0");
        }
        this.mBuffer = ByteBuffer.allocate(chunkLength);
        this.mConnection = connection;
        this.mMessageLoop = messageLoop;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.ensureBufferHasRemaining();
        this.mBuffer.put((byte)oneByte);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        int sent;
        this.checkNotClosed();
        if (buffer.length - offset < count || offset < 0 || count < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int toSend = count; toSend > 0; toSend -= sent) {
            sent = Math.min(toSend, this.mBuffer.remaining());
            this.mBuffer.put(buffer, offset + count - toSend, sent);
            this.ensureBufferHasRemaining();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!this.mLastChunk) {
            this.mLastChunk = true;
            this.mBuffer.flip();
        }
    }

    @Override
    void setConnected() throws IOException {
    }

    @Override
    void checkReceivedEnoughContent() throws IOException {
    }

    @Override
    UploadDataProvider getUploadDataProvider() {
        return this.mUploadDataProvider;
    }

    private void ensureBufferHasRemaining() throws IOException {
        if (!this.mBuffer.hasRemaining()) {
            this.uploadBufferInternal();
        }
    }

    private void uploadBufferInternal() throws IOException {
        this.checkNotClosed();
        this.mBuffer.flip();
        this.mMessageLoop.loop();
        this.checkNoException();
    }

    private class UploadDataProviderImpl
    extends UploadDataProvider {
        private UploadDataProviderImpl() {
        }

        public long getLength() {
            return -1L;
        }

        public void read(UploadDataSink uploadDataSink, ByteBuffer byteBuffer) {
            if (byteBuffer.remaining() >= CronetChunkedOutputStream.this.mBuffer.remaining()) {
                byteBuffer.put(CronetChunkedOutputStream.this.mBuffer);
                CronetChunkedOutputStream.this.mBuffer.clear();
                uploadDataSink.onReadSucceeded(CronetChunkedOutputStream.this.mLastChunk);
                if (!CronetChunkedOutputStream.this.mLastChunk) {
                    CronetChunkedOutputStream.this.mMessageLoop.quit();
                }
            } else {
                int oldLimit = CronetChunkedOutputStream.this.mBuffer.limit();
                CronetChunkedOutputStream.this.mBuffer.limit(CronetChunkedOutputStream.this.mBuffer.position() + byteBuffer.remaining());
                byteBuffer.put(CronetChunkedOutputStream.this.mBuffer);
                CronetChunkedOutputStream.this.mBuffer.limit(oldLimit);
                uploadDataSink.onReadSucceeded(false);
            }
        }

        public void rewind(UploadDataSink uploadDataSink) {
            uploadDataSink.onRewindError((Exception)new HttpRetryException("Cannot retry streamed Http body", -1));
        }
    }
}

