/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.urlconnection;

import android.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.chromium.base.Log;
import org.chromium.net.CronetEngine;
import org.chromium.net.CronetException;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.urlconnection.CronetBufferedOutputStream;
import org.chromium.net.urlconnection.CronetChunkedOutputStream;
import org.chromium.net.urlconnection.CronetFixedModeOutputStream;
import org.chromium.net.urlconnection.CronetInputStream;
import org.chromium.net.urlconnection.CronetOutputStream;
import org.chromium.net.urlconnection.MessageLoop;

public class CronetHttpURLConnection
extends HttpURLConnection {
    private static final String TAG = CronetHttpURLConnection.class.getSimpleName();
    private static final String CONTENT_LENGTH = "Content-Length";
    private final CronetEngine mCronetEngine;
    private final MessageLoop mMessageLoop;
    private UrlRequest mRequest;
    private final List<Pair<String, String>> mRequestHeaders;
    private CronetInputStream mInputStream;
    private CronetOutputStream mOutputStream;
    private UrlResponseInfo mResponseInfo;
    private CronetException mException;
    private boolean mOnRedirectCalled;
    private boolean mHasResponseHeadersOrCompleted;
    private List<Map.Entry<String, String>> mResponseHeadersList;
    private Map<String, List<String>> mResponseHeadersMap;

    public CronetHttpURLConnection(URL url, CronetEngine cronetEngine) {
        super(url);
        this.mCronetEngine = cronetEngine;
        this.mMessageLoop = new MessageLoop();
        this.mInputStream = new CronetInputStream(this);
        this.mRequestHeaders = new ArrayList<Pair<String, String>>();
    }

    @Override
    public void connect() throws IOException {
        this.getOutputStream();
        this.startRequest();
    }

    @Override
    public void disconnect() {
        if (this.connected) {
            this.mRequest.cancel();
        }
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.getResponse();
        return this.mResponseInfo.getHttpStatusText();
    }

    @Override
    public int getResponseCode() throws IOException {
        this.getResponse();
        return this.mResponseInfo.getHttpStatusCode();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.getResponse();
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        return this.getAllHeaders();
    }

    @Override
    public final String getHeaderField(String fieldName) {
        try {
            this.getResponse();
        }
        catch (IOException e) {
            return null;
        }
        Map<String, List<String>> map = this.getAllHeaders();
        if (!map.containsKey(fieldName)) {
            return null;
        }
        List<String> values = map.get(fieldName);
        return values.get(values.size() - 1);
    }

    @Override
    public final String getHeaderFieldKey(int pos) {
        Map.Entry<String, String> header = this.getHeaderFieldEntry(pos);
        if (header == null) {
            return null;
        }
        return header.getKey();
    }

    @Override
    public final String getHeaderField(int pos) {
        Map.Entry<String, String> header = this.getHeaderFieldEntry(pos);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.getResponse();
        if (!this.instanceFollowRedirects && this.mOnRedirectCalled) {
            throw new IOException("Cannot read response body of a redirect.");
        }
        if (this.mResponseInfo.getHttpStatusCode() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        return this.mInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.mOutputStream == null && this.doOutput) {
            if (this.connected) {
                throw new ProtocolException("Cannot write to OutputStream after receiving response.");
            }
            if (this.isChunkedUpload()) {
                this.mOutputStream = new CronetChunkedOutputStream(this, this.chunkLength, this.mMessageLoop);
                this.startRequest();
            } else {
                long fixedStreamingModeContentLength = this.getStreamingModeContentLength();
                if (fixedStreamingModeContentLength != -1L) {
                    this.mOutputStream = new CronetFixedModeOutputStream(this, fixedStreamingModeContentLength, this.mMessageLoop);
                    this.startRequest();
                } else {
                    Log.d(TAG, "Outputstream is being buffered in memory.");
                    String length = this.getRequestProperty(CONTENT_LENGTH);
                    if (length == null) {
                        this.mOutputStream = new CronetBufferedOutputStream(this);
                    } else {
                        long lengthParsed = Long.parseLong(length);
                        this.mOutputStream = new CronetBufferedOutputStream(this, lengthParsed);
                    }
                }
            }
        }
        return this.mOutputStream;
    }

    private long getStreamingModeContentLength() {
        long contentLength = this.fixedContentLength;
        try {
            Class<?> parent = this.getClass();
            long superFixedContentLengthLong = parent.getField("fixedContentLengthLong").getLong(this);
            if (superFixedContentLengthLong != -1L) {
                contentLength = superFixedContentLengthLong;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contentLength;
    }

    private void startRequest() throws IOException {
        if (this.connected) {
            return;
        }
        UrlRequest.Builder requestBuilder = this.mCronetEngine.newUrlRequestBuilder(this.getURL().toString(), (UrlRequest.Callback)new CronetUrlRequestCallback(), (Executor)this.mMessageLoop);
        if (this.doOutput) {
            if (this.method.equals("GET")) {
                this.method = "POST";
            }
            if (this.mOutputStream != null) {
                requestBuilder.setUploadDataProvider(this.mOutputStream.getUploadDataProvider(), (Executor)this.mMessageLoop);
                if (this.getRequestProperty(CONTENT_LENGTH) == null && !this.isChunkedUpload()) {
                    this.addRequestProperty(CONTENT_LENGTH, Long.toString(this.mOutputStream.getUploadDataProvider().getLength()));
                }
                this.mOutputStream.setConnected();
            } else if (this.getRequestProperty(CONTENT_LENGTH) == null) {
                this.addRequestProperty(CONTENT_LENGTH, "0");
            }
            if (this.getRequestProperty("Content-Type") == null) {
                this.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
        }
        for (Pair<String, String> requestHeader : this.mRequestHeaders) {
            requestBuilder.addHeader((String)requestHeader.first, (String)requestHeader.second);
        }
        if (!this.getUseCaches()) {
            requestBuilder.disableCache();
        }
        requestBuilder.setHttpMethod(this.method);
        this.connected = true;
        this.mRequest = requestBuilder.build();
        this.mRequest.start();
    }

    @Override
    public InputStream getErrorStream() {
        try {
            this.getResponse();
        }
        catch (IOException e) {
            return null;
        }
        if (this.mResponseInfo.getHttpStatusCode() >= 400) {
            return this.mInputStream;
        }
        return null;
    }

    @Override
    public final void addRequestProperty(String key, String value) {
        this.setRequestPropertyInternal(key, value, false);
    }

    @Override
    public final void setRequestProperty(String key, String value) {
        this.setRequestPropertyInternal(key, value, true);
    }

    private final void setRequestPropertyInternal(String key, String value, boolean overwrite) {
        if (this.connected) {
            throw new IllegalStateException("Cannot modify request property after connection is made.");
        }
        int index = this.findRequestProperty(key);
        if (index >= 0) {
            if (overwrite) {
                this.mRequestHeaders.remove(index);
            } else {
                throw new UnsupportedOperationException("Cannot add multiple headers of the same key, " + key + ". crbug.com/432719.");
            }
        }
        this.mRequestHeaders.add((Pair<String, String>)Pair.create((Object)key, (Object)value));
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request headers after connection is set.");
        }
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Pair<String, String> entry : this.mRequestHeaders) {
            if (map.containsKey(entry.first)) {
                throw new IllegalStateException("Should not have multiple values.");
            }
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(entry.second);
            map.put(entry.first, Collections.unmodifiableList(values));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public String getRequestProperty(String key) {
        int index = this.findRequestProperty(key);
        if (index >= 0) {
            return (String)this.mRequestHeaders.get((int)index).second;
        }
        return null;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void setConnectTimeout(int timeout) {
        Log.d(TAG, "setConnectTimeout is not supported by CronetHttpURLConnection");
    }

    void getMoreData(ByteBuffer byteBuffer) throws IOException {
        this.mRequest.read(byteBuffer);
        this.mMessageLoop.loop(this.getReadTimeout());
    }

    private int findRequestProperty(String key) {
        for (int i = 0; i < this.mRequestHeaders.size(); ++i) {
            Pair<String, String> entry = this.mRequestHeaders.get(i);
            if (!((String)entry.first).equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    private void getResponse() throws IOException {
        if (this.mOutputStream != null) {
            this.mOutputStream.checkReceivedEnoughContent();
            if (this.isChunkedUpload()) {
                this.mOutputStream.close();
            }
        }
        if (!this.mHasResponseHeadersOrCompleted) {
            this.startRequest();
            this.mMessageLoop.loop();
        }
        this.checkHasResponseHeaders();
    }

    private void checkHasResponseHeaders() throws IOException {
        if (!this.mHasResponseHeadersOrCompleted) {
            throw new IllegalStateException("No response.");
        }
        if (this.mException != null) {
            throw this.mException;
        }
        if (this.mResponseInfo == null) {
            throw new NullPointerException("Response info is null when there is no exception.");
        }
    }

    private Map.Entry<String, String> getHeaderFieldEntry(int pos) {
        try {
            this.getResponse();
        }
        catch (IOException e) {
            return null;
        }
        List<Map.Entry<String, String>> headers = this.getAllHeadersAsList();
        if (pos >= headers.size()) {
            return null;
        }
        return headers.get(pos);
    }

    private boolean isChunkedUpload() {
        return this.chunkLength > 0;
    }

    private Map<String, List<String>> getAllHeaders() {
        if (this.mResponseHeadersMap != null) {
            return this.mResponseHeadersMap;
        }
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, String> entry : this.getAllHeadersAsList()) {
            ArrayList<String> values = new ArrayList<String>();
            if (map.containsKey(entry.getKey())) {
                values.addAll((Collection)map.get(entry.getKey()));
            }
            values.add(entry.getValue());
            map.put(entry.getKey(), Collections.unmodifiableList(values));
        }
        this.mResponseHeadersMap = Collections.unmodifiableMap(map);
        return this.mResponseHeadersMap;
    }

    private List<Map.Entry<String, String>> getAllHeadersAsList() {
        if (this.mResponseHeadersList != null) {
            return this.mResponseHeadersList;
        }
        this.mResponseHeadersList = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry entry : this.mResponseInfo.getAllHeadersAsList()) {
            if (((String)entry.getKey()).equalsIgnoreCase("Content-Encoding")) continue;
            this.mResponseHeadersList.add(new AbstractMap.SimpleImmutableEntry(entry));
        }
        this.mResponseHeadersList = Collections.unmodifiableList(this.mResponseHeadersList);
        return this.mResponseHeadersList;
    }

    private class CronetUrlRequestCallback
    extends UrlRequest.Callback {
        public void onResponseStarted(UrlRequest request, UrlResponseInfo info) {
            CronetHttpURLConnection.this.mResponseInfo = info;
            CronetHttpURLConnection.this.mHasResponseHeadersOrCompleted = true;
            CronetHttpURLConnection.this.mMessageLoop.quit();
        }

        public void onReadCompleted(UrlRequest request, UrlResponseInfo info, ByteBuffer byteBuffer) {
            CronetHttpURLConnection.this.mResponseInfo = info;
            CronetHttpURLConnection.this.mMessageLoop.quit();
        }

        public void onRedirectReceived(UrlRequest request, UrlResponseInfo info, String newLocationUrl) {
            CronetHttpURLConnection.this.mOnRedirectCalled = true;
            try {
                URL newUrl = new URL(newLocationUrl);
                boolean sameProtocol = newUrl.getProtocol().equals(CronetHttpURLConnection.this.url.getProtocol());
                if (CronetHttpURLConnection.this.instanceFollowRedirects) {
                    CronetHttpURLConnection.this.url = newUrl;
                }
                if (CronetHttpURLConnection.this.instanceFollowRedirects && sameProtocol) {
                    CronetHttpURLConnection.this.mRequest.followRedirect();
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            CronetHttpURLConnection.this.mResponseInfo = info;
            CronetHttpURLConnection.this.mRequest.cancel();
            this.setResponseDataCompleted(null);
        }

        public void onSucceeded(UrlRequest request, UrlResponseInfo info) {
            CronetHttpURLConnection.this.mResponseInfo = info;
            this.setResponseDataCompleted(null);
        }

        public void onFailed(UrlRequest request, UrlResponseInfo info, CronetException exception) {
            if (exception == null) {
                throw new IllegalStateException("Exception cannot be null in onFailed.");
            }
            CronetHttpURLConnection.this.mResponseInfo = info;
            CronetHttpURLConnection.this.mException = exception;
            this.setResponseDataCompleted((IOException)CronetHttpURLConnection.this.mException);
        }

        public void onCanceled(UrlRequest request, UrlResponseInfo info) {
            CronetHttpURLConnection.this.mResponseInfo = info;
            this.setResponseDataCompleted(new IOException("stream closed"));
        }

        private void setResponseDataCompleted(IOException exception) {
            if (CronetHttpURLConnection.this.mInputStream != null) {
                CronetHttpURLConnection.this.mInputStream.setResponseDataCompleted(exception);
            }
            if (CronetHttpURLConnection.this.mOutputStream != null) {
                CronetHttpURLConnection.this.mOutputStream.setRequestCompleted(exception);
            }
            CronetHttpURLConnection.this.mHasResponseHeadersOrCompleted = true;
            CronetHttpURLConnection.this.mMessageLoop.quit();
        }
    }
}

