/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.urlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.chromium.net.urlconnection.CronetHttpURLConnection;

class CronetInputStream
extends InputStream {
    private final CronetHttpURLConnection mHttpURLConnection;
    private boolean mResponseDataCompleted;
    private ByteBuffer mBuffer;
    private IOException mException;
    private static final int READ_BUFFER_SIZE = 32768;

    public CronetInputStream(CronetHttpURLConnection httpURLConnection) {
        this.mHttpURLConnection = httpURLConnection;
    }

    @Override
    public int read() throws IOException {
        this.getMoreDataIfNeeded();
        if (this.hasUnreadData()) {
            return this.mBuffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        if (byteOffset < 0 || byteCount < 0 || byteOffset + byteCount > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (byteCount == 0) {
            return 0;
        }
        this.getMoreDataIfNeeded();
        if (this.hasUnreadData()) {
            int bytesRead = Math.min(this.mBuffer.limit() - this.mBuffer.position(), byteCount);
            this.mBuffer.get(buffer, byteOffset, bytesRead);
            return bytesRead;
        }
        return -1;
    }

    void setResponseDataCompleted(IOException exception) {
        this.mException = exception;
        this.mResponseDataCompleted = true;
        this.mBuffer = null;
    }

    private void getMoreDataIfNeeded() throws IOException {
        if (this.mResponseDataCompleted) {
            if (this.mException != null) {
                throw this.mException;
            }
            return;
        }
        if (!this.hasUnreadData()) {
            if (this.mBuffer == null) {
                this.mBuffer = ByteBuffer.allocateDirect(32768);
            }
            this.mBuffer.clear();
            this.mHttpURLConnection.getMoreData(this.mBuffer);
            if (this.mException != null) {
                throw this.mException;
            }
            if (this.mBuffer != null) {
                this.mBuffer.flip();
            }
        }
    }

    private boolean hasUnreadData() {
        return this.mBuffer != null && this.mBuffer.hasRemaining();
    }
}

