/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ZoneInfo {
    private static int DOMAIN_FROZEN_SECONDS = 600;
    private final int ttl;
    public final List<String> upDomainsList;
    public final Map<String, Long> upDomainsMap;

    public ZoneInfo(int ttl, List<String> upDomainsList, Map<String, Long> upDomainsMap) {
        this.ttl = ttl;
        this.upDomainsList = upDomainsList;
        this.upDomainsMap = upDomainsMap;
    }

    public static ZoneInfo buildFromJson(JSONObject obj) throws JSONException {
        String[] upDomainTags;
        int ttl = obj.getInt("ttl");
        ArrayList<String> domainsList = new ArrayList<String>();
        ConcurrentHashMap<String, Long> domainsMap = new ConcurrentHashMap<String, Long>();
        JSONObject upObj = obj.getJSONObject("up");
        for (String tag : upDomainTags = new String[]{"acc", "src", "old_acc", "old_src"}) {
            JSONObject tagRootObj = upObj.getJSONObject(tag);
            JSONArray tagMainObj = tagRootObj.getJSONArray("main");
            for (int i = 0; i < tagMainObj.length(); ++i) {
                String upDomain = tagMainObj.getString(i);
                domainsList.add(upDomain);
                domainsMap.put(upDomain, 0L);
            }
            try {
                JSONArray tagBackupObj = tagRootObj.getJSONArray("backup");
                if (tagBackupObj == null) continue;
                for (int i = 0; i < tagBackupObj.length(); ++i) {
                    String upHost = tagBackupObj.getString(i);
                    domainsList.add(upHost);
                    domainsMap.put(upHost, 0L);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return new ZoneInfo(ttl, domainsList, domainsMap);
    }

    public void frozenDomain(String domain) {
        this.upDomainsMap.put(domain, System.currentTimeMillis() / 1000L + (long)DOMAIN_FROZEN_SECONDS);
    }

    public String toString() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("ttl", this.ttl);
        m.put("upDomainList", this.upDomainsList);
        m.put("upDomainMap", this.upDomainsMap);
        return new JSONObject(m).toString();
    }
}

