/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.collect.Config;
import com.qiniu.android.collect.UploadInfoCollector;
import com.qiniu.android.http.UserAgent;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.StringUtils;
import java.util.Locale;
import org.json.JSONObject;

public final class ResponseInfo {
    public static final int ZeroSizeFile = -6;
    public static final int InvalidToken = -5;
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public static final int UnknownError = 0;
    public static final int TimedOut = -1001;
    public static final int UnknownHost = -1003;
    public static final int CannotConnectToHost = -1004;
    public static final int NetworkConnectionLost = -1005;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final long duration;
    public final String host;
    public final String ip;
    public final int port;
    public final String path;
    public final String id;
    public final long timeStamp;
    public final long sent;
    public final UpToken upToken;
    public final JSONObject response;

    private ResponseInfo(JSONObject json, int statusCode, String reqId, String xlog, String xvia, String host, String path, String ip, int port, long duration, long sent, String error, UpToken upToken) {
        this.response = json;
        this.statusCode = statusCode;
        this.reqId = reqId;
        this.xlog = xlog;
        this.xvia = xvia;
        this.host = host;
        this.path = path;
        this.duration = duration;
        this.error = error;
        this.ip = ip;
        this.port = port;
        this.id = UserAgent.instance().id;
        this.timeStamp = System.currentTimeMillis() / 1000L;
        this.sent = sent;
        this.upToken = upToken;
    }

    public static ResponseInfo create(JSONObject json, final int statusCode, final String reqId, String xlog, String xvia, final String host, String path, final String ip, final int port, final long duration, final long sent, String error, UpToken upToken) {
        ResponseInfo res = new ResponseInfo(json, statusCode, reqId, xlog, xvia, host, path, ip, port, duration, sent, error, upToken);
        if (Config.isRecord) {
            final String _timeStamp = res.timeStamp + "";
            UploadInfoCollector.handleHttp(upToken, new UploadInfoCollector.RecordMsg(){

                @Override
                public String toRecordMsg() {
                    String remoteIp = (ip + "").split(":")[0].replace("/", "");
                    String[] ss = new String[]{statusCode + "", reqId, host, remoteIp, port + "", duration + "", _timeStamp, sent + ""};
                    return StringUtils.join(ss, ",");
                }
            });
        }
        return res;
    }

    public static ResponseInfo zeroSize(UpToken upToken) {
        return ResponseInfo.create(null, -6, "", "", "", "", "", "", 80, 0L, 0L, "file or data size is zero", upToken);
    }

    public static ResponseInfo cancelled(UpToken upToken) {
        return ResponseInfo.create(null, -2, "", "", "", "", "", "", 80, -1L, -1L, "cancelled by user", upToken);
    }

    public static ResponseInfo invalidArgument(String message, UpToken upToken) {
        return ResponseInfo.create(null, -4, "", "", "", "", "", "", 80, 0L, 0L, message, upToken);
    }

    public static ResponseInfo invalidToken(String message) {
        return ResponseInfo.create(null, -5, "", "", "", "", "", "", 80, 0L, 0L, message, null);
    }

    public static ResponseInfo fileError(Exception e, UpToken upToken) {
        return ResponseInfo.create(null, -3, "", "", "", "", "", "", 80, 0L, 0L, e.getMessage(), upToken);
    }

    public boolean isCancelled() {
        return this.statusCode == -2;
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && (this.hasReqId() || this.response != null);
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1 || this.statusCode == -1003 || this.statusCode == -1004 || this.statusCode == -1001 || this.statusCode == -1005;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean needSwitchServer() {
        return this.isNetworkBroken() || this.isServerError();
    }

    public boolean needRetry() {
        return !this.isCancelled() && (this.needSwitchServer() || this.statusCode == 406 || this.statusCode == 200 && this.error != null);
    }

    public boolean isNotQiniu() {
        return this.statusCode < 500 && this.statusCode >= 200 && !this.hasReqId() && this.response == null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ver:%s,ResponseInfo:%s,status:%d, reqId:%s, xlog:%s, xvia:%s, host:%s, path:%s, ip:%s, port:%d, duration:%d s, time:%d, sent:%d,error:%s}", "7.3.5", this.id, this.statusCode, this.reqId, this.xlog, this.xvia, this.host, this.path, this.ip, this.port, this.duration, this.timeStamp, this.sent, this.error);
    }

    public boolean hasReqId() {
        return this.reqId != null;
    }
}

