/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.collect.Config;
import com.qiniu.android.collect.UploadInfoCollector;
import com.qiniu.android.common.Zone;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.FormUploader;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.ResumeUploader;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.StringUtils;
import java.io.File;
import org.json.JSONObject;

public final class UploadManager {
    private final Configuration config;
    private final Client client;

    public UploadManager() {
        this(new Configuration.Builder().build());
    }

    public UploadManager(Configuration config) {
        this.config = config;
        this.client = new Client(config.proxy, config.connectTimeout, config.responseTimeout, config.urlConverter, config.dns);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGen) {
        this(new Configuration.Builder().recorder(recorder, keyGen).build());
    }

    public UploadManager(Recorder recorder) {
        this(recorder, null);
    }

    private static boolean areInvalidArg(String key, byte[] data, File f, String token, UpToken decodedToken, WarpHandler completionHandler) {
        if (completionHandler.complete == null) {
            throw new IllegalArgumentException("no UpCompletionHandler");
        }
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        ResponseInfo info = null;
        if (message != null) {
            info = ResponseInfo.invalidArgument(message, decodedToken);
        } else if (decodedToken == UpToken.NULL || decodedToken == null) {
            info = ResponseInfo.invalidToken("invalid token");
        } else if (f != null && f.length() == 0L || data != null && data.length == 0) {
            info = ResponseInfo.zeroSize(decodedToken);
        }
        if (info != null) {
            completionHandler.complete(key, info, null);
            return true;
        }
        return false;
    }

    public void put(final byte[] data, final String key, String token, UpCompletionHandler complete, final UploadOptions options) {
        final WarpHandler completionHandler = UploadManager.warpHandler(complete, data != null ? (long)data.length : 0L, UpType.form);
        final UpToken decodedToken = UpToken.parse(token);
        if (UploadManager.areInvalidArg(key, data, null, token, decodedToken, completionHandler)) {
            return;
        }
        Zone z = this.config.zone;
        z.preQuery(token, new Zone.QueryHandler(){

            @Override
            public void onSuccess() {
                FormUploader.upload(UploadManager.this.client, UploadManager.this.config, data, key, decodedToken, (UpCompletionHandler)completionHandler, options);
            }

            @Override
            public void onFailure(int reason) {
                ResponseInfo info = ResponseInfo.invalidToken("invalid token");
                completionHandler.complete(key, info, null);
            }
        });
    }

    public void put(String filePath, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        this.put(new File(filePath), key, token, completionHandler, options);
    }

    public void put(final File file, final String key, String token, UpCompletionHandler complete, final UploadOptions options) {
        final WarpHandler completionHandler = UploadManager.warpHandler(complete, file != null ? file.length() : 0L, UpType.form);
        final UpToken decodedToken = UpToken.parse(token);
        if (UploadManager.areInvalidArg(key, null, file, token, decodedToken, completionHandler)) {
            return;
        }
        Zone z = this.config.zone;
        z.preQuery(token, new Zone.QueryHandler(){

            @Override
            public void onSuccess() {
                long size = file.length();
                if (size <= (long)((UploadManager)UploadManager.this).config.putThreshold) {
                    completionHandler.type = UpType.form;
                    FormUploader.upload(UploadManager.this.client, UploadManager.this.config, file, key, decodedToken, (UpCompletionHandler)completionHandler, options);
                    return;
                }
                String recorderKey = ((UploadManager)UploadManager.this).config.keyGen.gen(key, file);
                completionHandler.type = UpType.block;
                ResumeUploader uploader = new ResumeUploader(UploadManager.this.client, UploadManager.this.config, file, key, decodedToken, completionHandler, options, recorderKey);
                AsyncRun.runInMain(uploader);
            }

            @Override
            public void onFailure(int reason) {
                ResponseInfo info = ResponseInfo.invalidToken("invalid token");
                completionHandler.complete(key, info, null);
            }
        });
    }

    public ResponseInfo syncPut(byte[] data, String key, String token, UploadOptions options) {
        UpToken decodedToken = UpToken.parse(token);
        ResponseInfo info = UploadManager.areInvalidArg(key, data, null, token, decodedToken);
        if (info != null) {
            return info;
        }
        return FormUploader.syncUpload(this.client, this.config, data, key, decodedToken, options);
    }

    public ResponseInfo syncPut(File file, String key, String token, UploadOptions options) {
        UpToken decodedToken = UpToken.parse(token);
        ResponseInfo info = UploadManager.areInvalidArg(key, null, file, token, decodedToken);
        if (info != null) {
            return info;
        }
        return FormUploader.syncUpload(this.client, this.config, file, key, decodedToken, options);
    }

    public ResponseInfo syncPut(String file, String key, String token, UploadOptions options) {
        return this.syncPut(new File(file), key, token, options);
    }

    private static ResponseInfo areInvalidArg(String key, byte[] data, File f, String token, UpToken decodedToken) {
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            return ResponseInfo.invalidArgument(message, decodedToken);
        }
        if (decodedToken == UpToken.NULL || decodedToken == null) {
            return ResponseInfo.invalidToken("invalid token");
        }
        if (f != null && f.length() == 0L || data != null && data.length == 0) {
            return ResponseInfo.zeroSize(decodedToken);
        }
        return null;
    }

    private static WarpHandler warpHandler(UpCompletionHandler complete, long size, UpType type) {
        return new WarpHandler(complete, size, type);
    }

    private static class WarpHandler
    implements UpCompletionHandler {
        final UpCompletionHandler complete;
        UpType type;
        final long before = System.currentTimeMillis();
        final long size;

        WarpHandler(UpCompletionHandler complete, long size, UpType type) {
            this.complete = complete;
            this.type = type;
            this.size = size;
        }

        @Override
        public void complete(final String key, final ResponseInfo res, final JSONObject response) {
            if (Config.isRecord) {
                final long after = System.currentTimeMillis();
                UploadInfoCollector.handleUpload(res.upToken, new UploadInfoCollector.RecordMsg(){

                    @Override
                    public String toRecordMsg() {
                        String remoteIp = (res.ip + "").split(":")[0].replace("/", "");
                        String[] ss = new String[]{res.statusCode + "", res.reqId, res.host, remoteIp, res.port + "", after - WarpHandler.this.before + "", res.timeStamp + "", WarpHandler.this.size + "", WarpHandler.this.type.toString()};
                        return StringUtils.join(ss, ",");
                    }
                });
            }
            AsyncRun.runInMain(new Runnable(){

                @Override
                public void run() {
                    try {
                        WarpHandler.this.complete.complete(key, res, response);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
    }

    private static enum UpType {
        form,
        block;

    }
}

