/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.dns.DnsManager;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.UrlSafeBase64;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class AutoZone
extends Zone {
    private Map<ZoneIndex, ZoneInfo> zones = new ConcurrentHashMap<ZoneIndex, ZoneInfo>();
    private Client client = new Client();
    private final String ucServer;
    public static final AutoZone autoZone = new AutoZone(null);

    public AutoZone(DnsManager dns) {
        this("https://uc.qbox.me", dns);
    }

    AutoZone(String ucServer, DnsManager dns) {
        this.ucServer = ucServer;
    }

    private void getZoneJsonAsync(ZoneIndex index, CompletionHandler handler) {
        String address = this.ucServer + "/v2/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        this.client.asyncGet(address, null, UpToken.NULL, handler);
    }

    private ResponseInfo getZoneJsonSync(ZoneIndex index) {
        String address = this.ucServer + "/v2/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        return this.client.syncGet(address, null);
    }

    ZoneInfo zoneInfo(String ak, String bucket) {
        ZoneIndex index = new ZoneIndex(ak, bucket);
        return this.zones.get(index);
    }

    ZoneInfo queryByToken(String token) {
        try {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
            JSONObject obj = new JSONObject(policy);
            String scope = obj.getString("scope");
            String bkt = scope.split(":")[0];
            return this.zoneInfo(ak, bkt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void preQueryIndex(final ZoneIndex index, final Zone.QueryHandler complete) {
        if (index == null) {
            complete.onFailure(-5);
            return;
        }
        ZoneInfo info = this.zones.get(index);
        if (info != null) {
            complete.onSuccess();
            return;
        }
        this.getZoneJsonAsync(index, new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (info.isOK() && response != null) {
                    try {
                        ZoneInfo info2 = ZoneInfo.buildFromJson(response);
                        AutoZone.this.zones.put(index, info2);
                        complete.onSuccess();
                        return;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        complete.onFailure(-1);
                        return;
                    }
                }
                complete.onFailure(info.statusCode);
            }
        });
    }

    boolean preQueryIndex(ZoneIndex index) {
        boolean success = false;
        if (index != null) {
            ZoneInfo info = this.zones.get(index);
            if (info != null) {
                success = true;
            } else {
                try {
                    ResponseInfo responseInfo = this.getZoneJsonSync(index);
                    ZoneInfo info2 = ZoneInfo.buildFromJson(responseInfo.response);
                    this.zones.put(index, info2);
                    success = true;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return success;
    }

    @Override
    public synchronized String upHost(String token, boolean useHttps, String frozenDomain) {
        ZoneInfo info = this.queryByToken(token);
        if (info != null) {
            return super.upHost(info, useHttps, frozenDomain);
        }
        return null;
    }

    @Override
    public void preQuery(String token, Zone.QueryHandler complete) {
        ZoneIndex index = ZoneIndex.getFromToken(token);
        this.preQueryIndex(index, complete);
    }

    @Override
    public boolean preQuery(String token) {
        ZoneIndex index = ZoneIndex.getFromToken(token);
        return this.preQueryIndex(index);
    }

    @Override
    public synchronized void frozenDomain(String upHostUrl) {
        if (upHostUrl != null) {
            URI uri = URI.create(upHostUrl);
            String frozenDomain = uri.getHost();
            ZoneInfo zoneInfo = null;
            for (Map.Entry<ZoneIndex, ZoneInfo> entry : this.zones.entrySet()) {
                ZoneInfo eachZoneInfo = entry.getValue();
                if (!eachZoneInfo.upDomainsList.contains(frozenDomain)) continue;
                zoneInfo = eachZoneInfo;
                break;
            }
            if (zoneInfo != null) {
                zoneInfo.frozenDomain(frozenDomain);
            }
        }
    }

    static class ZoneIndex {
        final String accessKey;
        final String bucket;

        ZoneIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        static ZoneIndex getFromToken(String token) {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = null;
            try {
                policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
                JSONObject obj = new JSONObject(policy);
                String scope = obj.getString("scope");
                String bkt = scope.split(":")[0];
                return new ZoneIndex(ak, bkt);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZoneIndex && ((ZoneIndex)obj).accessKey.equals(this.accessKey) && ((ZoneIndex)obj).bucket.equals(this.bucket);
        }
    }
}

