/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.collect.Config;
import com.qiniu.android.collect.UploadInfoCollector;
import com.qiniu.android.http.UserAgent;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.StringUtils;
import java.util.Locale;
import org.json.JSONObject;

public final class ResponseInfo {
    public static final int ZeroSizeFile = -6;
    public static final int InvalidToken = -5;
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public static final int UnknownError = 0;
    public static final int TimedOut = -1001;
    public static final int UnknownHost = -1003;
    public static final int CannotConnectToHost = -1004;
    public static final int NetworkConnectionLost = -1005;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final long duration;
    public final String host;
    public final String ip;
    public final int port;
    public final String path;
    public final String id;
    public final long timeStamp;
    public final long sent;
    public final UpToken upToken;
    public final long totalSize;
    public final JSONObject response;

    private ResponseInfo(JSONObject json, int statusCode, String reqId, String xlog, String xvia, String host, String path, String ip, int port, long duration, long sent, String error, UpToken upToken, long totalSize) {
        this.response = json;
        this.statusCode = statusCode;
        this.reqId = reqId;
        this.xlog = xlog;
        this.xvia = xvia;
        this.host = host;
        this.path = path;
        this.duration = duration;
        this.error = error;
        this.ip = ip;
        this.port = port;
        this.id = UserAgent.instance().id;
        this.timeStamp = System.currentTimeMillis() / 1000L;
        this.sent = sent;
        this.upToken = upToken;
        this.totalSize = totalSize;
    }

    public static ResponseInfo create(JSONObject json, final int statusCode, final String reqId, String xlog, String xvia, final String host, final String path, String oIp, final int port, final long duration, final long sent, String error, UpToken upToken, final long totalSize) {
        String _ip = (oIp + "").split(":")[0];
        final String ip = _ip.substring(Math.max(0, _ip.indexOf("/") + 1));
        ResponseInfo res = new ResponseInfo(json, statusCode, reqId, xlog, xvia, host, path, ip, port, duration, sent, error, upToken, totalSize);
        if (Config.isRecord || upToken != null) {
            final String _timeStamp = res.timeStamp + "";
            UploadInfoCollector.handleHttp(upToken, new UploadInfoCollector.RecordMsg(){

                @Override
                public String toRecordMsg() {
                    String[] ss = new String[]{statusCode + "", reqId, host, ip, port + "", duration + "", _timeStamp, sent + "", ResponseInfo.getUpType(path), totalSize + ""};
                    return StringUtils.join(ss, ",");
                }
            });
        }
        return res;
    }

    private static String getUpType(String path) {
        String m;
        if (path == null || !path.startsWith("/")) {
            return "";
        }
        if ("/".equals(path)) {
            return "form";
        }
        int l = path.indexOf(47, 1);
        if (l < 1) {
            return "";
        }
        switch (m = path.substring(1, l)) {
            case "mkblk": {
                return "mkblk";
            }
            case "bput": {
                return "bput";
            }
            case "mkfile": {
                return "mkfile";
            }
            case "put": {
                return "put";
            }
        }
        return "";
    }

    public static ResponseInfo zeroSize(UpToken upToken) {
        return ResponseInfo.create(null, -6, "", "", "", "", "", "", 80, 0L, 0L, "file or data size is zero", upToken, 0L);
    }

    public static ResponseInfo cancelled(UpToken upToken) {
        return ResponseInfo.create(null, -2, "", "", "", "", "", "", 80, -1L, -1L, "cancelled by user", upToken, 0L);
    }

    public static ResponseInfo invalidArgument(String message, UpToken upToken) {
        return ResponseInfo.create(null, -4, "", "", "", "", "", "", 80, 0L, 0L, message, upToken, 0L);
    }

    public static ResponseInfo invalidToken(String message) {
        return ResponseInfo.create(null, -5, "", "", "", "", "", "", 80, 0L, 0L, message, null, 0L);
    }

    public static ResponseInfo fileError(Exception e, UpToken upToken) {
        return ResponseInfo.create(null, -3, "", "", "", "", "", "", 80, 0L, 0L, e.getMessage(), upToken, 0L);
    }

    public static ResponseInfo networkError(int code, UpToken upToken) {
        return ResponseInfo.create(null, code, "", "", "", "", "", "", 80, 0L, 0L, "Network error during preQuery", upToken, 0L);
    }

    public static boolean isStatusCodeForBrokenNetwork(int code) {
        return code == -1 || code == -1003 || code == -1004 || code == -1001 || code == -1005;
    }

    public boolean isCancelled() {
        return this.statusCode == -2;
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && (this.hasReqId() || this.response != null);
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1 || this.statusCode == -1003 || this.statusCode == -1004 || this.statusCode == -1001 || this.statusCode == -1005;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean needSwitchServer() {
        return this.isNetworkBroken() || this.isServerError();
    }

    public boolean needRetry() {
        return !this.isCancelled() && (this.needSwitchServer() || this.statusCode == 406 || this.statusCode == 200 && this.error != null || this.isNotQiniu() && !this.upToken.hasReturnUrl());
    }

    public boolean isNotQiniu() {
        return this.statusCode < 500 && this.statusCode >= 200 && !this.hasReqId() && this.response == null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ver:%s,ResponseInfo:%s,status:%d, reqId:%s, xlog:%s, xvia:%s, host:%s, path:%s, ip:%s, port:%d, duration:%d s, time:%d, sent:%d,error:%s}", "7.3.9", this.id, this.statusCode, this.reqId, this.xlog, this.xvia, this.host, this.path, this.ip, this.port, this.duration, this.timeStamp, this.sent, this.error);
    }

    public boolean hasReqId() {
        return this.reqId != null;
    }
}

