/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import android.os.Process;
import com.qiniu.android.collect.LogHandler;
import com.qiniu.android.common.FixedZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.DnsPrefetcher;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.UrlSafeBase64;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class AutoZone
extends Zone {
    private String ucServer;
    private Map<ZoneIndex, ZoneInfo> zones = new ConcurrentHashMap<ZoneIndex, ZoneInfo>();
    private Client client = new Client();

    public AutoZone() {
        this(true);
    }

    public AutoZone(boolean useHttps) {
        this.ucServer = useHttps ? "https://uc.qbox.me" : "http://uc.qbox.me";
    }

    public void setUcServer(String ucServer) {
        this.ucServer = ucServer;
    }

    public String getUcServer() {
        return this.ucServer;
    }

    private void getZoneJsonAsync(LogHandler logHandler, ZoneIndex index, CompletionHandler handler) {
        String address = this.ucServer + "/v2/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        this.client.asyncGet(logHandler, address, null, UpToken.NULL, handler);
    }

    private ResponseInfo getZoneJsonSync(LogHandler logHandler, ZoneIndex index) {
        String address = this.ucServer + "/v2/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        return this.client.syncGet(logHandler, address, null);
    }

    ZoneInfo zoneInfo(String ak, String bucket) {
        ZoneIndex index = new ZoneIndex(ak, bucket);
        return this.zones.get(index);
    }

    ZoneInfo queryByToken(String token) {
        try {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
            JSONObject obj = new JSONObject(policy);
            String scope = obj.getString("scope");
            String bkt = scope.split(":")[0];
            return this.zoneInfo(ak, bkt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void preQueryIndex(LogHandler logHandler, final ZoneIndex index, final Zone.QueryHandler complete) {
        if (index == null) {
            complete.onFailure(-5);
            return;
        }
        ZoneInfo info = this.zones.get(index);
        if (info != null) {
            this.setTarget_region_id(info);
            complete.onSuccess();
            return;
        }
        logHandler.send("tid", Process.myTid());
        this.getZoneJsonAsync(logHandler, index, new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (info.isOK() && response != null) {
                    try {
                        ZoneInfo info2 = ZoneInfo.buildFromJson(response);
                        AutoZone.this.setTarget_region_id(info2);
                        AutoZone.this.zones.put(index, info2);
                        complete.onSuccess();
                        return;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        complete.onFailure(-1);
                        return;
                    }
                }
                complete.onFailure(info.statusCode);
            }
        });
    }

    private void setTarget_region_id(ZoneInfo info) {
        if (info == null) {
            return;
        }
        if (info.upDomainsList.size() > 0) {
            if (info.upDomainsList.contains(FixedZone.arrayzone0[0])) {
                DnsPrefetcher.target_region_id = "z0";
            } else if (info.upDomainsList.contains(FixedZone.arrayzone1[0])) {
                DnsPrefetcher.target_region_id = "z1";
            } else if (info.upDomainsList.contains(FixedZone.arrayzone2[0])) {
                DnsPrefetcher.target_region_id = "z2";
            } else if (info.upDomainsList.contains(FixedZone.arrayZoneAs0[0])) {
                DnsPrefetcher.target_region_id = "as0";
            } else if (info.upDomainsList.contains(FixedZone.arrayzoneNa0[0])) {
                DnsPrefetcher.target_region_id = "na";
            }
        }
    }

    boolean preQueryIndex(LogHandler logHandler, ZoneIndex index) {
        logHandler.send("tid", Process.myTid());
        boolean success = false;
        if (index != null) {
            ZoneInfo info = this.zones.get(index);
            if (info != null) {
                success = true;
            } else {
                try {
                    ResponseInfo responseInfo = this.getZoneJsonSync(logHandler, index);
                    if (responseInfo.response == null) {
                        return false;
                    }
                    ZoneInfo info2 = ZoneInfo.buildFromJson(responseInfo.response);
                    this.zones.put(index, info2);
                    success = true;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return success;
    }

    @Override
    public synchronized String upHost(String token, boolean useHttps, String frozenDomain) {
        ZoneInfo info = this.queryByToken(token);
        if (info != null) {
            return super.upHost(info, useHttps, frozenDomain);
        }
        return null;
    }

    @Override
    public void preQuery(LogHandler logHandler, String token, Zone.QueryHandler complete) {
        ZoneIndex index = ZoneIndex.getFromToken(token);
        this.preQueryIndex(logHandler, index, complete);
    }

    @Override
    public boolean preQuery(LogHandler logHandler, String token) {
        ZoneIndex index = ZoneIndex.getFromToken(token);
        return this.preQueryIndex(logHandler, index);
    }

    @Override
    public synchronized void frozenDomain(String upHostUrl) {
        if (upHostUrl != null) {
            URI uri = URI.create(upHostUrl);
            String frozenDomain = uri.getHost();
            ZoneInfo zoneInfo = null;
            for (Map.Entry<ZoneIndex, ZoneInfo> entry : this.zones.entrySet()) {
                ZoneInfo eachZoneInfo = entry.getValue();
                if (!eachZoneInfo.upDomainsList.contains(frozenDomain)) continue;
                zoneInfo = eachZoneInfo;
                break;
            }
            if (zoneInfo != null) {
                zoneInfo.frozenDomain(frozenDomain);
            }
        }
    }

    static class ZoneIndex {
        final String accessKey;
        final String bucket;

        ZoneIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        static ZoneIndex getFromToken(String token) {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = null;
            try {
                policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
                JSONObject obj = new JSONObject(policy);
                String scope = obj.getString("scope");
                String bkt = scope.split(":")[0];
                return new ZoneIndex(ak, bkt);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZoneIndex && ((ZoneIndex)obj).accessKey.equals(this.accessKey) && ((ZoneIndex)obj).bucket.equals(this.bucket);
        }
    }
}

