/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Process;
import com.qiniu.android.collect.Config;
import com.qiniu.android.collect.LogHandler;
import com.qiniu.android.collect.UploadInfoCollector;
import com.qiniu.android.collect.UploadInfoElement;
import com.qiniu.android.collect.UploadInfoElementCollector;
import com.qiniu.android.http.DnsPrefetcher;
import com.qiniu.android.http.UserAgent;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.Json;
import com.qiniu.android.utils.StringUtils;
import java.net.InetAddress;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public final class ResponseInfo {
    public static final int ZeroSizeFile = -6;
    public static final int InvalidToken = -5;
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public static final int Crc32NotMatch = -406;
    public static final int UnknownError = 0;
    public static final int TimedOut = -1001;
    public static final int UnknownHost = -1003;
    public static final int CannotConnectToHost = -1004;
    public static final int NetworkConnectionLost = -1005;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final long duration;
    public final String host;
    public final String ip;
    public final int port;
    public final String path;
    public final String id;
    public final long timeStamp;
    public final long sent;
    public String xClientId;
    public final UpToken upToken;
    public final long totalSize;
    public static long bytes_sent;
    public static long requests_count;
    public final JSONObject response;

    private ResponseInfo(JSONObject json, int statusCode, String xClientId, String reqId, String xlog, String xvia, String host, String path, String ip, int port, long duration, long sent, String error, UpToken upToken, long totalSize) {
        this.response = json;
        this.statusCode = statusCode;
        this.xClientId = xClientId;
        this.reqId = reqId;
        this.xlog = xlog;
        this.xvia = xvia;
        this.host = host;
        this.path = path;
        this.duration = duration;
        this.error = error;
        this.ip = ip;
        this.port = port;
        this.id = UserAgent.instance().id;
        this.timeStamp = System.currentTimeMillis() / 1000L;
        this.sent = sent;
        this.upToken = upToken;
        this.totalSize = totalSize;
    }

    public static ResponseInfo create(final LogHandler logHandler, JSONObject json, final int statusCode, final String reqId, String xlog, String xvia, final String host, String path, String oIp, final int port, long duration, final long sent, final String error, final UpToken upToken, long totalSize) {
        bytes_sent += sent;
        ++requests_count;
        String _ip = (oIp + "").split(":")[0];
        final String ip = _ip.substring(Math.max(0, _ip.indexOf("/") + 1));
        String xClientId = UploadInfoElement.x_log_client_id;
        ResponseInfo res = new ResponseInfo(json, statusCode, xClientId, reqId, xlog, xvia, host, path, ip, port, duration, sent, error, upToken, totalSize);
        if (Config.isRecord) {
            String _timeStamp = res.timeStamp + "";
            UploadInfoCollector.handleHttp(upToken, new UploadInfoCollector.RecordMsg(){

                @Override
                public String toRecordMsg() {
                    logHandler.send("pid", Process.myPid());
                    if (logHandler == null) {
                        return "";
                    }
                    logHandler.send("status_code", statusCode);
                    logHandler.send("req_id", reqId);
                    logHandler.send("host", host);
                    logHandler.send("remote_ip", ip);
                    logHandler.send("port", port);
                    if (upToken.token != "" && upToken.token != null) {
                        logHandler.send("target_bucket", StringUtils.getBucket(upToken.token));
                    }
                    logHandler.send("bytes_sent", sent);
                    List<InetAddress> resolveResults = DnsPrefetcher.getDnsPrefetcher().getInetAddressByHost(host);
                    if (resolveResults != null) {
                        logHandler.send("prefetched_ip_count", resolveResults.size());
                    }
                    if (error != null) {
                        logHandler.send("error_type", UploadInfoElement.errorType(statusCode, error));
                        logHandler.send("error_description", error);
                    }
                    UploadInfoElement.ReqInfo reqInfoQuery = (UploadInfoElement.ReqInfo)logHandler.getUploadInfo();
                    UploadInfoElementCollector.setReqCommonElements(reqInfoQuery);
                    String req = Json.object2Json(reqInfoQuery);
                    return req;
                }
            });
        }
        return res;
    }

    private static String getUpType(String path) {
        String m;
        if (path == null || !path.startsWith("/")) {
            return "";
        }
        if ("/".equals(path)) {
            return "form";
        }
        int l = path.indexOf(47, 1);
        if (l < 1) {
            return "";
        }
        switch (m = path.substring(1, l)) {
            case "mkblk": {
                return "mkblk";
            }
            case "bput": {
                return "bput";
            }
            case "mkfile": {
                return "mkfile";
            }
            case "put": {
                return "put";
            }
        }
        return "";
    }

    public static ResponseInfo errorInfo(ResponseInfo old, int statusCode, String error) {
        ResponseInfo _new = new ResponseInfo(old.response, statusCode, UploadInfoElement.x_log_client_id, old.reqId, old.xlog, old.xvia, old.host, old.path, old.ip, old.port, old.duration, old.sent, error, old.upToken, old.totalSize);
        return _new;
    }

    public static ResponseInfo zeroSize(UpToken upToken) {
        return ResponseInfo.create(null, null, -6, "", "", "", "", "", "", 80, 0L, 0L, "file or data size is zero", upToken, 0L);
    }

    public static ResponseInfo cancelled(UpToken upToken) {
        return ResponseInfo.create(null, null, -2, "", "", "", "", "", "", 80, -1L, -1L, "cancelled by user", upToken, 0L);
    }

    public static ResponseInfo invalidArgument(String message, UpToken upToken) {
        return ResponseInfo.create(null, null, -4, "", "", "", "", "", "", 80, 0L, 0L, message, upToken, 0L);
    }

    public static ResponseInfo invalidToken(String message) {
        return ResponseInfo.create(null, null, -5, "", "", "", "", "", "", 80, 0L, 0L, message, null, 0L);
    }

    public static ResponseInfo fileError(Exception e, UpToken upToken) {
        return ResponseInfo.create(null, null, -3, "", "", "", "", "", "", 80, 0L, 0L, e.getMessage(), upToken, 0L);
    }

    public static ResponseInfo networkError(int code, UpToken upToken) {
        return ResponseInfo.create(null, null, code, "", "", "", "", "", "", 80, 0L, 0L, "Network error during preQuery, Please check your network or use http try again", upToken, 0L);
    }

    public static boolean isStatusCodeForBrokenNetwork(int code) {
        return code == -1 || code == -1003 || code == -1004 || code == -1001 || code == -1005;
    }

    public boolean isCancelled() {
        return this.statusCode == -2;
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && (this.hasReqId() || this.response != null);
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1 || this.statusCode == -1003 || this.statusCode == -1004 || this.statusCode == -1001 || this.statusCode == -1005;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean needSwitchServer() {
        return this.isNetworkBroken() || this.isServerError();
    }

    public boolean needRetry() {
        return !this.isCancelled() && (this.needSwitchServer() || this.statusCode == 406 || this.statusCode == 200 && this.error != null || this.isNotQiniu() && !this.upToken.hasReturnUrl());
    }

    public boolean isNotQiniu() {
        return this.statusCode < 500 && this.statusCode >= 200 && !this.hasReqId() && this.response == null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ver:%s,ResponseInfo:%s,status:%d, xClientId:%s, reqId:%s, xlog:%s, xvia:%s, host:%s, path:%s, ip:%s, port:%d, duration:%d s, time:%d, sent:%d,error:%s}", "7.4.4", this.id, this.statusCode, this.xClientId, this.reqId, this.xlog, this.xvia, this.host, this.path, this.ip, this.port, this.duration, this.timeStamp, this.sent, this.error);
    }

    public boolean hasReqId() {
        return this.reqId != null;
    }
}

