/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.os.Process;
import com.qiniu.android.collect.LogHandler;
import com.qiniu.android.collect.UploadInfo;
import com.qiniu.android.collect.UploadInfoCollector;
import com.qiniu.android.collect.UploadInfoElement;
import com.qiniu.android.collect.UploadInfoElementCollector;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.DnsPrefetcher;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpCancellationSignal;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.Crc32;
import com.qiniu.android.utils.Json;
import com.qiniu.android.utils.StringMap;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.UrlSafeBase64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResumeUploaderFast
implements Runnable {
    private final long totalSize;
    private final String key;
    private final UpCompletionHandler completionHandler;
    private final UploadOptions options;
    private final Client client;
    private final Configuration config;
    private final String[] contexts;
    private final StringMap headers;
    private final long modifyTime;
    private final String recorderKey;
    private RandomAccessFile file;
    private File f;
    private UpToken token;
    private Map<Long, Integer> blockInfo;
    AtomicReference upHost = new AtomicReference();
    AtomicInteger tblock;
    AtomicInteger retried = new AtomicInteger(0);
    AtomicInteger singleDomainRetry = new AtomicInteger(0);
    private int multithread;
    private boolean isFirstTask = true;
    private Long[] offsets;
    private int upBlock = 0;
    private final int domainRetry = 3;
    private boolean isInterrupted = false;
    private long recover_from;

    ResumeUploaderFast(Client client, Configuration config, File f, String key, UpToken token, final UpCompletionHandler completionHandler, UploadOptions options, String recorderKey, int multithread) {
        this.client = client;
        this.config = config;
        this.f = f;
        this.recorderKey = recorderKey;
        this.totalSize = f.length();
        this.key = key;
        this.headers = new StringMap().put("Authorization", "UpToken " + token.token);
        this.file = null;
        this.multithread = multithread;
        this.completionHandler = new UpCompletionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(String key, ResponseInfo info, JSONObject response) {
                if (ResumeUploaderFast.this.file != null) {
                    try {
                        ResumeUploaderFast.this.file.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                1 var4_5 = this;
                synchronized (var4_5) {
                    if (ResumeUploaderFast.this.isInterrupted) {
                        return;
                    }
                    ResumeUploaderFast.this.isInterrupted = true;
                    completionHandler.complete(key, info, response);
                }
            }
        };
        this.options = options != null ? options : UploadOptions.defaultOptions();
        this.tblock = new AtomicInteger((int)(this.totalSize + 0x400000L - 1L) / 0x400000);
        this.offsets = new Long[this.tblock.get()];
        this.contexts = new String[this.tblock.get()];
        this.modifyTime = f.lastModified();
        this.token = token;
        this.blockInfo = new LinkedHashMap<Long, Integer>();
    }

    @Override
    public void run() {
        try {
            this.file = new RandomAccessFile(this.f, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e, this.token), null);
            return;
        }
        this.putBlockInfo();
        this.upHost.set(this.config.zone.upHost(this.token.token, this.config.useHttps, null));
        if (this.blockInfo.size() < this.multithread) {
            this.multithread = this.blockInfo.size();
        }
        for (int i = 0; i < this.multithread; ++i) {
            BlockElement mblock = this.getBlockInfo();
            new UploadThread(mblock.getOffset(), mblock.getBlocksize(), this.upHost.get().toString()).start();
        }
    }

    private void putBlockInfo() {
        Long[] offs = this.recoveryFromRecord();
        int lastBlock = this.tblock.get() - 1;
        if (offs == null) {
            this.recover_from = 0L;
            for (int i = 0; i < lastBlock; ++i) {
                this.blockInfo.put((long)i * 0x400000L, 0x400000);
            }
            this.blockInfo.put((long)lastBlock * 0x400000L, (int)(this.totalSize - (long)(lastBlock * 0x400000)));
        } else {
            this.recover_from = offs.length * 0x400000;
            HashSet<Long> set = new HashSet<Long>(Arrays.asList(offs));
            for (int i = 0; i < lastBlock; ++i) {
                Long offset = (long)i * 0x400000L;
                if (!set.contains(offset)) {
                    this.blockInfo.put(offset, 0x400000);
                    continue;
                }
                this.offsets[i] = offset;
                ++this.upBlock;
            }
            Long offset = (long)lastBlock * 0x400000L;
            if (!set.contains(offset)) {
                this.blockInfo.put(offset, (int)(this.totalSize - (long)(lastBlock * 0x400000)));
            } else {
                this.offsets[lastBlock] = offset;
                ++this.upBlock;
            }
        }
    }

    private synchronized BlockElement getBlockInfo() {
        Iterator<Map.Entry<Long, Integer>> it = this.blockInfo.entrySet().iterator();
        long offset = 0L;
        int blockSize = 0;
        if (it.hasNext()) {
            Map.Entry<Long, Integer> entry = it.next();
            offset = entry.getKey();
            blockSize = entry.getValue();
            this.blockInfo.remove(offset);
        }
        return new BlockElement(offset, blockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mkblk(long offset, int blockSize, String upHost) {
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("target_key", this.key);
        logHandler.send("up_type", "mkblk");
        logHandler.send("tid", Process.myTid());
        logHandler.send("file_offset", offset);
        logHandler.send("bytes_total", blockSize);
        String path = String.format(Locale.ENGLISH, "/mkblk/%d", blockSize);
        byte[] chunkBuffer = new byte[blockSize];
        ResumeUploaderFast resumeUploaderFast = this;
        synchronized (resumeUploaderFast) {
            try {
                this.file.seek(offset);
                this.file.read(chunkBuffer, 0, blockSize);
            }
            catch (IOException e) {
                this.completionHandler.complete(this.key, ResponseInfo.fileError(e, this.token), null);
                return;
            }
        }
        long crc32 = Crc32.bytes(chunkBuffer, 0, blockSize);
        String postUrl = String.format("%s%s", upHost, path);
        this.post(logHandler, postUrl, chunkBuffer, 0, blockSize, this.getProgressHandler(), this.getCompletionHandler(offset, blockSize, crc32), this.options.cancellationSignal);
    }

    private void makeFile(String upHost, CompletionHandler _completionHandler, UpCancellationSignal c) {
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("target_key", this.key);
        logHandler.send("up_type", "mkfile");
        logHandler.send("tid", Process.myTid());
        String mime = String.format(Locale.ENGLISH, "/mimeType/%s/fname/%s", UrlSafeBase64.encodeToString(this.options.mimeType), UrlSafeBase64.encodeToString(this.f.getName()));
        String keyStr = "";
        if (this.key != null) {
            keyStr = String.format("/key/%s", UrlSafeBase64.encodeToString(this.key));
        }
        String paramStr = "";
        if (this.options.params.size() != 0) {
            String[] str = new String[this.options.params.size()];
            int j = 0;
            for (Map.Entry<String, String> i : this.options.params.entrySet()) {
                str[j++] = String.format(Locale.ENGLISH, "%s/%s", i.getKey(), UrlSafeBase64.encodeToString(i.getValue()));
            }
            paramStr = "/" + StringUtils.join(str, "/");
        }
        String path = String.format(Locale.ENGLISH, "/mkfile/%d%s%s%s", this.totalSize, mime, keyStr, paramStr);
        String bodyStr = StringUtils.join(this.contexts, ",");
        byte[] data = bodyStr.getBytes();
        String postUrl = String.format("%s%s", upHost, path);
        logHandler.send("bytes_total", data.length);
        this.post(logHandler, postUrl, data, 0, data.length, null, _completionHandler, c);
    }

    private void post(LogHandler logHandler, String upHost, byte[] data, int offset, int dataSize, ProgressHandler progress, CompletionHandler completion, UpCancellationSignal c) {
        this.client.asyncPost(logHandler, upHost, data, offset, dataSize, this.headers, this.token, this.totalSize, progress, completion, c);
    }

    private ProgressHandler getProgressHandler() {
        return new ProgressHandler(){

            @Override
            public void onProgress(long bytesWritten, long totalSize) {
                long size = 0L;
                for (Long offset : ResumeUploaderFast.this.offsets) {
                    if (offset == null || offset <= 0L) continue;
                    ++size;
                }
                double percent = (double)size * 4194304.0 / (double)totalSize;
                if (percent > 0.95) {
                    percent = 0.95;
                }
                ((ResumeUploaderFast)ResumeUploaderFast.this).options.progressHandler.progress(ResumeUploaderFast.this.key, percent);
            }
        };
    }

    private CompletionHandler getMkfileCompletionHandler() {
        return new CompletionHandler(){

            @Override
            public void complete(ResponseInfo info, JSONObject response) {
                if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                    ((ResumeUploaderFast)ResumeUploaderFast.this).options.netReadyHandler.waitReady();
                    if (!AndroidNetwork.isNetWorkReady()) {
                        ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info, response);
                        return;
                    }
                }
                if (info.isOK()) {
                    ResumeUploaderFast.this.removeRecord();
                    ((ResumeUploaderFast)ResumeUploaderFast.this).options.progressHandler.progress(ResumeUploaderFast.this.key, 1.0);
                    ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info, response);
                    return;
                }
                if (info.needRetry() && ResumeUploaderFast.this.retried.get() < ((ResumeUploaderFast)ResumeUploaderFast.this).config.retryMax + 1) {
                    ResumeUploaderFast.this.makeFile(ResumeUploaderFast.this.upHost.get().toString(), ResumeUploaderFast.this.getMkfileCompletionHandler(), ((ResumeUploaderFast)ResumeUploaderFast.this).options.cancellationSignal);
                    ResumeUploaderFast.this.retried.addAndGet(1);
                    return;
                }
                ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info, response);
            }
        };
    }

    private CompletionHandler getCompletionHandler(final long offset, final int blockSize, final long crc32) {
        return new CompletionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(final ResponseInfo info, JSONObject response) {
                BlockElement mblock;
                final long tid = Process.myTid();
                UploadInfoCollector.handleHttp(ResumeUploaderFast.this.token, new UploadInfoCollector.RecordMsg(){

                    @Override
                    public String toRecordMsg() {
                        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getBlockInfo());
                        UpToken.setCurrent_region_id(logHandler, ResumeUploaderFast.this.upHost.get().toString());
                        logHandler.send("target_region_id", DnsPrefetcher.target_region_id);
                        logHandler.send("total_elapsed_time", info.duration);
                        logHandler.send("bytes_sent", info.sent);
                        logHandler.send("recovered_from", ResumeUploaderFast.this.recover_from);
                        logHandler.send("file_size", ResumeUploaderFast.this.totalSize);
                        logHandler.send("pid", Process.myPid());
                        logHandler.send("tid", tid);
                        logHandler.send("up_api_version", 1);
                        logHandler.send("up_time", System.currentTimeMillis() / 1000L);
                        UploadInfoElement.BlockInfo blockInfo = (UploadInfoElement.BlockInfo)logHandler.getUploadInfo();
                        String upBlock = Json.object2Json(blockInfo);
                        return upBlock;
                    }
                });
                if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                    ((ResumeUploaderFast)ResumeUploaderFast.this).options.netReadyHandler.waitReady();
                    if (!AndroidNetwork.isNetWorkReady()) {
                        ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info, response);
                        return;
                    }
                }
                if (info.isCancelled()) {
                    ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info, response);
                    return;
                }
                if (!ResumeUploaderFast.this.isChunkOK(info, response)) {
                    if (info.statusCode == 701 && ResumeUploaderFast.this.checkRetried()) {
                        ResumeUploaderFast.this.updateRetried();
                        ResumeUploaderFast.this.mkblk(offset, blockSize, ResumeUploaderFast.this.upHost.get().toString());
                        return;
                    }
                    if (ResumeUploaderFast.this.upHost != null && (ResumeUploaderFast.this.isNotChunkToQiniu(info, response) || info.needRetry()) && ResumeUploaderFast.this.checkRetried()) {
                        ResumeUploaderFast.this.updateRetried();
                        ResumeUploaderFast.this.mkblk(offset, blockSize, ResumeUploaderFast.this.upHost.get().toString());
                        return;
                    }
                    ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info, response);
                    return;
                }
                String context = null;
                if (response == null && ResumeUploaderFast.this.checkRetried()) {
                    ResumeUploaderFast.this.updateRetried();
                    ResumeUploaderFast.this.mkblk(offset, blockSize, ResumeUploaderFast.this.upHost.get().toString());
                    return;
                }
                long crc = 0L;
                Exception tempE = null;
                try {
                    context = response.getString("ctx");
                    crc = response.getLong("crc32");
                }
                catch (Exception e) {
                    tempE = e;
                    e.printStackTrace();
                }
                if ((context == null || crc != crc32) && ResumeUploaderFast.this.checkRetried()) {
                    ResumeUploaderFast.this.updateRetried();
                    ResumeUploaderFast.this.mkblk(offset, blockSize, ResumeUploaderFast.this.upHost.get().toString());
                    return;
                }
                if (context == null) {
                    String error = "get context failed.";
                    if (tempE != null) {
                        error = error + "\n";
                        error = error + tempE.getMessage();
                    }
                    ResponseInfo info2 = ResponseInfo.errorInfo(info, 0, error);
                    ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info2, response);
                    return;
                }
                if (crc != crc32) {
                    String error = "block's crc32 is not match. local: " + crc32 + ", remote: " + crc;
                    ResponseInfo info2 = ResponseInfo.errorInfo(info, -406, error);
                    ResumeUploaderFast.this.completionHandler.complete(ResumeUploaderFast.this.key, info2, response);
                    return;
                }
                4 error = this;
                synchronized (error) {
                    ((ResumeUploaderFast)ResumeUploaderFast.this).contexts[(int)(offset / 0x400000L)] = context;
                    ((ResumeUploaderFast)ResumeUploaderFast.this).offsets[(int)(offset / 0x400000L)] = offset;
                    ResumeUploaderFast.this.record(ResumeUploaderFast.this.offsets);
                    ResumeUploaderFast.this.upBlock += 1;
                    if (ResumeUploaderFast.this.upBlock == ResumeUploaderFast.this.tblock.get()) {
                        ResumeUploaderFast.this.makeFile(ResumeUploaderFast.this.upHost.get().toString(), ResumeUploaderFast.this.getMkfileCompletionHandler(), ((ResumeUploaderFast)ResumeUploaderFast.this).options.cancellationSignal);
                        return;
                    }
                }
                if (ResumeUploaderFast.this.blockInfo.size() > 0 && (mblock = ResumeUploaderFast.this.getBlockInfo()).getOffset() != 0L && mblock.getBlocksize() != 0) {
                    new UploadThread(mblock.getOffset(), mblock.getBlocksize(), ResumeUploaderFast.this.upHost.get().toString()).start();
                }
            }
        };
    }

    private synchronized void updateRetried() {
        if (this.singleDomainRetry.get() < this.config.retryMax) {
            this.singleDomainRetry.getAndAdd(1);
        } else if (this.retried.get() < 3) {
            this.singleDomainRetry.getAndSet(1);
            this.retried.getAndAdd(1);
            this.upHost.getAndSet(this.config.zone.upHost(this.token.token, this.config.useHttps, this.upHost.get().toString()));
        }
    }

    private boolean checkRetried() {
        return this.retried.get() < 3;
    }

    private boolean isChunkOK(ResponseInfo info, JSONObject response) {
        return info.statusCode == 200 && info.error == null && (info.hasReqId() || this.isChunkResOK(response));
    }

    private boolean isChunkResOK(JSONObject response) {
        try {
            response.getString("ctx");
            response.getLong("crc32");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean isNotChunkToQiniu(ResponseInfo info, JSONObject response) {
        return info.statusCode < 500 && info.statusCode >= 200 && !info.hasReqId() && !this.isChunkResOK(response);
    }

    private Long[] recoveryFromRecord() {
        int i;
        JSONObject obj;
        if (this.config.recorder == null) {
            return null;
        }
        byte[] data = this.config.recorder.get(this.recorderKey);
        if (data == null) {
            return null;
        }
        String jsonStr = new String(data);
        try {
            obj = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        JSONArray offsetsArray = obj.optJSONArray("offsets");
        long modify = obj.optLong("modify_time", 0L);
        long fSize = obj.optLong("size", 0L);
        JSONArray array = obj.optJSONArray("contexts");
        if (offsetsArray.length() == 0 || modify != this.modifyTime || fSize != this.totalSize || array == null || array.length() == 0) {
            return null;
        }
        for (i = 0; i < array.length(); ++i) {
            this.contexts[i] = array.optString(i);
        }
        for (i = 0; i < array.length(); ++i) {
            String offset = offsetsArray.optString(i);
            if (offset == null || offset.equals("null")) continue;
            this.offsets[i] = Long.parseLong(offset);
        }
        return this.offsets;
    }

    private void removeRecord() {
        if (this.config.recorder != null) {
            this.config.recorder.del(this.recorderKey);
        }
    }

    private void record(Long[] offsets) {
        if (this.config.recorder == null || offsets.length == 0) {
            return;
        }
        String data = String.format(Locale.ENGLISH, "{\"size\":%d,\"offsets\":[%s], \"modify_time\":%d, \"contexts\":[%s]}", this.totalSize, StringUtils.jsonJoin(offsets), this.modifyTime, StringUtils.jsonJoin(this.contexts));
        this.config.recorder.set(this.recorderKey, data.getBytes());
    }

    class BlockElement {
        private long offset;
        private int blocksize;

        BlockElement(long offset, int blocksize) {
            this.offset = offset;
            this.blocksize = blocksize;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getBlocksize() {
            return this.blocksize;
        }
    }

    class UploadThread
    extends Thread {
        private long offset;
        private int blockSize;
        private String upHost;

        UploadThread(long offset, int blockSize, String upHost) {
            this.offset = offset;
            this.blockSize = blockSize;
            this.upHost = upHost;
        }

        @Override
        public void run() {
            super.run();
            ResumeUploaderFast.this.mkblk(this.offset, this.blockSize, this.upHost);
        }
    }
}

