/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage.persistent;

import com.qiniu.android.http.custom.DnsCacheKey;
import com.qiniu.android.storage.Recorder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class DnsCacheFile
implements Recorder {
    public String directory;
    public File f;

    public DnsCacheFile(String directory) throws IOException {
        this.directory = directory;
        this.f = new File(directory);
        if (!this.f.exists()) {
            boolean r = this.f.mkdirs();
            if (!r) {
                throw new IOException("mkdir failed");
            }
            return;
        }
        if (!this.f.isDirectory()) {
            throw new IOException("does not mkdir");
        }
    }

    @Override
    public void set(String key, byte[] data) {
        File[] fs = this.f.listFiles();
        if (fs == null) {
            return;
        }
        if (fs.length > 0) {
            for (int i = 0; i < fs.length; ++i) {
                this.del(fs[i].getName());
            }
        }
        File f = new File(this.directory, key);
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(f);
            fo.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fo != null) {
            try {
                fo.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public byte[] get(String key) {
        File f = new File(this.directory, key);
        FileInputStream fi = null;
        byte[] data = null;
        int read = 0;
        try {
            data = new byte[(int)f.length()];
            fi = new FileInputStream(f);
            read = fi.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fi != null) {
            try {
                fi.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (read == 0) {
            return null;
        }
        return data;
    }

    @Override
    public String getFileName() {
        File[] fs = this.f.listFiles();
        if (fs == null) {
            return null;
        }
        if (fs.length == 1) {
            return fs[0].getName();
        }
        if (fs.length > 1) {
            String fileName = null;
            long cachetime = 0L;
            for (int i = 1; i < fs.length; ++i) {
                String key = fs[i].getName();
                DnsCacheKey cacheKey = DnsCacheKey.toCacheKey(key);
                if (cacheKey == null) {
                    return null;
                }
                long time = Long.parseLong(cacheKey.getCurrentTime());
                if (time <= cachetime) continue;
                this.del(fileName);
                cachetime = time;
                fileName = key;
            }
            return fileName;
        }
        return null;
    }

    @Override
    public void del(String key) {
        if (key != null) {
            File f = new File(this.directory, key);
            f.delete();
        }
    }
}

