/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.collect.Config;
import com.qiniu.android.collect.LogHandler;
import com.qiniu.android.collect.UploadInfo;
import com.qiniu.android.collect.UploadInfoElementCollector;
import com.qiniu.android.common.FixedZone;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.Dns;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.custom.DnsCacheKey;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.persistent.DnsCacheFile;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.UrlSafeBase64;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class DnsPrefetcher {
    public static DnsPrefetcher dnsPrefetcher = null;
    private static String token;
    private static Configuration config;
    private static ConcurrentHashMap<String, List<InetAddress>> mConcurrentHashMap;
    private static AtomicReference mDnsCacheKey;
    public static String target_region_id;

    private DnsPrefetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DnsPrefetcher getDnsPrefetcher() {
        if (dnsPrefetcher != null) return dnsPrefetcher;
        Class<DnsPrefetcher> clazz = DnsPrefetcher.class;
        synchronized (DnsPrefetcher.class) {
            if (dnsPrefetcher != null) return dnsPrefetcher;
            dnsPrefetcher = new DnsPrefetcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dnsPrefetcher;
        }
    }

    public void localFetch() {
        ArrayList<String> localHosts = new ArrayList<String>();
        List<ZoneInfo> listZoneinfo = this.getLocalZone();
        for (ZoneInfo zone : listZoneinfo) {
            for (String host : zone.upDomainsList) {
                localHosts.add(host);
            }
        }
        localHosts.add(Config.preQueryHost);
        if (localHosts != null && localHosts.size() > 0) {
            this.preFetch(localHosts);
        }
    }

    public DnsPrefetcher init(String token, Configuration config) throws UnknownHostException {
        DnsPrefetcher.token = token;
        DnsPrefetcher.config = config;
        List<String> preHosts = this.preHosts();
        if (preHosts != null && preHosts.size() > 0) {
            this.preFetch(preHosts);
        }
        return this;
    }

    public void setConcurrentHashMap(ConcurrentHashMap<String, List<InetAddress>> mConcurrentHashMap) {
        DnsPrefetcher.mConcurrentHashMap = mConcurrentHashMap;
    }

    public ConcurrentHashMap<String, List<InetAddress>> getConcurrentHashMap() {
        return mConcurrentHashMap;
    }

    public void setToken(String token) {
        DnsPrefetcher.token = token;
    }

    public List<InetAddress> getInetAddressByHost(String host) {
        return mConcurrentHashMap.get(host);
    }

    private List<String> preHosts() {
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> preHosts = new ArrayList<String>();
        ZoneInfo zoneInfo = this.getPreQueryZone();
        if (zoneInfo != null) {
            for (String host : zoneInfo.upDomainsList) {
                if (!set.add(host)) continue;
                preHosts.add(host);
            }
        }
        List<ZoneInfo> listZoneinfo = this.getLocalZone();
        for (ZoneInfo zone : listZoneinfo) {
            for (String host : zone.upDomainsList) {
                if (!set.add(host)) continue;
                preHosts.add(host);
            }
        }
        if (set.add(Config.preQueryHost)) {
            preHosts.add(Config.preQueryHost);
        }
        return preHosts;
    }

    private void preFetch(List<String> fetchHost) {
        ArrayList<String> rePreHosts = new ArrayList<String>();
        for (String host : fetchHost) {
            List inetAddresses = null;
            try {
                inetAddresses = okhttp3.Dns.SYSTEM.lookup(host);
                mConcurrentHashMap.put(host, inetAddresses);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                rePreHosts.add(host);
            }
        }
        if (rePreHosts.size() > 0) {
            this.rePreFetch(rePreHosts, null);
        }
    }

    private void rePreFetch(List<String> rePreHosts, Dns customeDns) {
        block0: for (String host : rePreHosts) {
            for (int rePreNum = 0; rePreNum < Config.rePreHost; ++rePreNum) {
                if (!this.rePreFetch(host, customeDns)) continue;
                continue block0;
            }
        }
    }

    private boolean rePreFetch(String host, Dns customeDns) {
        List<InetAddress> inetAddresses = null;
        try {
            inetAddresses = customeDns == null ? okhttp3.Dns.SYSTEM.lookup(host) : customeDns.lookup(host);
            mConcurrentHashMap.put(host, inetAddresses);
            return true;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dnsPreByCustom(Dns dns) {
        ArrayList<String> rePreHosts = new ArrayList<String>();
        if (mConcurrentHashMap != null && mConcurrentHashMap.size() > 0) {
            for (String tmpkey : mConcurrentHashMap.keySet()) {
                if (tmpkey == null || tmpkey.length() == 0) continue;
                List<InetAddress> inetAddresses = null;
                try {
                    inetAddresses = dns.lookup(tmpkey);
                    mConcurrentHashMap.put(tmpkey, inetAddresses);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    rePreHosts.add(tmpkey);
                }
            }
        }
        this.rePreFetch(rePreHosts, dns);
    }

    public List<ZoneInfo> getLocalZone() {
        List<ZoneInfo> listZoneInfo = FixedZone.getZoneInfos();
        return listZoneInfo;
    }

    public ZoneInfo getPreQueryZone() {
        ZoneIndex index = ZoneIndex.getFromToken(token);
        ZoneInfo zoneInfo = this.preQueryIndex(index);
        return zoneInfo;
    }

    ZoneInfo preQueryIndex(ZoneIndex index) {
        ZoneInfo info = null;
        try {
            ResponseInfo responseInfo = this.getZoneJsonSync(index);
            if (responseInfo.response == null) {
                return null;
            }
            info = ZoneInfo.buildFromJson(responseInfo.response);
            if (info == null) {
                return null;
            }
            if (info.upDomainsList.size() > 0) {
                if (info.upDomainsList.contains(FixedZone.arrayzone0[0])) {
                    target_region_id = "z0";
                } else if (info.upDomainsList.contains(FixedZone.arrayzone1[0])) {
                    target_region_id = "z1";
                } else if (info.upDomainsList.contains(FixedZone.arrayzone2[0])) {
                    target_region_id = "z2";
                } else if (info.upDomainsList.contains(FixedZone.arrayZoneAs0[0])) {
                    target_region_id = "as0";
                } else if (info.upDomainsList.contains(FixedZone.arrayzoneNa0[0])) {
                    target_region_id = "na";
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        return info;
    }

    ResponseInfo getZoneJsonSync(ZoneIndex index) {
        Client client = new Client();
        String schema = "https://";
        if (!DnsPrefetcher.config.useHttps) {
            schema = "http://";
        }
        String address = schema + Config.preQueryHost + "/v2/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("up_type", "uc_query");
        return client.syncGet(logHandler, address, null);
    }

    public static boolean checkRePrefetchDns(String token, Configuration config) {
        if (mDnsCacheKey.get() == null) {
            return true;
        }
        String currentTime = String.valueOf(System.currentTimeMillis());
        String localip = AndroidNetwork.getHostIP();
        String akScope = StringUtils.getAkAndScope(token);
        if (currentTime == null || localip == null || akScope == null) {
            return true;
        }
        DnsCacheKey dnsCacheKey = (DnsCacheKey)mDnsCacheKey.get();
        if (dnsCacheKey == null || dnsCacheKey.getCurrentTime() == null) {
            return true;
        }
        long cacheTime = (Long.parseLong(currentTime) - Long.parseLong(dnsCacheKey.getCurrentTime())) / 1000L;
        return !localip.equals(dnsCacheKey.getLocalIp()) || cacheTime > config.dnsCacheTimeMs || !akScope.equals(dnsCacheKey.getAkScope());
    }

    public static boolean recoverCache(Configuration config) {
        DnsCacheFile recorder = null;
        try {
            recorder = new DnsCacheFile(Config.dnscacheDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        String dnscache = recorder.getFileName();
        if (dnscache == null) {
            return true;
        }
        byte[] data = recorder.get(dnscache);
        if (data == null) {
            return true;
        }
        DnsCacheKey cacheKey = DnsCacheKey.toCacheKey(dnscache);
        if (cacheKey == null) {
            return true;
        }
        String currentTime = String.valueOf(System.currentTimeMillis());
        String localip = AndroidNetwork.getHostIP();
        if (currentTime == null || localip == null) {
            return true;
        }
        long cacheTime = (Long.parseLong(currentTime) - Long.parseLong(cacheKey.getCurrentTime())) / 1000L;
        if (!cacheKey.getLocalIp().equals(localip) || cacheTime > config.dnsCacheTimeMs) {
            return true;
        }
        mDnsCacheKey.set(cacheKey);
        return DnsPrefetcher.recoverDnsCache(data);
    }

    public static void startPrefetchDns(String token, Configuration config) {
        String currentTime = String.valueOf(System.currentTimeMillis());
        String localip = AndroidNetwork.getHostIP();
        String akScope = StringUtils.getAkAndScope(token);
        if (currentTime == null || localip == null || akScope == null) {
            return;
        }
        DnsCacheKey dnsCacheKey = new DnsCacheKey(currentTime, localip, akScope);
        String cacheKey = dnsCacheKey.toString();
        DnsCacheFile recorder = null;
        DnsPrefetcher dnsPrefetcher = null;
        try {
            recorder = new DnsCacheFile(Config.dnscacheDir);
            dnsPrefetcher = DnsPrefetcher.getDnsPrefetcher().init(token, config);
            mDnsCacheKey.set(dnsCacheKey);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (config.dns != null) {
            DnsPrefetcher.getDnsPrefetcher().dnsPreByCustom(config.dns);
        }
        if (dnsPrefetcher != null) {
            ConcurrentHashMap<String, List<InetAddress>> concurrentHashMap = dnsPrefetcher.getConcurrentHashMap();
            byte[] dnscache = StringUtils.toByteArray(concurrentHashMap);
            if (dnscache == null) {
                return;
            }
            recorder.set(cacheKey, dnscache);
        }
    }

    public static boolean recoverDnsCache(byte[] data) {
        ConcurrentHashMap concurrentHashMap = null;
        try {
            concurrentHashMap = (ConcurrentHashMap)StringUtils.toObject(data);
        }
        catch (Exception e) {
            return true;
        }
        if (concurrentHashMap == null) {
            return true;
        }
        DnsPrefetcher.getDnsPrefetcher().setConcurrentHashMap(concurrentHashMap);
        return false;
    }

    static {
        mConcurrentHashMap = new ConcurrentHashMap();
        mDnsCacheKey = new AtomicReference();
        target_region_id = "";
    }

    static class ZoneIndex {
        final String accessKey;
        final String bucket;

        ZoneIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        static ZoneIndex getFromToken(String token) {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = null;
            try {
                policy = new String(UrlSafeBase64.decode(strings[2]), "utf-8");
                JSONObject obj = new JSONObject(policy);
                String scope = obj.getString("scope");
                String bkt = scope.split(":")[0];
                return new ZoneIndex(ak, bkt);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZoneIndex && ((ZoneIndex)obj).accessKey.equals(this.accessKey) && ((ZoneIndex)obj).bucket.equals(this.bucket);
        }
    }
}

