/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.collect.LogHandler;
import com.qiniu.android.http.Client;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class HttpEventListener
extends EventListener {
    private long callId = 1L;
    private final long callStartNanos;
    private long total_elapsed_time;
    private long dns_elapsed_time;
    private long connect_elapsed_time;
    private long tls_connect_elapsed_time;
    private long request_elapsed_time;
    private long wait_elapsed_time;
    private long response_elapsed_time;
    private Client.ResponseTag responseTag;
    private LogHandler logHandler;
    private long start_dns_elapsed_time;
    private long start_total_elapsed_time;
    private long start_connect_elapsed_time;
    private long start_tls_connect_elapsed_time;
    private long start_request_elapsed_time;
    private long start_response_elapsed_time;
    public static final EventListener.Factory FACTORY = new EventListener.Factory(){
        final AtomicLong nextCallId = new AtomicLong(1L);

        public EventListener create(Call call) {
            long callId = this.nextCallId.getAndIncrement();
            return new HttpEventListener(callId, (Client.ResponseTag)call.request().tag(), System.nanoTime());
        }
    };

    public HttpEventListener(long callId, Client.ResponseTag responseTag, long callStartNanos) {
        this.callId = callId;
        this.callStartNanos = callStartNanos;
        this.responseTag = responseTag;
        this.logHandler = responseTag.logHandler == null ? new LogHandler(){

            @Override
            public void send(String key, Object value) {
            }

            @Override
            public Object getUploadInfo() {
                return null;
            }
        } : responseTag.logHandler;
    }

    public void callStart(Call call) {
        super.callStart(call);
        this.start_total_elapsed_time = System.currentTimeMillis();
    }

    public void dnsStart(Call call, String domainName) {
        super.dnsStart(call, domainName);
        this.start_dns_elapsed_time = System.currentTimeMillis();
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        super.dnsEnd(call, domainName, inetAddressList);
        this.dns_elapsed_time = System.currentTimeMillis() - this.start_dns_elapsed_time;
        this.logHandler.send("dns_elapsed_time", this.dns_elapsed_time);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        this.start_connect_elapsed_time = System.currentTimeMillis();
    }

    public void secureConnectStart(Call call) {
        super.secureConnectStart(call);
        this.start_tls_connect_elapsed_time = System.currentTimeMillis();
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        super.secureConnectEnd(call, handshake);
        this.tls_connect_elapsed_time = System.currentTimeMillis() - this.start_tls_connect_elapsed_time;
        this.logHandler.send("tls_connect_elapsed_time", this.tls_connect_elapsed_time);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.connect_elapsed_time = System.currentTimeMillis() - this.start_connect_elapsed_time;
        this.logHandler.send("connect_elapsed_time", this.connect_elapsed_time);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
    }

    public void connectionAcquired(Call call, Connection connection) {
        super.connectionAcquired(call, connection);
    }

    public void connectionReleased(Call call, Connection connection) {
        super.connectionReleased(call, connection);
    }

    public void requestHeadersStart(Call call) {
        super.requestHeadersStart(call);
        this.start_request_elapsed_time = System.currentTimeMillis();
    }

    public void requestHeadersEnd(Call call, Request request) {
        super.requestHeadersEnd(call, request);
    }

    public void requestBodyStart(Call call) {
        super.requestBodyStart(call);
    }

    public void requestBodyEnd(Call call, long byteCount) {
        super.requestBodyEnd(call, byteCount);
        this.request_elapsed_time = System.currentTimeMillis() - this.start_request_elapsed_time;
        this.logHandler.send("request_elapsed_time", this.request_elapsed_time);
    }

    public void responseHeadersStart(Call call) {
        super.responseHeadersStart(call);
        this.start_response_elapsed_time = System.currentTimeMillis();
    }

    public void responseHeadersEnd(Call call, Response response) {
        super.responseHeadersEnd(call, response);
    }

    public void responseBodyStart(Call call) {
        super.responseBodyStart(call);
    }

    public void responseBodyEnd(Call call, long byteCount) {
        super.responseBodyEnd(call, byteCount);
        this.response_elapsed_time = System.currentTimeMillis() - this.start_response_elapsed_time;
        this.wait_elapsed_time = System.currentTimeMillis() - this.start_request_elapsed_time;
        this.logHandler.send("response_elapsed_time", this.response_elapsed_time);
        this.logHandler.send("wait_elapsed_time", this.wait_elapsed_time);
    }

    public void callEnd(Call call) {
        super.callEnd(call);
        this.total_elapsed_time = System.currentTimeMillis() - this.start_total_elapsed_time;
        this.logHandler.send("total_elapsed_time", this.total_elapsed_time);
    }

    public void callFailed(Call call, IOException ioe) {
        super.callFailed(call, ioe);
    }
}

