/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.AutoZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.http.Dns;
import com.qiniu.android.http.ProxyConfiguration;
import com.qiniu.android.http.UrlConverter;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import java.io.File;

public final class Configuration {
    public static final int BLOCK_SIZE = 0x400000;
    public final Recorder recorder;
    public final KeyGenerator keyGen;
    public final ProxyConfiguration proxy;
    public final int chunkSize;
    public final int putThreshold;
    public final int connectTimeout;
    public final int responseTimeout;
    public final int retryMax;
    public UrlConverter urlConverter;
    public Dns dns;
    public Zone zone;
    public boolean useHttps;
    public long dnsCacheTimeMs;

    private Configuration(Builder builder) {
        this.useHttps = builder.useHttps;
        this.chunkSize = builder.chunkSize;
        this.putThreshold = builder.putThreshold;
        this.connectTimeout = builder.connectTimeout;
        this.responseTimeout = builder.responseTimeout;
        this.recorder = builder.recorder;
        this.keyGen = this.getKeyGen(builder.keyGen);
        this.retryMax = builder.retryMax;
        this.proxy = builder.proxy;
        this.dnsCacheTimeMs = builder.dnsCacheTimeMs;
        this.urlConverter = builder.urlConverter;
        AutoZone autoZone = null;
        autoZone = new AutoZone(builder.useHttps);
        this.zone = builder.zone == null ? autoZone : builder.zone;
        this.dns = builder.dns;
    }

    private KeyGenerator getKeyGen(KeyGenerator keyGen) {
        if (keyGen == null) {
            keyGen = new KeyGenerator(){

                @Override
                public String gen(String key, File file) {
                    return key + "_._" + new StringBuffer(file.getAbsolutePath()).reverse();
                }
            };
        }
        return keyGen;
    }

    public static class Builder {
        private Zone zone = null;
        private Recorder recorder = null;
        private KeyGenerator keyGen = null;
        private ProxyConfiguration proxy = null;
        private boolean useHttps = true;
        private int chunkSize = 0x200000;
        private int putThreshold = 0x400000;
        private int connectTimeout = 10;
        private int responseTimeout = 60;
        private int retryMax = 3;
        private UrlConverter urlConverter = null;
        private Dns dns = null;
        private long dnsCacheTimeMs = 86400000L;

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder recorder(Recorder recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder recorder(Recorder recorder, KeyGenerator keyGen) {
            this.recorder = recorder;
            this.keyGen = keyGen;
            return this;
        }

        public Builder proxy(ProxyConfiguration proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder chunkSize(int size) {
            this.chunkSize = size;
            return this;
        }

        public Builder putThreshhold(int size) {
            this.putThreshold = size;
            return this;
        }

        public Builder connectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Builder responseTimeout(int timeout) {
            this.responseTimeout = timeout;
            return this;
        }

        public Builder retryMax(int times) {
            this.retryMax = times;
            return this;
        }

        public Builder urlConverter(UrlConverter converter) {
            this.urlConverter = converter;
            return this;
        }

        public Builder dns(Dns dns) {
            this.dns = dns;
            return this;
        }

        public Builder useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            return this;
        }

        public Builder dnsCacheTimeMs(long dnsCacheTimeMs) {
            this.dnsCacheTimeMs = dnsCacheTimeMs;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

