/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public final class ProxyConfiguration {
    public final String hostAddress;
    public final int port;
    public final String user;
    public final String password;
    public final Proxy.Type type;

    public ProxyConfiguration(String hostAddress, int port, String user, String password, Proxy.Type type) {
        this.hostAddress = hostAddress;
        this.port = port;
        this.user = user;
        this.password = password;
        this.type = type;
    }

    public ProxyConfiguration(String hostAddress, int port) {
        this(hostAddress, port, null, null, Proxy.Type.HTTP);
    }

    Proxy proxy() {
        return new Proxy(this.type, new InetSocketAddress(this.hostAddress, this.port));
    }

    Authenticator authenticator() {
        return new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)ProxyConfiguration.this.user, (String)ProxyConfiguration.this.password);
                return response.request().newBuilder().header("Proxy-Authorization", credential).header("Proxy-Connection", "Keep-Alive").build();
            }
        };
    }
}

