/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.collect.Config;
import com.qiniu.android.collect.LogHandler;
import com.qiniu.android.collect.UploadInfo;
import com.qiniu.android.collect.UploadInfoCollector;
import com.qiniu.android.collect.UploadInfoElement;
import com.qiniu.android.collect.UploadInfoElementCollector;
import com.qiniu.android.common.Zone;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.DnsPrefetcher;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.FormUploader;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.ResumeUploader;
import com.qiniu.android.storage.ResumeUploaderFast;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.Json;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public final class UploadManager {
    private final Configuration config;
    private final Client client;
    private int multithreads = 1;
    private static int DEF_THREAD_NUM = 3;
    static AtomicBoolean atomicLocalPrefetch = new AtomicBoolean(false);

    public UploadManager() {
        this(new Configuration.Builder().build(), DEF_THREAD_NUM);
    }

    public UploadManager(Configuration config) {
        this.config = config;
        this.client = new Client(config.proxy, config.connectTimeout, config.responseTimeout, config.urlConverter, config.dns);
        this.startLocalPrefetch(config);
    }

    public UploadManager(Configuration config, int multitread) {
        this.config = config;
        this.multithreads = multitread >= 1 ? multitread : DEF_THREAD_NUM;
        this.client = new Client(config.proxy, config.connectTimeout, config.responseTimeout, config.urlConverter, config.dns);
        this.startLocalPrefetch(config);
    }

    public UploadManager(Recorder recorder) {
        this(recorder, null);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGen) {
        this(new Configuration.Builder().recorder(recorder, keyGen).build());
    }

    public UploadManager(Recorder recorder, int multitread) {
        this(recorder, null, multitread);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGen, int multitread) {
        this(new Configuration.Builder().recorder(recorder, keyGen).build(), multitread);
    }

    private void startLocalPrefetch(Configuration config) {
        if (atomicLocalPrefetch.compareAndSet(false, true) && DnsPrefetcher.recoverCache(config)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DnsPrefetcher.getDnsPrefetcher().localFetch();
                }
            }).start();
        }
    }

    private static boolean areInvalidArg(String key, byte[] data, File f, String token, UpToken decodedToken, UpCompletionHandler complete) {
        if (complete == null) {
            throw new IllegalArgumentException("no UpCompletionHandler");
        }
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        ResponseInfo info = null;
        if (message != null) {
            info = ResponseInfo.invalidArgument(message, decodedToken);
        } else if (UpToken.isInvalid(decodedToken)) {
            info = ResponseInfo.invalidToken("invalid token");
        } else if (f != null && f.length() == 0L || data != null && data.length == 0) {
            info = ResponseInfo.zeroSize(decodedToken);
        }
        if (info != null) {
            complete.complete(key, info, null);
            return true;
        }
        return false;
    }

    private static ResponseInfo areInvalidArg(String key, byte[] data, File f, String token, UpToken decodedToken) {
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            return ResponseInfo.invalidArgument(message, decodedToken);
        }
        if (UpToken.isInvalid(decodedToken)) {
            return ResponseInfo.invalidToken("invalid token");
        }
        if (f != null && f.length() == 0L || data != null && data.length == 0) {
            return ResponseInfo.zeroSize(decodedToken);
        }
        return null;
    }

    private static WarpHandler warpHandler(UpCompletionHandler complete, long size) {
        return new WarpHandler(complete, size);
    }

    public void put(final byte[] data, final String key, final String token, final UpCompletionHandler complete, final UploadOptions options) {
        final UpToken decodedToken = UpToken.parse(token);
        if (UploadManager.areInvalidArg(key, data, null, token, decodedToken, complete)) {
            return;
        }
        if (DnsPrefetcher.checkRePrefetchDns(token, this.config)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DnsPrefetcher.startPrefetchDns(token, UploadManager.this.config);
                }
            }).start();
        }
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("up_type", "uc_query");
        Zone z = this.config.zone;
        z.preQuery(logHandler, token, new Zone.QueryHandler(){

            @Override
            public void onSuccess() {
                FormUploader.upload(UploadManager.this.client, UploadManager.this.config, data, key, decodedToken, complete, options);
            }

            @Override
            public void onFailure(int reason) {
                ResponseInfo info = ResponseInfo.isStatusCodeForBrokenNetwork(reason) ? ResponseInfo.networkError(reason, decodedToken) : ResponseInfo.invalidToken("invalid token");
                complete.complete(key, info, null);
            }
        });
    }

    public void put(String filePath, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        this.put(new File(filePath), key, token, completionHandler, options);
    }

    public void put(final File file, final String key, final String token, final UpCompletionHandler complete, final UploadOptions options) {
        final UpToken decodedToken = UpToken.parse(token);
        if (UploadManager.areInvalidArg(key, null, file, token, decodedToken, complete)) {
            return;
        }
        if (DnsPrefetcher.checkRePrefetchDns(token, this.config)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DnsPrefetcher.startPrefetchDns(token, UploadManager.this.config);
                }
            }).start();
        }
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("up_type", "uc_query");
        Zone z = this.config.zone;
        z.preQuery(logHandler, token, new Zone.QueryHandler(){

            @Override
            public void onSuccess() {
                long size = file.length();
                if (size <= (long)((UploadManager)UploadManager.this).config.putThreshold) {
                    FormUploader.upload(UploadManager.this.client, UploadManager.this.config, file, key, decodedToken, complete, options);
                    return;
                }
                String recorderKey = ((UploadManager)UploadManager.this).config.keyGen.gen(key, file);
                WarpHandler completionHandler = UploadManager.warpHandler(complete, file != null ? file.length() : 0L);
                if (UploadManager.this.multithreads == 1) {
                    ResumeUploader uploader = new ResumeUploader(UploadManager.this.client, UploadManager.this.config, file, key, decodedToken, completionHandler, options, recorderKey);
                    AsyncRun.runInMain(uploader);
                } else {
                    ResumeUploaderFast uploader = new ResumeUploaderFast(UploadManager.this.client, UploadManager.this.config, file, key, decodedToken, completionHandler, options, recorderKey, UploadManager.this.multithreads);
                    AsyncRun.runInMain(uploader);
                }
            }

            @Override
            public void onFailure(int reason) {
                ResponseInfo info = ResponseInfo.isStatusCodeForBrokenNetwork(reason) ? ResponseInfo.networkError(reason, decodedToken) : ResponseInfo.invalidToken("invalid token");
                complete.complete(key, info, null);
            }
        });
    }

    public ResponseInfo syncPut(byte[] data, String key, String token, UploadOptions options) {
        UpToken decodedToken = UpToken.parse(token);
        ResponseInfo info = UploadManager.areInvalidArg(key, data, null, token, decodedToken);
        if (info != null) {
            return info;
        }
        return FormUploader.syncUpload(this.client, this.config, data, key, decodedToken, options);
    }

    public ResponseInfo syncPut(File file, String key, String token, UploadOptions options) {
        UpToken decodedToken = UpToken.parse(token);
        ResponseInfo info = UploadManager.areInvalidArg(key, null, file, token, decodedToken);
        if (info != null) {
            return info;
        }
        return FormUploader.syncUpload(this.client, this.config, file, key, decodedToken, options);
    }

    public ResponseInfo syncPut(String file, String key, String token, UploadOptions options) {
        return this.syncPut(new File(file), key, token, options);
    }

    private static class WarpHandler
    implements UpCompletionHandler {
        final UpCompletionHandler complete;
        final long before = System.currentTimeMillis();
        final long size;

        WarpHandler(UpCompletionHandler complete, long size) {
            this.complete = complete;
            this.size = size;
        }

        @Override
        public void complete(final String key, final ResponseInfo res, final JSONObject response) {
            if (Config.isRecord) {
                final long after = System.currentTimeMillis();
                UploadInfoCollector.handleUpload(res.upToken, new UploadInfoCollector.RecordMsg(){

                    @Override
                    public String toRecordMsg() {
                        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getUploadQuality());
                        logHandler.send("result", UploadInfoElement.resultCode(res.statusCode, res.error));
                        logHandler.send("total_elapsed_time", after - WarpHandler.this.before);
                        logHandler.send("requests_counts", ResponseInfo.requests_count);
                        logHandler.send("bytes_sent", ResponseInfo.bytes_sent);
                        logHandler.send("up_time", System.currentTimeMillis() / 1000L);
                        ResponseInfo.requests_count = 0L;
                        ResponseInfo.bytes_sent = 0L;
                        UploadInfoElement.UploadQuality uploadQuality = (UploadInfoElement.UploadQuality)logHandler.getUploadInfo();
                        String quality = Json.object2Json(uploadQuality);
                        return quality;
                    }
                });
            }
            AsyncRun.runInMain(new Runnable(){

                @Override
                public void run() {
                    try {
                        WarpHandler.this.complete.complete(key, res, response);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
    }
}

