/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.os.Process;
import com.qiniu.android.collect.LogHandler;
import com.qiniu.android.collect.UploadInfo;
import com.qiniu.android.collect.UploadInfoCollector;
import com.qiniu.android.collect.UploadInfoElement;
import com.qiniu.android.collect.UploadInfoElementCollector;
import com.qiniu.android.http.Client;
import com.qiniu.android.http.CompletionHandler;
import com.qiniu.android.http.DnsPrefetcher;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpCancellationSignal;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.Crc32;
import com.qiniu.android.utils.Json;
import com.qiniu.android.utils.StringMap;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.UrlSafeBase64;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ResumeUploader
implements Runnable {
    private final long totalSize;
    private final String key;
    private final UpCompletionHandler completionHandler;
    private final UploadOptions options;
    private final Client client;
    private final Configuration config;
    private final byte[] chunkBuffer;
    private final String[] contexts;
    private final StringMap headers;
    private final long modifyTime;
    private final String recorderKey;
    private RandomAccessFile file;
    private File f;
    private long crc32;
    private UpToken token;
    private long recover_from;

    ResumeUploader(Client client, Configuration config, File f, String key, UpToken token, final UpCompletionHandler completionHandler, UploadOptions options, String recorderKey) {
        this.client = client;
        this.config = config;
        this.f = f;
        this.recorderKey = recorderKey;
        this.totalSize = f.length();
        this.key = key;
        this.headers = new StringMap().put("Authorization", "UpToken " + token.token);
        this.file = null;
        this.completionHandler = new UpCompletionHandler(){

            @Override
            public void complete(String key, ResponseInfo info, JSONObject response) {
                if (ResumeUploader.this.file != null) {
                    try {
                        ResumeUploader.this.file.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                completionHandler.complete(key, info, response);
            }
        };
        this.options = options != null ? options : UploadOptions.defaultOptions();
        this.chunkBuffer = new byte[config.chunkSize];
        long count = (this.totalSize + 0x400000L - 1L) / 0x400000L;
        this.contexts = new String[(int)count];
        this.modifyTime = f.lastModified();
        this.token = token;
    }

    private static boolean isChunkOK(ResponseInfo info, JSONObject response) {
        return info.statusCode == 200 && info.error == null && (info.hasReqId() || ResumeUploader.isChunkResOK(response));
    }

    private static boolean isChunkResOK(JSONObject response) {
        try {
            response.getString("ctx");
            response.getLong("crc32");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean isNotChunkToQiniu(ResponseInfo info, JSONObject response) {
        return info.statusCode < 500 && info.statusCode >= 200 && !info.hasReqId() && !ResumeUploader.isChunkResOK(response);
    }

    @Override
    public void run() {
        long offset = this.recoveryFromRecord();
        if (offset > 0L) {
            this.recover_from = offset;
        }
        try {
            this.file = new RandomAccessFile(this.f, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e, this.token), null);
            return;
        }
        this.nextTask(offset, 0, this.config.zone.upHost(this.token.token, this.config.useHttps, null));
    }

    private void makeBlock(String upHost, long offset, int blockSize, int chunkSize, ProgressHandler progress, CompletionHandler _completionHandler, UpCancellationSignal c) {
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("target_key", this.key);
        logHandler.send("up_type", "mkblk");
        logHandler.send("tid", Process.myTid());
        logHandler.send("file_offset", offset);
        logHandler.send("bytes_total", chunkSize);
        String path = String.format(Locale.ENGLISH, "/mkblk/%d", blockSize);
        try {
            this.file.seek(offset);
            this.file.read(this.chunkBuffer, 0, chunkSize);
        }
        catch (IOException e) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e, this.token), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, chunkSize);
        String postUrl = String.format("%s%s", upHost, path);
        this.post(logHandler, postUrl, this.chunkBuffer, 0, chunkSize, progress, _completionHandler, c);
    }

    private void putChunk(String upHost, long offset, int chunkSize, String context, ProgressHandler progress, CompletionHandler _completionHandler, UpCancellationSignal c) {
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("target_key", this.key);
        logHandler.send("up_type", "bput");
        logHandler.send("tid", Process.myTid());
        logHandler.send("file_offset", offset);
        logHandler.send("bytes_total", chunkSize);
        int chunkOffset = (int)(offset % 0x400000L);
        String path = String.format(Locale.ENGLISH, "/bput/%s/%d", context, chunkOffset);
        try {
            this.file.seek(offset);
            this.file.read(this.chunkBuffer, 0, chunkSize);
        }
        catch (IOException e) {
            this.completionHandler.complete(this.key, ResponseInfo.fileError(e, this.token), null);
            return;
        }
        this.crc32 = Crc32.bytes(this.chunkBuffer, 0, chunkSize);
        String postUrl = String.format("%s%s", upHost, path);
        this.post(logHandler, postUrl, this.chunkBuffer, 0, chunkSize, progress, _completionHandler, c);
    }

    private void makeFile(String upHost, CompletionHandler _completionHandler, UpCancellationSignal c) {
        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getReqInfo());
        logHandler.send("target_key", this.key);
        logHandler.send("up_type", "mkfile");
        logHandler.send("tid", Process.myTid());
        String mime = String.format(Locale.ENGLISH, "/mimeType/%s/fname/%s", UrlSafeBase64.encodeToString(this.options.mimeType), UrlSafeBase64.encodeToString(this.f.getName()));
        String keyStr = "";
        if (this.key != null) {
            keyStr = String.format("/key/%s", UrlSafeBase64.encodeToString(this.key));
        }
        String paramStr = "";
        if (this.options.params.size() != 0) {
            String[] str = new String[this.options.params.size()];
            int j = 0;
            for (Map.Entry<String, String> i : this.options.params.entrySet()) {
                str[j++] = String.format(Locale.ENGLISH, "%s/%s", i.getKey(), UrlSafeBase64.encodeToString(i.getValue()));
            }
            paramStr = "/" + StringUtils.join(str, "/");
        }
        String path = String.format(Locale.ENGLISH, "/mkfile/%d%s%s%s", this.totalSize, mime, keyStr, paramStr);
        String bodyStr = StringUtils.join(this.contexts, ",");
        byte[] data = bodyStr.getBytes();
        String postUrl = String.format("%s%s", upHost, path);
        logHandler.send("file_offset", 0);
        logHandler.send("bytes_total", data.length);
        this.post(logHandler, postUrl, data, 0, data.length, null, _completionHandler, c);
    }

    private void post(LogHandler logHandler, String upHost, byte[] data, int offset, int dataSize, ProgressHandler progress, CompletionHandler completion, UpCancellationSignal c) {
        this.client.asyncPost(logHandler, upHost, data, offset, dataSize, this.headers, this.token, this.totalSize, progress, completion, c);
    }

    private long calcPutSize(long offset) {
        long left = this.totalSize - offset;
        return left < (long)this.config.chunkSize ? left : (long)this.config.chunkSize;
    }

    private long calcBlockSize(long offset) {
        long left = this.totalSize - offset;
        return left < 0x400000L ? left : 0x400000L;
    }

    private boolean isCancelled() {
        return this.options.cancellationSignal.isCancelled();
    }

    private void nextTask(final long offset, final int retried, final String upHost) {
        if (this.isCancelled()) {
            ResponseInfo i = ResponseInfo.cancelled(this.token);
            this.completionHandler.complete(this.key, i, null);
            return;
        }
        if (offset == this.totalSize) {
            CompletionHandler complete = new CompletionHandler(){

                @Override
                public void complete(ResponseInfo info, JSONObject response) {
                    String upHostRetry;
                    if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                        ((ResumeUploader)ResumeUploader.this).options.netReadyHandler.waitReady();
                        if (!AndroidNetwork.isNetWorkReady()) {
                            ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                            return;
                        }
                    }
                    if (info.isOK()) {
                        ResumeUploader.this.removeRecord();
                        ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, 1.0);
                        ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                        return;
                    }
                    if (info.needRetry() && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax + 1 && (upHostRetry = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, upHost)) != null) {
                        ResumeUploader.this.nextTask(offset, retried + 1, upHostRetry);
                        return;
                    }
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                }
            };
            this.makeFile(upHost, complete, this.options.cancellationSignal);
            return;
        }
        final int chunkSize = (int)this.calcPutSize(offset);
        ProgressHandler progress = new ProgressHandler(){

            @Override
            public void onProgress(long bytesWritten, long totalSize) {
                double percent = (double)(offset + bytesWritten) / (double)totalSize;
                if (percent > 0.95) {
                    percent = 0.95;
                }
                ((ResumeUploader)ResumeUploader.this).options.progressHandler.progress(ResumeUploader.this.key, percent);
            }
        };
        CompletionHandler complete = new CompletionHandler(){

            @Override
            public void complete(final ResponseInfo info, JSONObject response) {
                final long tid = Process.myTid();
                UploadInfoCollector.handleHttp(ResumeUploader.this.token, new UploadInfoCollector.RecordMsg(){

                    @Override
                    public String toRecordMsg() {
                        LogHandler logHandler = UploadInfoElementCollector.getUplogHandler(UploadInfo.getBlockInfo());
                        UpToken.setCurrent_region_id(logHandler, upHost);
                        logHandler.send("target_region_id", DnsPrefetcher.target_region_id);
                        logHandler.send("total_elapsed_time", info.duration);
                        logHandler.send("bytes_sent", info.sent);
                        logHandler.send("recovered_from", ResumeUploader.this.recover_from);
                        logHandler.send("file_size", ResumeUploader.this.totalSize);
                        logHandler.send("pid", Process.myPid());
                        logHandler.send("tid", tid);
                        logHandler.send("up_api_version", 1);
                        logHandler.send("up_time", System.currentTimeMillis() / 1000L);
                        UploadInfoElement.BlockInfo blockInfo = (UploadInfoElement.BlockInfo)logHandler.getUploadInfo();
                        String upBlock = Json.object2Json(blockInfo);
                        return upBlock;
                    }
                });
                if (info.isNetworkBroken() && !AndroidNetwork.isNetWorkReady()) {
                    ((ResumeUploader)ResumeUploader.this).options.netReadyHandler.waitReady();
                    if (!AndroidNetwork.isNetWorkReady()) {
                        ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                        return;
                    }
                }
                if (info.isCancelled()) {
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                    return;
                }
                if (!ResumeUploader.isChunkOK(info, response)) {
                    String upHostRetry = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, upHost);
                    if (info.statusCode == 701 && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                        ResumeUploader.this.nextTask(offset / 0x400000L * 0x400000L, retried + 1, upHost);
                        return;
                    }
                    if (upHostRetry != null && (ResumeUploader.isNotChunkToQiniu(info, response) || info.needRetry()) && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                        ResumeUploader.this.nextTask(offset, retried + 1, upHostRetry);
                        return;
                    }
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info, response);
                    return;
                }
                String context = null;
                if (response == null && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                    String upHostRetry = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, upHost);
                    ResumeUploader.this.nextTask(offset, retried + 1, upHostRetry);
                    return;
                }
                long crc = 0L;
                Exception tempE = null;
                try {
                    context = response.getString("ctx");
                    crc = response.getLong("crc32");
                }
                catch (Exception e) {
                    tempE = e;
                    e.printStackTrace();
                }
                if ((context == null || crc != ResumeUploader.this.crc32) && retried < ((ResumeUploader)ResumeUploader.this).config.retryMax) {
                    String upHostRetry = ((ResumeUploader)ResumeUploader.this).config.zone.upHost(((ResumeUploader)ResumeUploader.this).token.token, ((ResumeUploader)ResumeUploader.this).config.useHttps, upHost);
                    ResumeUploader.this.nextTask(offset, retried + 1, upHostRetry);
                    return;
                }
                if (context == null) {
                    String error = "get context failed.";
                    if (tempE != null) {
                        error = error + "\n";
                        error = error + tempE.getMessage();
                    }
                    ResponseInfo info2 = ResponseInfo.errorInfo(info, 0, error);
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info2, response);
                    return;
                }
                if (crc != ResumeUploader.this.crc32) {
                    String error = "block's crc32 is not match. local: " + ResumeUploader.this.crc32 + ", remote: " + crc;
                    ResponseInfo info2 = ResponseInfo.errorInfo(info, -406, error);
                    ResumeUploader.this.completionHandler.complete(ResumeUploader.this.key, info2, response);
                    return;
                }
                ((ResumeUploader)ResumeUploader.this).contexts[(int)(offset / 0x400000L)] = context;
                ResumeUploader.this.record(offset + (long)chunkSize);
                ResumeUploader.this.nextTask(offset + (long)chunkSize, retried, upHost);
            }
        };
        if (offset % 0x400000L == 0L) {
            int blockSize = (int)this.calcBlockSize(offset);
            this.makeBlock(upHost, offset, blockSize, chunkSize, progress, complete, this.options.cancellationSignal);
            return;
        }
        String context = this.contexts[(int)(offset / 0x400000L)];
        this.putChunk(upHost, offset, chunkSize, context, progress, complete, this.options.cancellationSignal);
    }

    private long recoveryFromRecord() {
        JSONObject obj;
        if (this.config.recorder == null) {
            return 0L;
        }
        byte[] data = this.config.recorder.get(this.recorderKey);
        if (data == null) {
            return 0L;
        }
        String jsonStr = new String(data);
        try {
            obj = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0L;
        }
        long offset = obj.optLong("offset", 0L);
        long modify = obj.optLong("modify_time", 0L);
        long fSize = obj.optLong("size", 0L);
        JSONArray array = obj.optJSONArray("contexts");
        if (offset == 0L || modify != this.modifyTime || fSize != this.totalSize || array == null || array.length() == 0) {
            return 0L;
        }
        for (int i = 0; i < array.length(); ++i) {
            this.contexts[i] = array.optString(i);
        }
        return offset;
    }

    private void removeRecord() {
        if (this.config.recorder != null) {
            this.config.recorder.del(this.recorderKey);
        }
    }

    private void record(long offset) {
        if (this.config.recorder == null || offset == 0L) {
            return;
        }
        String data = String.format(Locale.ENGLISH, "{\"size\":%d,\"offset\":%d, \"modify_time\":%d, \"contexts\":[%s]}", this.totalSize, offset, this.modifyTime, StringUtils.jsonJoin(this.contexts));
        this.config.recorder.set(this.recorderKey, data.getBytes());
    }

    private URI newURI(URI uri, String path) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return uri;
        }
    }
}

