/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.utils.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DnsCacheInfo
implements Serializable {
    public String currentTime;
    public String localIp;
    public ConcurrentHashMap<String, List<IDnsNetworkAddress>> info;

    public static DnsCacheInfo createDnsCacheInfoByData(byte[] jsonData) {
        if (jsonData == null) {
            return null;
        }
        Object dnsCacheInfo = StringUtils.toObject(jsonData);
        if (dnsCacheInfo instanceof DnsCacheInfo) {
            return (DnsCacheInfo)dnsCacheInfo;
        }
        return null;
    }

    public DnsCacheInfo() {
    }

    public DnsCacheInfo(String currentTime, String localIp, ConcurrentHashMap<String, List<IDnsNetworkAddress>> info) {
        this.currentTime = currentTime;
        this.localIp = localIp;
        this.info = info;
    }

    String getCurrentTime() {
        return this.currentTime;
    }

    String getLocalIp() {
        return this.localIp;
    }

    public ConcurrentHashMap<String, List<IDnsNetworkAddress>> getInfo() {
        return this.info;
    }

    void setCurrentTime(String currentTime) {
        this.currentTime = currentTime;
    }

    void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public void setInfo(ConcurrentHashMap<String, List<IDnsNetworkAddress>> info) {
        this.info = info;
    }

    public String cacheKey() {
        return this.localIp;
    }

    public byte[] toJsonData() {
        return StringUtils.toByteArray(this);
    }

    public String toString() {
        return "{\"currentTime\":\"" + this.currentTime + "\", \"localIp\":\"" + this.localIp + "\"}";
    }
}

