/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request;

import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UploadFileInfo {
    public final long size;
    public final long modifyTime;
    public final ArrayList<UploadBlock> uploadBlocks;

    private UploadFileInfo(long size, long modifyTime, ArrayList<UploadBlock> uploadBlocks) {
        this.size = size;
        this.modifyTime = modifyTime;
        this.uploadBlocks = uploadBlocks;
    }

    public UploadFileInfo(long fileSize, long blockSize, long dataSize, long modifyTime) {
        this.size = fileSize;
        this.modifyTime = modifyTime;
        this.uploadBlocks = this.createBlocks(blockSize, dataSize);
    }

    public static UploadFileInfo fileFromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        long size = 0L;
        long modifyTime = 0L;
        ArrayList<UploadBlock> uploadBlocks = new ArrayList<UploadBlock>();
        try {
            size = jsonObject.getLong("size");
            modifyTime = jsonObject.getLong("modifyTime");
            JSONArray blockJsonArray = jsonObject.getJSONArray("uploadBlocks");
            for (int i = 0; i < blockJsonArray.length(); ++i) {
                JSONObject blockJson = blockJsonArray.getJSONObject(i);
                UploadBlock block = UploadBlock.blockFromJson(blockJson);
                if (block == null) continue;
                uploadBlocks.add(block);
            }
        }
        catch (JSONException blockJsonArray) {
            // empty catch block
        }
        UploadFileInfo fileInfo = new UploadFileInfo(size, modifyTime, uploadBlocks);
        return fileInfo;
    }

    private ArrayList<UploadBlock> createBlocks(long blockSize, long dataSize) {
        long offset = 0L;
        int blockIndex = 0;
        ArrayList<UploadBlock> blocks = new ArrayList<UploadBlock>();
        while (offset < this.size) {
            long lastSize = this.size - offset;
            long blockSizeP = Math.min(lastSize, blockSize);
            UploadBlock block = new UploadBlock(offset, blockSizeP, dataSize, blockIndex);
            if (block == null) continue;
            blocks.add(block);
            offset += blockSizeP;
            ++blockIndex;
        }
        return blocks;
    }

    public double progress() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return 0.0;
        }
        double progress = 0.0;
        for (UploadBlock block : this.uploadBlocks) {
            progress += block.progress() * ((double)block.size / (double)this.size);
        }
        return progress;
    }

    public UploadData nextUploadData() {
        UploadBlock block;
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return null;
        }
        UploadData data = null;
        Iterator<UploadBlock> iterator = this.uploadBlocks.iterator();
        while (iterator.hasNext() && (data = (block = iterator.next()).nextUploadData()) == null) {
        }
        return data;
    }

    public void clearUploadState() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return;
        }
        for (UploadBlock block : this.uploadBlocks) {
            block.clearUploadState();
        }
    }

    public UploadBlock blockWithIndex(int blockIndex) {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return null;
        }
        UploadBlock block = null;
        if (blockIndex < this.uploadBlocks.size()) {
            block = this.uploadBlocks.get(blockIndex);
        }
        return block;
    }

    public boolean isAllUploaded() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return true;
        }
        boolean isAllUploaded = true;
        for (UploadBlock block : this.uploadBlocks) {
            if (block.isCompleted()) continue;
            isAllUploaded = false;
            break;
        }
        return isAllUploaded;
    }

    public ArrayList<String> allBlocksContexts() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return null;
        }
        ArrayList<String> contexts = new ArrayList<String>();
        for (UploadBlock block : this.uploadBlocks) {
            if (block.context == null) continue;
            contexts.add(block.context);
        }
        return contexts;
    }

    public JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("size", this.size);
            jsonObject.put("modifyTime", this.modifyTime);
            if (this.uploadBlocks != null && this.uploadBlocks.size() > 0) {
                JSONArray blockJsonArray = new JSONArray();
                for (UploadBlock block : this.uploadBlocks) {
                    JSONObject blockJson = block.toJsonObject();
                    if (blockJson == null) continue;
                    blockJsonArray.put((Object)blockJson);
                }
                jsonObject.put("uploadBlocks", (Object)blockJsonArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public static class UploadBlock {
        public final long offset;
        public final long size;
        public final int index;
        public final ArrayList<UploadData> uploadDataList;
        public String context;

        public UploadBlock(long offset, long blockSize, long dataSize, int index) {
            this.offset = offset;
            this.size = blockSize;
            this.index = index;
            this.uploadDataList = this.createDataList(dataSize);
        }

        private UploadBlock(long offset, long blockSize, int index, ArrayList<UploadData> uploadDataList) {
            this.offset = offset;
            this.size = blockSize;
            this.index = index;
            this.uploadDataList = uploadDataList;
        }

        public static UploadBlock blockFromJson(JSONObject jsonObject) {
            if (jsonObject == null) {
                return null;
            }
            long offset = 0L;
            long size = 0L;
            int index = 0;
            String context = null;
            ArrayList<UploadData> uploadDataList = new ArrayList<UploadData>();
            try {
                offset = jsonObject.getLong("offset");
                size = jsonObject.getLong("size");
                index = jsonObject.getInt("index");
                context = jsonObject.getString("context");
                JSONArray dataJsonArray = jsonObject.getJSONArray("uploadDataList");
                for (int i = 0; i < dataJsonArray.length(); ++i) {
                    JSONObject dataJson = dataJsonArray.getJSONObject(i);
                    UploadData data = UploadData.dataFromJson(dataJson);
                    if (data == null) continue;
                    uploadDataList.add(data);
                }
            }
            catch (JSONException dataJsonArray) {
                // empty catch block
            }
            UploadBlock block = new UploadBlock(offset, size, index, uploadDataList);
            if (context != null && context.length() > 0) {
                block.context = context;
            }
            return block;
        }

        public boolean isCompleted() {
            if (this.uploadDataList == null) {
                return true;
            }
            boolean isCompleted = true;
            for (UploadData data : this.uploadDataList) {
                if (data.isCompleted) continue;
                isCompleted = false;
                break;
            }
            return isCompleted;
        }

        public double progress() {
            if (this.uploadDataList == null) {
                return 0.0;
            }
            double progress = 0.0;
            for (UploadData data : this.uploadDataList) {
                progress += data.progress * ((double)data.size / (double)this.size);
            }
            return progress;
        }

        private ArrayList<UploadData> createDataList(long dataSize) {
            long offset = 0L;
            int dataIndex = 0;
            ArrayList<UploadData> datas = new ArrayList<UploadData>();
            while (offset < this.size) {
                long lastSize = this.size - offset;
                long dataSizeP = Math.min(lastSize, dataSize);
                UploadData data = new UploadData(offset, dataSizeP, dataIndex, this.index);
                if (data == null) continue;
                datas.add(data);
                offset += dataSizeP;
                ++dataIndex;
            }
            return datas;
        }

        public JSONObject toJsonObject() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("offset", this.offset);
                jsonObject.put("size", this.size);
                jsonObject.put("index", this.index);
                jsonObject.put("context", (Object)(this.context != null ? this.context : ""));
                if (this.uploadDataList != null && this.uploadDataList.size() > 0) {
                    JSONArray dataJsonArray = new JSONArray();
                    for (UploadData data : this.uploadDataList) {
                        JSONObject dataJson = data.toJsonObject();
                        if (dataJson == null) continue;
                        dataJsonArray.put((Object)dataJson);
                    }
                    jsonObject.put("uploadDataList", (Object)dataJsonArray);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jsonObject;
        }

        protected UploadData nextUploadData() {
            if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
                return null;
            }
            UploadData data = null;
            for (UploadData dataP : this.uploadDataList) {
                if (dataP.isCompleted || dataP.isUploading) continue;
                data = dataP;
                break;
            }
            return data;
        }

        protected void clearUploadState() {
            if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
                return;
            }
            for (UploadData data : this.uploadDataList) {
                data.clearUploadState();
            }
        }
    }

    public static class UploadData {
        public final long offset;
        public final long size;
        public final int index;
        public final int blockIndex;
        public boolean isCompleted;
        public boolean isUploading;
        public double progress;

        public UploadData(long offset, long size, int index, int blockIndex) {
            this.offset = offset;
            this.size = size;
            this.index = index;
            this.blockIndex = blockIndex;
            this.isCompleted = false;
            this.isUploading = false;
            this.progress = 0.0;
        }

        public static UploadData dataFromJson(JSONObject jsonObject) {
            if (jsonObject == null) {
                return null;
            }
            long offset = 0L;
            long size = 0L;
            int index = 0;
            int blockIndex = 0;
            boolean isCompleted = false;
            double progress = 0.0;
            try {
                offset = jsonObject.getLong("offset");
                size = jsonObject.getLong("size");
                index = jsonObject.getInt("index");
                blockIndex = jsonObject.getInt("blockIndex");
                isCompleted = jsonObject.getBoolean("isCompleted");
                progress = jsonObject.getDouble("progress");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            UploadData uploadData = new UploadData(offset, size, index, blockIndex);
            uploadData.isCompleted = isCompleted;
            uploadData.progress = progress;
            return uploadData;
        }

        public boolean isFirstData() {
            return this.index == 0;
        }

        public void clearUploadState() {
            this.isCompleted = false;
            this.isUploading = false;
        }

        private JSONObject toJsonObject() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("offset", this.offset);
                jsonObject.put("size", this.size);
                jsonObject.put("index", this.index);
                jsonObject.put("blockIndex", this.blockIndex);
                jsonObject.put("isCompleted", this.isCompleted);
                jsonObject.put("progress", this.progress);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return jsonObject;
        }
    }
}

