/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request.httpclient;

import com.qiniu.android.http.CancellationHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ProxyConfiguration;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.SystemDns;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.request.IRequestClient;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.http.request.httpclient.ByteBody;
import com.qiniu.android.http.request.httpclient.CountingRequestBody;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.StringUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Connection;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class SystemHttpClient
implements IRequestClient {
    public static final String ContentTypeHeader = "Content-Type";
    public static final String DefaultMime = "application/octet-stream";
    public static final String JsonMime = "application/json";
    public static final String FormMime = "application/x-www-form-urlencoded";
    private OkHttpClient httpClient;
    private Call call;
    private UploadSingleRequestMetrics metrics;

    @Override
    public void request(final Request request, boolean isAsync, ProxyConfiguration connectionProxy, IRequestClient.RequestClientProgress progress, final IRequestClient.RequestClientCompleteHandler complete) {
        this.metrics = new UploadSingleRequestMetrics();
        this.metrics.request = request;
        this.httpClient = this.createHttpClient(request, connectionProxy);
        Request.Builder requestBuilder = this.createRequestBuilder(request, progress);
        if (requestBuilder == null) {
            ResponseInfo responseInfo = ResponseInfo.invalidArgument("invalid http request");
            this.handleError(request, responseInfo.statusCode, responseInfo.message, complete);
            return;
        }
        ResponseTag tag = new ResponseTag();
        this.call = this.httpClient.newCall(requestBuilder.tag((Object)tag).build());
        if (isAsync) {
            this.call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    e.printStackTrace();
                    String msg = e.getMessage();
                    int status = SystemHttpClient.this.getStatusCodeByException(e);
                    if (call.isCanceled()) {
                        status = -2;
                        msg = "user cancelled";
                    }
                    SystemHttpClient.this.handleError(request, status, msg, complete);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    SystemHttpClient.this.handleResponse(request, response, complete);
                }
            });
        } else {
            try {
                Response response = this.call.execute();
                this.handleResponse(request, response, complete);
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = e.getMessage();
                int status = this.getStatusCodeByException(e);
                if (this.call.isCanceled()) {
                    status = -2;
                    msg = "user cancelled";
                }
                this.handleError(request, status, msg, complete);
            }
        }
    }

    @Override
    public synchronized void cancel() {
        if (this.call != null && !this.call.isCanceled()) {
            this.call.cancel();
        }
    }

    private OkHttpClient createHttpClient(final Request request, ProxyConfiguration connectionProxy) {
        if (request == null) {
            return null;
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (connectionProxy != null) {
            clientBuilder.proxy(connectionProxy.proxy());
            if (connectionProxy.user != null && connectionProxy.password != null) {
                clientBuilder.proxyAuthenticator(connectionProxy.authenticator());
            }
        }
        clientBuilder.eventListener(this.createEventLister());
        clientBuilder.dns(new Dns(){

            public List<InetAddress> lookup(String s) throws UnknownHostException {
                if (request.getInetAddress() != null && s.equals(request.host)) {
                    ArrayList<InetAddress> inetAddressList = new ArrayList<InetAddress>();
                    inetAddressList.add(request.getInetAddress());
                    return inetAddressList;
                }
                return new SystemDns().lookupInetAddress(s);
            }
        });
        clientBuilder.networkInterceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                okhttp3.Request request = chain.request();
                long before = System.currentTimeMillis();
                Response response = chain.proceed(request);
                long after = System.currentTimeMillis();
                ResponseTag tag = (ResponseTag)request.tag();
                String ip = "";
                try {
                    ip = chain.connection().socket().getRemoteSocketAddress().toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tag.ip = ip;
                tag.duration = after - before;
                return response;
            }
        });
        clientBuilder.connectTimeout((long)request.timeout, TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)request.timeout, TimeUnit.SECONDS);
        clientBuilder.writeTimeout(0L, TimeUnit.SECONDS);
        return clientBuilder.build();
    }

    private Request.Builder createRequestBuilder(Request request, final IRequestClient.RequestClientProgress progress) {
        if (request == null) {
            return null;
        }
        Headers allHeaders = Headers.of(request.allHeaders);
        Request.Builder requestBuilder = null;
        if (request.httpMethod.equals("GET")) {
            requestBuilder = new Request.Builder().get().url(request.urlString);
            for (String key : request.allHeaders.keySet()) {
                String value = request.allHeaders.get(key);
                requestBuilder.header(key, value);
            }
        } else if (request.httpMethod.equals("POST")) {
            RequestBody rbody;
            requestBuilder = new Request.Builder().url(request.urlString);
            requestBuilder = requestBuilder.headers(allHeaders);
            if (request.httpBody.length > 0) {
                MediaType type = MediaType.parse((String)DefaultMime);
                String contentType = request.allHeaders.get(ContentTypeHeader);
                if (contentType != null) {
                    type = MediaType.parse((String)contentType);
                }
                rbody = new ByteBody(type, request.httpBody);
            } else {
                rbody = new ByteBody(null, new byte[0]);
            }
            rbody = new CountingRequestBody(rbody, new ProgressHandler(){

                @Override
                public void onProgress(long bytesWritten, long totalSize) {
                    if (progress != null) {
                        progress.progress(bytesWritten, totalSize);
                    }
                }
            }, request.httpBody.length, null);
            requestBuilder = requestBuilder.post(rbody);
        }
        return requestBuilder;
    }

    private EventListener createEventLister() {
        return new EventListener(){

            public void callStart(Call call) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.startDate = new Date();
            }

            public void dnsStart(Call call, String domainName) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.domainLookupStartDate = new Date();
            }

            public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.domainLookupEndDate = new Date();
            }

            public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.connectStartDate = new Date();
                ((SystemHttpClient)SystemHttpClient.this).metrics.remoteAddress = inetSocketAddress.getAddress().getHostAddress();
                ((SystemHttpClient)SystemHttpClient.this).metrics.remotePort = inetSocketAddress.getPort();
                ((SystemHttpClient)SystemHttpClient.this).metrics.localAddress = AndroidNetwork.getHostIP();
            }

            public void secureConnectStart(Call call) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.connectEndDate = new Date();
            }

            public void secureConnectEnd(Call call, Handshake handshake) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.secureConnectionStartDate = new Date();
            }

            public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.secureConnectionEndDate = new Date();
            }

            public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.connectEndDate = new Date();
            }

            public void connectionAcquired(Call call, Connection connection) {
            }

            public void connectionReleased(Call call, Connection connection) {
            }

            public void requestHeadersStart(Call call) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.requestStartDate = new Date();
            }

            public void requestHeadersEnd(Call call, okhttp3.Request request) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.countOfRequestHeaderBytesSent = request.headers().toString().length();
            }

            public void requestBodyStart(Call call) {
            }

            public void requestBodyEnd(Call call, long byteCount) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.requestEndDate = new Date();
                ((SystemHttpClient)SystemHttpClient.this).metrics.countOfRequestBodyBytesSent = byteCount;
            }

            public void requestFailed(Call call, IOException ioe) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.requestEndDate = new Date();
                ((SystemHttpClient)SystemHttpClient.this).metrics.countOfRequestBodyBytesSent = 0L;
            }

            public void responseHeadersStart(Call call) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.responseStartDate = new Date();
            }

            public void responseHeadersEnd(Call call, Response response) {
            }

            public void responseBodyStart(Call call) {
            }

            public void responseBodyEnd(Call call, long byteCount) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.responseEndDate = new Date();
            }

            public void responseFailed(Call call, IOException ioe) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.responseEndDate = new Date();
            }

            public void callEnd(Call call) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.endDate = new Date();
            }

            public void callFailed(Call call, IOException ioe) {
                ((SystemHttpClient)SystemHttpClient.this).metrics.endDate = new Date();
            }
        };
    }

    private synchronized void handleError(Request request, int responseCode, String errorMsg, IRequestClient.RequestClientCompleteHandler complete) {
        ResponseInfo info;
        if (this.metrics == null || this.metrics.response != null) {
            return;
        }
        this.metrics.response = info = ResponseInfo.create(request, responseCode, null, null, errorMsg);
        complete.complete(info, this.metrics, info.response);
        this.releaseResource();
    }

    private synchronized void handleResponse(Request request, Response response, IRequestClient.RequestClientCompleteHandler complete) {
        ResponseInfo info;
        if (this.metrics == null || this.metrics.response != null) {
            return;
        }
        int statusCode = response.code();
        HashMap<String, String> responseHeader = new HashMap<String, String>();
        int headerCount = response.headers().size();
        for (int i = 0; i < headerCount; ++i) {
            String name = response.headers().name(i).toLowerCase();
            String value = response.headers().value(i);
            responseHeader.put(name, value);
        }
        byte[] responseBody = null;
        JSONObject responseJson = null;
        String errorMessage = null;
        try {
            responseBody = response.body().bytes();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        if (responseBody == null) {
            errorMessage = response.message();
        } else if (SystemHttpClient.responseContentType(response) != JsonMime) {
            String responseString = new String(responseBody);
            if (responseString.length() > 0) {
                try {
                    responseJson = new JSONObject(responseString);
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                responseJson = SystemHttpClient.buildJsonResp(responseBody);
            }
            catch (Exception e) {
                statusCode = -1015;
                errorMessage = e.getMessage();
            }
        }
        this.metrics.response = info = ResponseInfo.create(request, statusCode, responseHeader, responseJson, errorMessage);
        complete.complete(info, this.metrics, info.response);
        this.releaseResource();
    }

    private void releaseResource() {
        this.httpClient = null;
        this.call = null;
    }

    private static String responseContentType(Response response) {
        MediaType mediaType = response.body().contentType();
        if (mediaType == null) {
            return "";
        }
        return mediaType.type() + "/" + mediaType.subtype();
    }

    private int getStatusCodeByException(Exception e) {
        int statusCode = -1;
        String msg = e.getMessage();
        if (msg != null && msg.contains("Canceled")) {
            statusCode = -2;
        } else if (e instanceof CancellationHandler.CancellationException) {
            statusCode = -2;
        } else if (e instanceof UnknownHostException) {
            statusCode = -1003;
        } else if (msg != null && msg.indexOf("Broken pipe") == 0) {
            statusCode = -1005;
        } else if (e instanceof SocketTimeoutException) {
            statusCode = -1001;
        } else if (e instanceof ConnectException) {
            statusCode = -1004;
        } else if (e instanceof ProtocolException) {
            statusCode = 100;
        }
        return statusCode;
    }

    private static JSONObject buildJsonResp(byte[] body) throws Exception {
        String str = new String(body, "utf-8");
        if (StringUtils.isNullOrEmpty(str)) {
            return new JSONObject();
        }
        return new JSONObject(str);
    }

    private static class ResponseTag {
        public String ip = "";
        public long duration = -1L;

        private ResponseTag() {
        }
    }
}

