/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.dns.DnsManager;
import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.http.DnspodFree;
import com.qiniu.android.http.dns.Dns;
import com.qiniu.android.http.dns.DnsNetworkAddress;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.http.dns.SystemDns;
import com.qiniu.android.utils.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class HappyDns
implements Dns {
    private DnsManager dnsManager;

    public HappyDns() {
        IResolver[] resolvers = new IResolver[]{new SystemResolver(), new DnspodFree()};
        this.dnsManager = new DnsManager(NetworkInfo.normal, resolvers);
    }

    void setQueryErrorHandler(DnsQueryErrorHandler handler) {
        this.dnsManager.queryErrorHandler = handler;
    }

    @Override
    public List<IDnsNetworkAddress> lookup(String hostname) throws UnknownHostException {
        Domain domain = new Domain(hostname);
        ArrayList<DnsNetworkAddress> addressList = null;
        try {
            Record[] records = this.dnsManager.queryRecords(domain);
            if (records != null && records.length > 0) {
                addressList = new ArrayList<DnsNetworkAddress>();
                for (Record record : records) {
                    String source = "";
                    source = record.source == Record.Source.System ? "system" : (record.source == Record.Source.DnspodFree || record.source == Record.Source.DnspodEnterprise ? "httpdns" : (record.source == Record.Source.Unknown ? "none" : "customized"));
                    DnsNetworkAddress address = new DnsNetworkAddress(hostname, record.value, Long.valueOf(record.ttl), source, record.timeStamp);
                    addressList.add(address);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return addressList;
    }

    private static class SystemResolver
    implements IResolver {
        private SystemResolver() {
        }

        public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
            long timestamp = Utils.currentTimestamp();
            int ttl = 120;
            ArrayList<Record> records = new ArrayList<Record>();
            List<InetAddress> inetAddresses = new SystemDns().lookupInetAddress(domain.domain);
            for (InetAddress inetAddress : inetAddresses) {
                Record record = new Record(inetAddress.getHostAddress(), 1, ttl, timestamp, Record.Source.System);
                records.add(record);
            }
            return records.toArray(new Record[0]);
        }
    }

    static interface DnsQueryErrorHandler
    extends DnsManager.QueryErrorHandler {
    }
}

