/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.metrics;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.request.Request;
import java.util.Date;
import org.json.JSONObject;

public class UploadSingleRequestMetrics {
    public Request request;
    public ResponseInfo response;
    public Date startDate;
    public Date endDate;
    public Date domainLookupStartDate;
    public Date domainLookupEndDate;
    public Date connectStartDate;
    public Date connectEndDate;
    public Date secureConnectionStartDate;
    public Date secureConnectionEndDate;
    public Date requestStartDate;
    public Date requestEndDate;
    public Date responseStartDate;
    public Date responseEndDate;
    public long countOfRequestHeaderBytesSent = 0L;
    public long countOfRequestBodyBytesSent = 0L;
    public long countOfResponseHeaderBytesReceived = 0L;
    public long countOfResponseBodyBytesReceived = 0L;
    public String localAddress;
    public Integer localPort;
    public String remoteAddress;
    public Integer remotePort;

    public Long totalElapsedTime() {
        return this.time(this.startDate, this.endDate);
    }

    public Long totalDnsTime() {
        return this.time(this.domainLookupStartDate, this.domainLookupEndDate);
    }

    public Long totalConnectTime() {
        return this.time(this.connectStartDate, this.connectEndDate);
    }

    public Long totalSecureConnectTime() {
        return this.time(this.secureConnectionStartDate, this.secureConnectionEndDate);
    }

    public Long totalRequestTime() {
        return this.time(this.requestStartDate, this.requestEndDate);
    }

    public Long totalWaitTime() {
        return this.time(this.requestEndDate, this.responseStartDate);
    }

    public Long totalResponseTime() {
        return this.time(this.responseStartDate, this.responseEndDate);
    }

    public Long totalBytes() {
        long headerLength = 0L;
        long bodyLength = 0L;
        if (this.request.allHeaders != null) {
            headerLength = new JSONObject(this.request.allHeaders).toString().length();
        }
        if (this.request.httpBody != null) {
            bodyLength = this.request.httpBody.length;
        }
        return headerLength + bodyLength;
    }

    public Long bytesSend() {
        long bytesSend = this.countOfRequestHeaderBytesSent + this.countOfRequestBodyBytesSent;
        long totalBytes = this.totalBytes();
        if (bytesSend > totalBytes) {
            bytesSend = totalBytes;
        }
        return bytesSend;
    }

    private Long time(Date startDate, Date endDate) {
        if (startDate != null && endDate != null) {
            return endDate.getTime() - startDate.getTime();
        }
        return null;
    }
}

