/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.UploadFileInfo;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.PartsUpload;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.GroupTaskThread;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

class ConcurrentResumeUpload
extends PartsUpload {
    private GroupTaskThread groupTaskThread;
    private double previousPercent;
    private ArrayList<RequestTransaction> uploadTransactions;
    private ResponseInfo uploadBlockErrorResponseInfo;
    private JSONObject uploadBlockErrorResponse;

    protected ConcurrentResumeUpload(File file, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, BaseUpload.UpTaskCompletionHandler completionHandler) {
        super(file, key, token, option, config, recorder, recorderKey, completionHandler);
    }

    @Override
    protected int prepareToUpload() {
        this.chunkSize = blockSize;
        return super.prepareToUpload();
    }

    @Override
    protected void startToUpload() {
        this.previousPercent = 0.0;
        this.uploadTransactions = new ArrayList();
        this.uploadBlockErrorResponseInfo = null;
        this.uploadBlockErrorResponse = null;
        GroupTaskThread.GroupTaskCompleteHandler completeHandler = new GroupTaskThread.GroupTaskCompleteHandler(){

            @Override
            public void complete() {
                UploadFileInfo uploadFileInfo = ConcurrentResumeUpload.this.getUploadFileInfo();
                if (!uploadFileInfo.isAllUploaded() || ConcurrentResumeUpload.this.uploadBlockErrorResponseInfo != null) {
                    if (ConcurrentResumeUpload.this.uploadBlockErrorResponseInfo.couldRetry() && ConcurrentResumeUpload.this.config.allowBackupHost) {
                        boolean isSwitched = ConcurrentResumeUpload.this.switchRegionAndUpload();
                        if (!isSwitched) {
                            ConcurrentResumeUpload.this.completeAction(ConcurrentResumeUpload.this.uploadBlockErrorResponseInfo, ConcurrentResumeUpload.this.uploadBlockErrorResponse);
                        }
                    } else {
                        ConcurrentResumeUpload.this.completeAction(ConcurrentResumeUpload.this.uploadBlockErrorResponseInfo, ConcurrentResumeUpload.this.uploadBlockErrorResponse);
                    }
                } else {
                    ConcurrentResumeUpload.this.makeFile(new UploadFileCompleteHandler(){

                        @Override
                        public void complete(ResponseInfo responseInfo, JSONObject response) {
                            if (responseInfo == null || !responseInfo.isOK()) {
                                boolean isSwitched = ConcurrentResumeUpload.this.switchRegionAndUpload();
                                if (!isSwitched) {
                                    ConcurrentResumeUpload.this.completeAction(responseInfo, response);
                                }
                            } else {
                                AsyncRun.runInMain(new Runnable(){

                                    @Override
                                    public void run() {
                                        ConcurrentResumeUpload.this.option.progressHandler.progress(ConcurrentResumeUpload.this.key, 1.0);
                                    }
                                });
                                ConcurrentResumeUpload.this.removeUploadInfoRecord();
                                ConcurrentResumeUpload.this.completeAction(responseInfo, response);
                            }
                        }
                    });
                }
            }
        };
        this.groupTaskThread = new GroupTaskThread(completeHandler);
        for (int i = 0; i < this.config.concurrentTaskCount; ++i) {
            this.groupTaskThread.addTask(new GroupTaskThread.GroupTask(){

                @Override
                public void run(final GroupTaskThread.GroupTask task) {
                    ConcurrentResumeUpload.this.uploadRestBlock(new UploadBlockCompleteHandler(){

                        @Override
                        public void complete() {
                            task.taskComplete();
                        }
                    });
                }
            });
        }
        this.groupTaskThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadRestBlock(UploadBlockCompleteHandler completeHandler) {
        final UploadFileInfo uploadFileInfo = this.getUploadFileInfo();
        if (uploadFileInfo == null) {
            if (this.uploadBlockErrorResponseInfo == null) {
                this.uploadBlockErrorResponseInfo = ResponseInfo.invalidArgument("file error");
                this.uploadBlockErrorResponse = this.uploadBlockErrorResponseInfo.response;
            }
            completeHandler.complete();
            return;
        }
        IUploadRegion currentRegion = this.getCurrentRegion();
        if (currentRegion == null) {
            if (this.uploadBlockErrorResponseInfo == null) {
                this.uploadBlockErrorResponseInfo = ResponseInfo.invalidArgument("server error");
                this.uploadBlockErrorResponse = this.uploadBlockErrorResponseInfo.response;
            }
            completeHandler.complete();
            return;
        }
        ConcurrentResumeUpload concurrentResumeUpload = this;
        synchronized (concurrentResumeUpload) {
            final UploadFileInfo.UploadData chunk = uploadFileInfo.nextUploadData();
            UploadFileInfo.UploadBlock block = chunk != null ? uploadFileInfo.blockWithIndex(chunk.blockIndex) : null;
            RequestProgressHandler progressHandler = new RequestProgressHandler(){

                @Override
                public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                    chunk.progress = (double)totalBytesWritten / (double)totalBytesExpectedToWrite;
                    double percent = uploadFileInfo.progress();
                    if (percent > 0.95) {
                        percent = 0.95;
                    }
                    if (percent > ConcurrentResumeUpload.this.previousPercent) {
                        ConcurrentResumeUpload.this.previousPercent = percent;
                    } else {
                        percent = ConcurrentResumeUpload.this.previousPercent;
                    }
                    ConcurrentResumeUpload.this.option.progressHandler.progress(ConcurrentResumeUpload.this.key, percent);
                }
            };
            if (chunk != null) {
                this.makeBlock(block, chunk, progressHandler, completeHandler);
            } else {
                completeHandler.complete();
            }
        }
    }

    private void makeBlock(final UploadFileInfo.UploadBlock block, final UploadFileInfo.UploadData chunk, RequestProgressHandler progressHandler, final UploadBlockCompleteHandler completeHandler) {
        byte[] chunkData = this.getDataWithChunk(chunk, block);
        if (chunkData == null) {
            this.uploadBlockErrorResponseInfo = ResponseInfo.localIOError("get chunk data error");
            this.uploadBlockErrorResponse = this.uploadBlockErrorResponseInfo.response;
            completeHandler.complete();
            return;
        }
        chunk.isUploading = true;
        chunk.isCompleted = false;
        RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.makeBlock(block.offset, block.size, chunkData, true, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                ConcurrentResumeUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                String blockContext = null;
                if (response != null) {
                    try {
                        blockContext = response.getString("ctx");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && blockContext != null) {
                    block.context = blockContext;
                    chunk.isUploading = false;
                    chunk.isCompleted = true;
                    ConcurrentResumeUpload.this.recordUploadInfo();
                    ConcurrentResumeUpload.this.uploadRestBlock(completeHandler);
                } else {
                    chunk.isUploading = false;
                    chunk.isCompleted = false;
                    ConcurrentResumeUpload.this.uploadBlockErrorResponse = response;
                    ConcurrentResumeUpload.this.uploadBlockErrorResponseInfo = responseInfo;
                    completeHandler.complete();
                }
            }
        });
    }

    private void makeFile(final UploadFileCompleteHandler completeHandler) {
        UploadFileInfo uploadFileInfo = this.getUploadFileInfo();
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        ArrayList<String> contextsList = uploadFileInfo.allBlocksContexts();
        String[] contexts = contextsList.toArray(new String[contextsList.size()]);
        transaction.makeFile(uploadFileInfo.size, this.fileName, contexts, true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                ConcurrentResumeUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                ConcurrentResumeUpload.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, response);
            }
        });
    }

    private RequestTransaction createUploadRequestTransaction() {
        RequestTransaction transaction = new RequestTransaction(this.config, this.option, this.getTargetRegion(), this.getCurrentRegion(), this.key, this.token);
        this.uploadTransactions.add(transaction);
        return transaction;
    }

    private void destroyUploadRequestTransaction(RequestTransaction transaction) {
        if (transaction != null) {
            this.uploadTransactions.remove(transaction);
        }
    }

    private byte[] getDataWithChunk(UploadFileInfo.UploadData chunk, UploadFileInfo.UploadBlock block) {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile();
        if (randomAccessFile == null || chunk == null || block == null) {
            return null;
        }
        byte[] data = new byte[(int)chunk.size];
        try {
            randomAccessFile.seek(chunk.offset + block.offset);
            randomAccessFile.read(data, 0, (int)chunk.size);
        }
        catch (IOException e) {
            data = null;
        }
        return data;
    }

    private static interface UploadBlockCompleteHandler {
        public void complete();
    }

    private static interface UploadFileCompleteHandler {
        public void complete(ResponseInfo var1, JSONObject var2);
    }
}

