/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.UploadFileInfo;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.PartsUpload;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

class ResumeUpload
extends PartsUpload {
    private double previousPercent;
    private RequestTransaction uploadTransaction;
    private ResponseInfo uploadChunkErrorResponseInfo;
    private JSONObject uploadChunkErrorResponse;

    protected ResumeUpload(File file, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, BaseUpload.UpTaskCompletionHandler completionHandler) {
        super(file, key, token, option, config, recorder, recorderKey, completionHandler);
    }

    @Override
    protected void startToUpload() {
        this.previousPercent = 0.0;
        this.uploadChunkErrorResponseInfo = null;
        this.uploadChunkErrorResponse = null;
        this.uploadRestChunk(new UploadChunkCompleteHandler(){

            @Override
            public void complete() {
                UploadFileInfo uploadFileInfo = ResumeUpload.this.getUploadFileInfo();
                if (!uploadFileInfo.isAllUploaded() || ResumeUpload.this.uploadChunkErrorResponseInfo != null) {
                    if (ResumeUpload.this.uploadChunkErrorResponseInfo.couldRetry() && ResumeUpload.this.config.allowBackupHost) {
                        boolean isSwitched = ResumeUpload.this.switchRegionAndUpload();
                        if (!isSwitched) {
                            ResumeUpload.this.completeAction(ResumeUpload.this.uploadChunkErrorResponseInfo, ResumeUpload.this.uploadChunkErrorResponse);
                        }
                    } else {
                        ResumeUpload.this.completeAction(ResumeUpload.this.uploadChunkErrorResponseInfo, ResumeUpload.this.uploadChunkErrorResponse);
                    }
                } else {
                    ResumeUpload.this.makeFile(new UploadFileCompleteHandler(){

                        @Override
                        public void complete(ResponseInfo responseInfo, JSONObject response) {
                            if (responseInfo == null || !responseInfo.isOK()) {
                                boolean isSwitched = ResumeUpload.this.switchRegionAndUpload();
                                if (!isSwitched) {
                                    ResumeUpload.this.completeAction(responseInfo, response);
                                }
                            } else {
                                AsyncRun.runInMain(new Runnable(){

                                    @Override
                                    public void run() {
                                        ResumeUpload.this.option.progressHandler.progress(ResumeUpload.this.key, 1.0);
                                    }
                                });
                                ResumeUpload.this.removeUploadInfoRecord();
                                ResumeUpload.this.completeAction(responseInfo, response);
                            }
                        }
                    });
                }
            }
        });
    }

    private void uploadRestChunk(UploadChunkCompleteHandler completeHandler) {
        final UploadFileInfo uploadFileInfo = this.getUploadFileInfo();
        if (uploadFileInfo == null) {
            if (this.uploadChunkErrorResponseInfo == null) {
                this.uploadChunkErrorResponseInfo = ResponseInfo.invalidArgument("file error");
                this.uploadChunkErrorResponse = this.uploadChunkErrorResponseInfo.response;
            }
            completeHandler.complete();
            return;
        }
        IUploadRegion currentRegion = this.getCurrentRegion();
        if (currentRegion == null) {
            if (this.uploadChunkErrorResponseInfo == null) {
                this.uploadChunkErrorResponseInfo = ResponseInfo.invalidArgument("server error");
                this.uploadChunkErrorResponse = this.uploadChunkErrorResponseInfo.response;
            }
            completeHandler.complete();
            return;
        }
        final UploadFileInfo.UploadData chunk = uploadFileInfo.nextUploadData();
        UploadFileInfo.UploadBlock block = chunk != null ? uploadFileInfo.blockWithIndex(chunk.blockIndex) : null;
        RequestProgressHandler progressHandler = new RequestProgressHandler(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                chunk.progress = (double)totalBytesWritten / (double)totalBytesExpectedToWrite;
                double percent = uploadFileInfo.progress();
                if (percent > 0.95) {
                    percent = 0.95;
                }
                if (percent > ResumeUpload.this.previousPercent) {
                    ResumeUpload.this.previousPercent = percent;
                } else {
                    percent = ResumeUpload.this.previousPercent;
                }
                ResumeUpload.this.option.progressHandler.progress(ResumeUpload.this.key, percent);
            }
        };
        if (chunk == null) {
            completeHandler.complete();
        } else if (chunk.isFirstData()) {
            this.makeBlock(block, chunk, progressHandler, completeHandler);
        } else {
            this.uploadChunk(block, chunk, progressHandler, completeHandler);
        }
    }

    private void makeBlock(final UploadFileInfo.UploadBlock block, final UploadFileInfo.UploadData chunk, RequestProgressHandler progressHandler, final UploadChunkCompleteHandler completeHandler) {
        byte[] chunkData = this.getDataWithChunk(chunk, block);
        if (chunkData == null) {
            this.uploadChunkErrorResponseInfo = ResponseInfo.localIOError("get chunk data error");
            this.uploadChunkErrorResponse = this.uploadChunkErrorResponseInfo.response;
            completeHandler.complete();
            return;
        }
        chunk.isUploading = true;
        chunk.isCompleted = false;
        RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.makeBlock(block.offset, block.size, chunkData, true, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                ResumeUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                String blockContext = null;
                if (response != null) {
                    try {
                        blockContext = response.getString("ctx");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && blockContext != null) {
                    block.context = blockContext;
                    chunk.isUploading = false;
                    chunk.isCompleted = true;
                    ResumeUpload.this.recordUploadInfo();
                    ResumeUpload.this.uploadRestChunk(completeHandler);
                } else {
                    chunk.isUploading = false;
                    chunk.isCompleted = false;
                    ResumeUpload.this.uploadChunkErrorResponse = response;
                    ResumeUpload.this.uploadChunkErrorResponseInfo = responseInfo;
                    completeHandler.complete();
                }
            }
        });
    }

    private void uploadChunk(final UploadFileInfo.UploadBlock block, final UploadFileInfo.UploadData chunk, RequestProgressHandler progressHandler, final UploadChunkCompleteHandler completeHandler) {
        byte[] chunkData = this.getDataWithChunk(chunk, block);
        if (chunkData == null) {
            this.uploadChunkErrorResponseInfo = ResponseInfo.localIOError("get chunk data error");
            this.uploadChunkErrorResponse = this.uploadChunkErrorResponseInfo.response;
            completeHandler.complete();
            return;
        }
        chunk.isUploading = true;
        chunk.isCompleted = false;
        RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.uploadChunk(block.context, block.offset, chunkData, chunk.offset, true, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                ResumeUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                String blockContext = null;
                if (response != null) {
                    try {
                        blockContext = response.getString("ctx");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && blockContext != null) {
                    block.context = blockContext;
                    chunk.isUploading = false;
                    chunk.isCompleted = true;
                    ResumeUpload.this.recordUploadInfo();
                    ResumeUpload.this.uploadRestChunk(completeHandler);
                } else {
                    chunk.isUploading = false;
                    chunk.isCompleted = false;
                    ResumeUpload.this.uploadChunkErrorResponse = response;
                    ResumeUpload.this.uploadChunkErrorResponseInfo = responseInfo;
                    completeHandler.complete();
                }
            }
        });
    }

    private void makeFile(final UploadFileCompleteHandler completeHandler) {
        UploadFileInfo uploadFileInfo = this.getUploadFileInfo();
        RequestTransaction transaction = this.createUploadRequestTransaction();
        ArrayList<String> contextsList = uploadFileInfo.allBlocksContexts();
        if (contextsList == null || contextsList.size() == 0) {
            ResponseInfo responseInfo = ResponseInfo.invalidArgument("block ctx invalid");
            completeHandler.complete(responseInfo, responseInfo.response);
            return;
        }
        String[] contexts = contextsList.toArray(new String[contextsList.size()]);
        transaction.makeFile(uploadFileInfo.size, this.fileName, contexts, true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                ResumeUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                completeHandler.complete(responseInfo, response);
            }
        });
    }

    private RequestTransaction createUploadRequestTransaction() {
        RequestTransaction transaction;
        this.uploadTransaction = transaction = new RequestTransaction(this.config, this.option, this.getTargetRegion(), this.getCurrentRegion(), this.key, this.token);
        return transaction;
    }

    private byte[] getDataWithChunk(UploadFileInfo.UploadData chunk, UploadFileInfo.UploadBlock block) {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile();
        if (randomAccessFile == null || chunk == null || block == null) {
            return null;
        }
        byte[] data = new byte[(int)chunk.size];
        try {
            randomAccessFile.seek(chunk.offset + block.offset);
            randomAccessFile.read(data, 0, (int)chunk.size);
        }
        catch (IOException e) {
            data = null;
        }
        return data;
    }

    private static interface UploadChunkCompleteHandler {
        public void complete();
    }

    private static interface UploadFileCompleteHandler {
        public void complete(ResponseInfo var1, JSONObject var2);
    }
}

