/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.collect;

import com.qiniu.android.collect.ReportConfig;
import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONObject;

public class UploadInfoReporter {
    private ReportConfig config = ReportConfig.getInstance();
    private long lastReportTime = 0L;
    private File recordDirectory;
    private File recorderFile;
    private File recorderTempFile;
    private String X_Log_Client_Id;
    private RequestTransaction transaction;
    private boolean isReporting;
    private static UploadInfoReporter instance = new UploadInfoReporter();

    private UploadInfoReporter() {
        this.recordDirectory = new File(this.config.recordDirectory);
        this.recorderFile = new File(this.config.recordDirectory + "/qiniu.log");
        this.recorderTempFile = new File(this.config.recordDirectory + "/qiniuTemp.log");
        this.isReporting = false;
    }

    public static UploadInfoReporter getInstance() {
        return instance;
    }

    public synchronized void report(ReportItem reportItem, final String tokenString) {
        if (reportItem == null) {
            return;
        }
        final String jsonString = reportItem.toJson();
        if (!this.checkReportAvailable() || jsonString == null) {
            return;
        }
        AsyncRun.runInBack(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    UploadInfoReporter.this.saveReportJsonString(jsonString);
                    UploadInfoReporter.this.reportToServerIfNeeded(tokenString);
                }
            }
        });
    }

    public void clean() {
        this.cleanRecorderFile();
        this.cleanTempLogFile();
    }

    private void cleanRecorderFile() {
        if (this.recorderFile.exists()) {
            this.recorderFile.delete();
        }
    }

    private void cleanTempLogFile() {
        if (this.recorderTempFile.exists()) {
            this.recorderTempFile.delete();
        }
    }

    private boolean checkReportAvailable() {
        if (!this.config.isReportEnable) {
            return false;
        }
        if (this.config.maxRecordFileSize <= this.config.uploadThreshold) {
            LogUtil.e("maxRecordFileSize must be larger than uploadThreshold");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReportJsonString(String jsonString) {
        if (!this.recordDirectory.exists() && !this.recordDirectory.mkdirs()) {
            return;
        }
        if (!this.recordDirectory.isDirectory()) {
            LogUtil.e("recordDirectory is not a directory");
            return;
        }
        if (!this.recorderFile.exists()) {
            try {
                boolean isSuccess = this.recorderFile.createNewFile();
                if (!isSuccess) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.recorderFile.length() > this.config.maxRecordFileSize) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.recorderFile, true);
            fos.write((jsonString + "\n").getBytes());
            fos.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void reportToServerIfNeeded(String tokenString) {
        boolean isSuccess;
        if (this.isReporting) {
            return;
        }
        boolean needToReport = false;
        long currentTime = new Date().getTime();
        if (this.recorderTempFile.exists()) {
            needToReport = true;
        } else if ((this.recorderFile.length() > this.config.uploadThreshold || this.lastReportTime == 0L || currentTime - this.lastReportTime > this.config.interval * 60L) && (isSuccess = this.recorderFile.renameTo(this.recorderTempFile))) {
            needToReport = true;
        }
        if (needToReport && !this.isReporting) {
            this.reportToServer(tokenString);
        }
    }

    private void reportToServer(String tokenString) {
        this.isReporting = true;
        RequestTransaction transaction = this.createUploadRequestTransaction(tokenString);
        if (transaction == null) {
            return;
        }
        byte[] logData = this.getLogData();
        if (logData == null || logData.length == 0) {
            return;
        }
        transaction.reportLog(logData, this.X_Log_Client_Id, true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo.isOK()) {
                    UploadInfoReporter.this.lastReportTime = new Date().getTime();
                    if (UploadInfoReporter.this.X_Log_Client_Id == null && responseInfo.responseHeader != null && responseInfo.responseHeader.get("x-log-client-id") != null) {
                        UploadInfoReporter.this.X_Log_Client_Id = responseInfo.responseHeader.get("x-log-client-id");
                    }
                    UploadInfoReporter.this.cleanTempLogFile();
                }
                UploadInfoReporter.this.isReporting = false;
                UploadInfoReporter.this.destroyTransactionResource();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getLogData() {
        if (this.recorderTempFile == null || this.recorderTempFile.length() == 0L) {
            return null;
        }
        int fileSize = (int)this.recorderTempFile.length();
        RandomAccessFile randomAccessFile = null;
        byte[] data = null;
        try {
            randomAccessFile = new RandomAccessFile(this.recorderTempFile, "r");
            ByteArrayOutputStream out = new ByteArrayOutputStream(fileSize);
            int len = 0;
            byte[] buff = new byte[fileSize];
            while ((len = randomAccessFile.read(buff)) >= 0) {
                out.write(buff, 0, len);
            }
            data = out.toByteArray();
        }
        catch (FileNotFoundException out) {
        }
        catch (IOException e) {
            data = null;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return data;
    }

    private RequestTransaction createUploadRequestTransaction(String tokenString) {
        if (this.config == null) {
            return null;
        }
        UpToken token = UpToken.parse(tokenString);
        if (token == null) {
            return null;
        }
        ArrayList<String> hosts = new ArrayList<String>();
        hosts.add(this.config.serverURL);
        this.transaction = new RequestTransaction(hosts, "sdkEmptyRegionId", token);
        return this.transaction;
    }

    private void destroyTransactionResource() {
        this.transaction = null;
    }
}

