/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.metrics;

import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import java.util.ArrayList;

public class UploadRegionRequestMetrics {
    public final IUploadRegion region;
    private ArrayList<UploadSingleRequestMetrics> metricsList = new ArrayList();

    public UploadRegionRequestMetrics(IUploadRegion region) {
        this.region = region;
    }

    public long totalElapsedTime() {
        if (this.metricsList.size() == 0) {
            return 0L;
        }
        long time = 0L;
        for (UploadSingleRequestMetrics metrics : this.metricsList) {
            if (metrics == null) continue;
            time += metrics.totalElapsedTime();
        }
        return time;
    }

    public Integer requestCount() {
        return this.metricsList.size();
    }

    public Long bytesSend() {
        if (this.metricsList.size() == 0) {
            return 0L;
        }
        long bytes = 0L;
        for (UploadSingleRequestMetrics metrics : this.metricsList) {
            if (metrics == null) continue;
            bytes += metrics.bytesSend().longValue();
        }
        return bytes;
    }

    public void addMetricsList(ArrayList<UploadSingleRequestMetrics> metricsList) {
        if (metricsList == null || metricsList.size() == 0) {
            return;
        }
        for (UploadSingleRequestMetrics metrics : metricsList) {
            if (metrics == null) continue;
            this.metricsList.add(metrics);
        }
    }

    public void addMetrics(UploadRegionRequestMetrics metrics) {
        String metricsRegionId;
        if (metrics == null || metrics.region == null || metrics.region.getZoneInfo() == null || metrics.region.getZoneInfo().regionId == null || this.region == null || this.region.getZoneInfo() == null || this.region.getZoneInfo().regionId == null || metrics.metricsList == null || metrics.metricsList.size() == 0) {
            return;
        }
        String thisRegionId = metrics.region.getZoneInfo().getRegionId();
        if (thisRegionId.equals(metricsRegionId = metrics.region.getZoneInfo().getRegionId())) {
            this.addMetricsList(metrics.metricsList);
        }
    }
}

